/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.media.tv.CommandResponse;
import android.media.tv.DsmccResponse;
import android.media.tv.PesResponse;
import android.media.tv.SectionResponse;
import android.media.tv.SignalingDataResponse;
import android.media.tv.StreamEventResponse;
import android.media.tv.TableResponse;
import android.media.tv.TimelineResponse;
import android.media.tv.TsResponse;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"ParcelNotFinal"})
public abstract class BroadcastInfoResponse
implements Parcelable {
    public static final int RESPONSE_RESULT_ERROR = 1;
    public static final int RESPONSE_RESULT_OK = 2;
    public static final int RESPONSE_RESULT_CANCEL = 3;
    @NonNull
    public static final Parcelable.Creator<BroadcastInfoResponse> CREATOR = new Parcelable.Creator<BroadcastInfoResponse>(){

        @Override
        public BroadcastInfoResponse createFromParcel(Parcel source) {
            int type = source.readInt();
            switch (type) {
                case 1: {
                    return TsResponse.createFromParcelBody(source);
                }
                case 2: {
                    return TableResponse.createFromParcelBody(source);
                }
                case 3: {
                    return SectionResponse.createFromParcelBody(source);
                }
                case 4: {
                    return PesResponse.createFromParcelBody(source);
                }
                case 5: {
                    return StreamEventResponse.createFromParcelBody(source);
                }
                case 6: {
                    return DsmccResponse.createFromParcelBody(source);
                }
                case 7: {
                    return CommandResponse.createFromParcelBody(source);
                }
                case 8: {
                    return TimelineResponse.createFromParcelBody(source);
                }
                case 9: {
                    return SignalingDataResponse.createFromParcelBody(source);
                }
            }
            throw new IllegalStateException("Unexpected broadcast info response type (value " + type + ") in parcel.");
        }

        public BroadcastInfoResponse[] newArray(int size) {
            return new BroadcastInfoResponse[size];
        }
    };
    private final int mType;
    private final int mRequestId;
    private final int mSequence;
    private final int mResponseResult;

    BroadcastInfoResponse(int type, int requestId, int sequence, int responseResult) {
        this.mType = type;
        this.mRequestId = requestId;
        this.mSequence = sequence;
        this.mResponseResult = responseResult;
    }

    BroadcastInfoResponse(int type, Parcel source) {
        this.mType = type;
        this.mRequestId = source.readInt();
        this.mSequence = source.readInt();
        this.mResponseResult = source.readInt();
    }

    public int getType() {
        return this.mType;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public int getSequence() {
        return this.mSequence;
    }

    public int getResponseResult() {
        return this.mResponseResult;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mRequestId);
        dest.writeInt(this.mSequence);
        dest.writeInt(this.mResponseResult);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResponseResult {
    }
}

