/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.hardware.soundtrigger.ConversionUtil;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.soundtrigger.Phrase;
import android.media.soundtrigger.PhraseRecognitionExtra;
import android.media.soundtrigger.RecognitionConfig;
import android.media.soundtrigger.SoundModel;
import android.media.soundtrigger.SoundTriggerManager;
import android.media.soundtrigger_middleware.IAcknowledgeEvent;
import android.media.soundtrigger_middleware.IInjectGlobalEvent;
import android.media.soundtrigger_middleware.IInjectModelEvent;
import android.media.soundtrigger_middleware.IInjectRecognitionEvent;
import android.media.soundtrigger_middleware.ISoundTriggerInjection;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.ISoundTriggerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class SoundTriggerInstrumentation {
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private IInjectGlobalEvent mInjectGlobalEvent = null;
    @GuardedBy(value={"mLock"})
    private Map<IBinder, ModelSession> mModelSessionMap = new HashMap<IBinder, ModelSession>();
    @GuardedBy(value={"mLock"})
    private Map<IBinder, RecognitionSession> mRecognitionSessionMap = new HashMap<IBinder, RecognitionSession>();
    @GuardedBy(value={"mLock"})
    private IBinder mClientToken = null;
    private final ISoundTriggerService mService;
    private final GlobalCallback mClientCallback;
    private final Executor mGlobalCallbackExecutor;

    @RequiresPermission(value="android.permission.MANAGE_SOUND_TRIGGER")
    public SoundTriggerInstrumentation(ISoundTriggerService service, @NonNull Executor executor, @NonNull GlobalCallback callback) {
        this.mClientCallback = Objects.requireNonNull(callback);
        this.mGlobalCallbackExecutor = Objects.requireNonNull(executor);
        this.mService = service;
        try {
            service.attachInjection(new Injection());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerRestart() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInjectGlobalEvent == null) {
                throw new IllegalStateException("Attempted to trigger HAL restart before registration");
            }
            try {
                this.mInjectGlobalEvent.triggerRestart();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerOnResourcesAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInjectGlobalEvent == null) {
                throw new IllegalStateException("Attempted to trigger HAL resources available before registration");
            }
            try {
                this.mInjectGlobalEvent.triggerOnResourcesAvailable();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceContention(boolean isResourceContended) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInjectGlobalEvent == null) {
                throw new IllegalStateException("Injection interface not set up");
            }
            IInjectGlobalEvent current = this.mInjectGlobalEvent;
            final CountDownLatch signal = new CountDownLatch(1);
            try {
                current.setResourceContention(isResourceContended, new IAcknowledgeEvent.Stub(this){

                    @Override
                    public void eventReceived() {
                        signal.countDown();
                    }
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            try {
                signal.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setInPhoneCallState(boolean isInPhoneCall) {
        try {
            this.mService.setInPhoneCallState(isInPhoneCall);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface GlobalCallback {
        default public void onPreempted() {
        }

        default public void onRestarted() {
        }

        default public void onFrameworkDetached() {
        }

        default public void onClientAttached() {
        }

        default public void onClientDetached() {
        }

        public void onModelLoaded(@NonNull ModelSession var1);
    }

    private class Injection
    extends ISoundTriggerInjection.Stub {
        private Injection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerGlobalEventInjection(IInjectGlobalEvent globalInjection) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                SoundTriggerInstrumentation.this.mInjectGlobalEvent = globalInjection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSoundModelLoaded(SoundModel model, @Nullable Phrase[] phrases, IInjectModelEvent modelInjection, IInjectGlobalEvent globalSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (globalSession.asBinder() != SoundTriggerInstrumentation.this.mInjectGlobalEvent.asBinder()) {
                    return;
                }
                ModelSession modelSession = new ModelSession(model, phrases, modelInjection);
                SoundTriggerInstrumentation.this.mModelSessionMap.put(modelInjection.asBinder(), modelSession);
                SoundTriggerInstrumentation.this.mGlobalCallbackExecutor.execute(() -> SoundTriggerInstrumentation.this.mClientCallback.onModelLoaded(modelSession));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSoundModelUnloaded(IInjectModelEvent modelSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                ModelSession clientModelSession = SoundTriggerInstrumentation.this.mModelSessionMap.remove(modelSession.asBinder());
                if (clientModelSession == null) {
                    return;
                }
                clientModelSession.wrap(cb -> cb.onModelUnloaded());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRecognitionStarted(int audioSessionHandle, RecognitionConfig config, IInjectRecognitionEvent recognitionInjection, IInjectModelEvent modelSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                ModelSession clientModelSession = SoundTriggerInstrumentation.this.mModelSessionMap.get(modelSession.asBinder());
                if (clientModelSession == null) {
                    return;
                }
                RecognitionSession recogSession = new RecognitionSession(audioSessionHandle, config, recognitionInjection);
                SoundTriggerInstrumentation.this.mRecognitionSessionMap.put(recognitionInjection.asBinder(), recogSession);
                clientModelSession.wrap(cb -> cb.onRecognitionStarted(recogSession));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRecognitionStopped(IInjectRecognitionEvent recognitionSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                RecognitionSession clientRecognitionSession = SoundTriggerInstrumentation.this.mRecognitionSessionMap.remove(recognitionSession.asBinder());
                if (clientRecognitionSession == null) {
                    return;
                }
                clientRecognitionSession.wrap(cb -> cb.onRecognitionStopped());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParamSet(int modelParam, int value, IInjectModelEvent modelSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                ModelSession clientModelSession = SoundTriggerInstrumentation.this.mModelSessionMap.get(modelSession.asBinder());
                if (clientModelSession == null) {
                    return;
                }
                clientModelSession.wrap(cb -> cb.onParamSet(modelParam, value));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRestarted(IInjectGlobalEvent globalSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (globalSession.asBinder() != SoundTriggerInstrumentation.this.mInjectGlobalEvent.asBinder()) {
                    return;
                }
                SoundTriggerInstrumentation.this.mRecognitionSessionMap.clear();
                SoundTriggerInstrumentation.this.mModelSessionMap.clear();
                SoundTriggerInstrumentation.this.mGlobalCallbackExecutor.execute(() -> SoundTriggerInstrumentation.this.mClientCallback.onRestarted());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameworkDetached(IInjectGlobalEvent globalSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (globalSession.asBinder() != SoundTriggerInstrumentation.this.mInjectGlobalEvent.asBinder()) {
                    return;
                }
                SoundTriggerInstrumentation.this.mGlobalCallbackExecutor.execute(() -> SoundTriggerInstrumentation.this.mClientCallback.onFrameworkDetached());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientAttached(IBinder token, IInjectGlobalEvent globalSession) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (globalSession.asBinder() != SoundTriggerInstrumentation.this.mInjectGlobalEvent.asBinder()) {
                    return;
                }
                SoundTriggerInstrumentation.this.mClientToken = token;
                SoundTriggerInstrumentation.this.mGlobalCallbackExecutor.execute(() -> SoundTriggerInstrumentation.this.mClientCallback.onClientAttached());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientDetached(IBinder token) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (token != SoundTriggerInstrumentation.this.mClientToken) {
                    return;
                }
                SoundTriggerInstrumentation.this.mClientToken = null;
                SoundTriggerInstrumentation.this.mGlobalCallbackExecutor.execute(() -> SoundTriggerInstrumentation.this.mClientCallback.onClientDetached());
            }
        }

        @Override
        public void onPreempted() {
            SoundTriggerInstrumentation.this.mGlobalCallbackExecutor.execute(() -> SoundTriggerInstrumentation.this.mClientCallback.onPreempted());
        }
    }

    public class RecognitionSession {
        private final int mAudioSession;
        private final SoundTrigger.RecognitionConfig mRecognitionConfig;
        private final IInjectRecognitionEvent mInjectRecognitionEvent;
        @GuardedBy(value={"SoundTriggerInstrumentation.this.mLock"})
        private Executor mRecognitionExecutor = null;
        @GuardedBy(value={"SoundTriggerInstrumentation.this.mLock"})
        private RecognitionCallback mRecognitionCallback = null;
        @GuardedBy(value={"SoundTriggerInstrumentation.this.mLock"})
        private final List<Consumer<RecognitionCallback>> mDroppedConsumerList = new ArrayList<Consumer<RecognitionCallback>>();

        public int getAudioSession() {
            return this.mAudioSession;
        }

        @FlaggedApi(value="android.media.soundtrigger.manager_api")
        @NonNull
        public SoundTrigger.RecognitionConfig getRecognitionConfig() {
            return this.mRecognitionConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerRecognitionEvent(@NonNull byte[] data, @Nullable List<SoundTrigger.KeyphraseRecognitionExtra> phraseExtras) {
            PhraseRecognitionExtra[] converted = null;
            if (phraseExtras != null) {
                converted = new PhraseRecognitionExtra[phraseExtras.size()];
                int i = 0;
                for (SoundTrigger.KeyphraseRecognitionExtra phraseExtra : phraseExtras) {
                    converted[i++] = ConversionUtil.api2aidlPhraseRecognitionExtra(phraseExtra);
                }
            }
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                SoundTriggerInstrumentation.this.mRecognitionSessionMap.remove(this.mInjectRecognitionEvent.asBinder());
                try {
                    this.mInjectRecognitionEvent.triggerRecognitionEvent(data, converted);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerAbortRecognition() {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                SoundTriggerInstrumentation.this.mRecognitionSessionMap.remove(this.mInjectRecognitionEvent.asBinder());
                try {
                    this.mInjectRecognitionEvent.triggerAbortRecognition();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRecognitionCallback(@NonNull Executor executor, @NonNull RecognitionCallback callback) {
            Objects.requireNonNull(callback);
            Objects.requireNonNull(executor);
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (this.mRecognitionCallback == null) {
                    for (Consumer<RecognitionCallback> droppedConsumer : this.mDroppedConsumerList) {
                        executor.execute(() -> droppedConsumer.accept(callback));
                    }
                    this.mDroppedConsumerList.clear();
                }
                this.mRecognitionCallback = callback;
                this.mRecognitionExecutor = executor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearRecognitionCallback() {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                this.mRecognitionCallback = null;
                this.mRecognitionExecutor = null;
            }
        }

        private RecognitionSession(int audioSession, RecognitionConfig recognitionConfig, IInjectRecognitionEvent injectRecognitionEvent) {
            this.mAudioSession = audioSession;
            this.mRecognitionConfig = ConversionUtil.aidl2apiRecognitionConfig(recognitionConfig);
            this.mInjectRecognitionEvent = injectRecognitionEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wrap(Consumer<RecognitionCallback> consumer) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (this.mRecognitionCallback != null) {
                    RecognitionCallback callback = this.mRecognitionCallback;
                    this.mRecognitionExecutor.execute(() -> consumer.accept(callback));
                } else {
                    this.mDroppedConsumerList.add(consumer);
                }
            }
        }
    }

    public class ModelSession {
        private final SoundTriggerManager.Model mModel;
        private final SoundTrigger.Keyphrase[] mPhrases;
        private final IInjectModelEvent mInjectModelEvent;
        @GuardedBy(value={"SoundTriggerInstrumentation.this.mLock"})
        private ModelCallback mModelCallback = null;
        @GuardedBy(value={"SoundTriggerInstrumentation.this.mLock"})
        private Executor mModelExecutor = null;
        @GuardedBy(value={"SoundTriggerInstrumentation.this.mLock"})
        private final List<Consumer<ModelCallback>> mDroppedConsumerList = new ArrayList<Consumer<ModelCallback>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerUnloadModel() {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                try {
                    this.mInjectModelEvent.triggerUnloadModel();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                SoundTriggerInstrumentation.this.mModelSessionMap.remove(this.mInjectModelEvent.asBinder());
            }
        }

        @NonNull
        public SoundTriggerManager.Model getSoundModel() {
            return this.mModel;
        }

        @NonNull
        public List<SoundTrigger.Keyphrase> getPhrases() {
            if (this.mPhrases == null) {
                return new ArrayList<SoundTrigger.Keyphrase>();
            }
            return new ArrayList<SoundTrigger.Keyphrase>(Arrays.asList(this.mPhrases));
        }

        public boolean isKeyphrase() {
            return this.mPhrases != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setModelCallback(@NonNull Executor executor, @NonNull ModelCallback callback) {
            Objects.requireNonNull(callback);
            Objects.requireNonNull(executor);
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (this.mModelCallback == null) {
                    for (Consumer<ModelCallback> droppedConsumer : this.mDroppedConsumerList) {
                        executor.execute(() -> droppedConsumer.accept(callback));
                    }
                    this.mDroppedConsumerList.clear();
                }
                this.mModelCallback = callback;
                this.mModelExecutor = executor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearModelCallback() {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                this.mModelCallback = null;
                this.mModelExecutor = null;
            }
        }

        private ModelSession(SoundModel model, Phrase[] phrases, IInjectModelEvent injection) {
            this.mModel = SoundTriggerManager.Model.create(UUID.fromString(model.uuid), UUID.fromString(model.vendorUuid), ConversionUtil.sharedMemoryToByteArray(model.data, model.dataSize));
            if (phrases != null) {
                this.mPhrases = new SoundTrigger.Keyphrase[phrases.length];
                int i = 0;
                for (Phrase phrase : phrases) {
                    this.mPhrases[i++] = ConversionUtil.aidl2apiPhrase(phrase);
                }
            } else {
                this.mPhrases = null;
            }
            this.mInjectModelEvent = injection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wrap(Consumer<ModelCallback> consumer) {
            Object object = SoundTriggerInstrumentation.this.mLock;
            synchronized (object) {
                if (this.mModelCallback != null) {
                    ModelCallback callback = this.mModelCallback;
                    this.mModelExecutor.execute(() -> consumer.accept(callback));
                } else {
                    this.mDroppedConsumerList.add(consumer);
                }
            }
        }
    }

    public static interface RecognitionCallback {
        public void onRecognitionStopped();
    }

    public static interface ModelCallback {
        default public void onModelUnloaded() {
        }

        default public void onParamSet(int param, int value) {
        }

        public void onRecognitionStarted(@NonNull RecognitionSession var1);
    }
}

