/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.media.quality.SoundProfileHandle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.RequiresPermission;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.media.tv.flags.media_quality_fw")
public class SoundProfile
implements Parcelable {
    @Nullable
    private String mId;
    private final int mType;
    @NonNull
    private final String mName;
    @Nullable
    private final String mInputId;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final PersistableBundle mParams;
    private final SoundProfileHandle mHandle;
    public static final int TYPE_SYSTEM = 1;
    public static final int TYPE_APPLICATION = 2;
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_NO_PERMISSION = 1;
    public static final int ERROR_DUPLICATE = 2;
    public static final int ERROR_INVALID_ARGUMENT = 3;
    public static final int ERROR_NOT_ALLOWLISTED = 4;
    @NonNull
    public static final Parcelable.Creator<SoundProfile> CREATOR = new Parcelable.Creator<SoundProfile>(){

        @Override
        public SoundProfile createFromParcel(Parcel in) {
            return new SoundProfile(in);
        }

        public SoundProfile[] newArray(int size) {
            return new SoundProfile[size];
        }
    };

    private SoundProfile(@NonNull Parcel in) {
        this.mId = in.readString();
        this.mType = in.readInt();
        this.mName = in.readString();
        this.mInputId = in.readString();
        this.mPackageName = in.readString();
        this.mParams = in.readPersistableBundle();
        this.mHandle = (SoundProfileHandle)in.readParcelable(SoundProfileHandle.class.getClassLoader());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mType);
        dest.writeString(this.mName);
        dest.writeString(this.mInputId);
        dest.writeString(this.mPackageName);
        dest.writePersistableBundle(this.mParams);
        dest.writeParcelable(this.mHandle, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public SoundProfile(@Nullable String id2, int type, @NonNull String name, @Nullable String inputId, @NonNull String packageName, @NonNull PersistableBundle params, @NonNull SoundProfileHandle handle) {
        this.mId = id2;
        this.mType = type;
        this.mName = name;
        this.mInputId = inputId;
        this.mPackageName = packageName;
        this.mParams = params;
        this.mHandle = handle;
    }

    @Nullable
    public String getProfileId() {
        return this.mId;
    }

    public void setProfileId(String id2) {
        this.mId = id2;
    }

    public int getProfileType() {
        return this.mType;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getInputId() {
        return this.mInputId;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public PersistableBundle getParameters() {
        return new PersistableBundle(this.mParams);
    }

    @NonNull
    public SoundProfileHandle getHandle() {
        return this.mHandle;
    }

    public static class Builder {
        @Nullable
        private String mId;
        private int mType = 2;
        @NonNull
        private String mName;
        @Nullable
        private String mInputId;
        @NonNull
        private String mPackageName;
        @NonNull
        private PersistableBundle mParams;
        private SoundProfileHandle mHandle;

        public Builder(@NonNull String name) {
            this.mName = name;
        }

        public Builder(@NonNull SoundProfile p) {
            this.mId = null;
            this.mType = p.getProfileType();
            this.mName = p.getName();
            this.mPackageName = p.getPackageName();
            this.mInputId = p.getInputId();
            this.mParams = p.getParameters();
            this.mHandle = p.getHandle();
        }

        @NonNull
        public Builder setProfileId(@Nullable String id2) {
            this.mId = id2;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
        @NonNull
        public Builder setProfileType(int value) {
            this.mType = value;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
        @NonNull
        public Builder setInputId(@NonNull String value) {
            this.mInputId = value;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.MANAGE_GLOBAL_SOUND_QUALITY_SERVICE")
        @NonNull
        public Builder setPackageName(@NonNull String value) {
            this.mPackageName = value;
            return this;
        }

        @NonNull
        public Builder setParameters(@NonNull PersistableBundle params) {
            this.mParams = new PersistableBundle(params);
            return this;
        }

        @NonNull
        public Builder setHandle(@NonNull SoundProfileHandle handle) {
            this.mHandle = handle;
            return this;
        }

        @NonNull
        public SoundProfile build() {
            SoundProfile o = new SoundProfile(this.mId, this.mType, this.mName, this.mInputId, this.mPackageName, this.mParams, this.mHandle);
            return o;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileType {
    }
}

