/*
 * Decompiled with CFR 0.152.
 */
package android.media.quality;

import android.media.quality.ParameterCapability;
import android.media.quality.SoundProfile;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ISoundProfileCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.media.quality.ISoundProfileCallback";

    public void onSoundProfileAdded(String var1, SoundProfile var2) throws RemoteException;

    public void onSoundProfileUpdated(String var1, SoundProfile var2) throws RemoteException;

    public void onSoundProfileRemoved(String var1, SoundProfile var2) throws RemoteException;

    public void onParameterCapabilitiesChanged(String var1, List<ParameterCapability> var2) throws RemoteException;

    public void onError(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISoundProfileCallback {
        static final int TRANSACTION_onSoundProfileAdded = 1;
        static final int TRANSACTION_onSoundProfileUpdated = 2;
        static final int TRANSACTION_onSoundProfileRemoved = 3;
        static final int TRANSACTION_onParameterCapabilitiesChanged = 4;
        static final int TRANSACTION_onError = 5;

        public Stub() {
            this.attachInterface(this, ISoundProfileCallback.DESCRIPTOR);
        }

        public static ISoundProfileCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISoundProfileCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISoundProfileCallback) {
                return (ISoundProfileCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISoundProfileCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    SoundProfile _arg1 = data.readTypedObject(SoundProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSoundProfileAdded(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    SoundProfile _arg1 = data.readTypedObject(SoundProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSoundProfileUpdated(_arg0, _arg1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    SoundProfile _arg1 = data.readTypedObject(SoundProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSoundProfileRemoved(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    ArrayList<ParameterCapability> _arg1 = data.createTypedArrayList(ParameterCapability.CREATOR);
                    data.enforceNoDataAvail();
                    this.onParameterCapabilitiesChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ISoundProfileCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISoundProfileCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundProfileAdded(String id2, SoundProfile p) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(p, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundProfileUpdated(String id2, SoundProfile p) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(p, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundProfileRemoved(String id2, SoundProfile p) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(p, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onParameterCapabilitiesChanged(String id2, List<ParameterCapability> caps) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedList(caps, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String id2, int err) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISoundProfileCallback.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeInt(err);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISoundProfileCallback {
        @Override
        public void onSoundProfileAdded(String id2, SoundProfile p) throws RemoteException {
        }

        @Override
        public void onSoundProfileUpdated(String id2, SoundProfile p) throws RemoteException {
        }

        @Override
        public void onSoundProfileRemoved(String id2, SoundProfile p) throws RemoteException {
        }

        @Override
        public void onParameterCapabilitiesChanged(String id2, List<ParameterCapability> caps) throws RemoteException {
        }

        @Override
        public void onError(String id2, int err) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

