/*
 * Decompiled with CFR 0.152.
 */
package android.media.projection;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionWatcherCallback;
import android.media.projection.MediaProjectionInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.view.ContentRecordingSession;

public interface IMediaProjectionManager
extends IInterface {
    public static final String EXTRA_USER_REVIEW_GRANTED_CONSENT = "extra_media_projection_user_consent_required";
    public static final String EXTRA_PACKAGE_REUSING_GRANTED_CONSENT = "extra_media_projection_package_reusing_consent";

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/media/java/android/media/projection/IMediaProjectionManager.aidl:47:1:47:25")
    public boolean hasProjectionPermission(int var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public IMediaProjection createProjection(int var1, String var2, int var3, boolean var4, int var5) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public IMediaProjection getProjection(int var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public boolean isCurrentProjection(IMediaProjection var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void requestConsentForInvalidProjection(IMediaProjection var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public MediaProjectionInfo getActiveProjectionInfo() throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void stopActiveProjection(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyActiveProjectionCapturedContentVisibilityChanged(boolean var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public MediaProjectionInfo addCallback(IMediaProjectionWatcherCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void removeCallback(IMediaProjectionWatcherCallback var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public boolean setContentRecordingSession(ContentRecordingSession var1, IMediaProjection var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void setUserReviewGrantedConsentResult(int var1, IMediaProjection var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyPermissionRequestInitiated(int var1, int var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyPermissionRequestDisplayed(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyPermissionRequestCancelled(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyAppSelectorDisplayed(int var1) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyWindowingModeChanged(int var1, int var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    @EnforcePermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void notifyCaptureBoundsChanged(int var1, int var2, Rect var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaProjectionManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.media.projection.IMediaProjectionManager";
        static final int TRANSACTION_hasProjectionPermission = 1;
        static final int TRANSACTION_createProjection = 2;
        static final int TRANSACTION_getProjection = 3;
        static final int TRANSACTION_isCurrentProjection = 4;
        static final int TRANSACTION_requestConsentForInvalidProjection = 5;
        static final int TRANSACTION_getActiveProjectionInfo = 6;
        static final int TRANSACTION_stopActiveProjection = 7;
        static final int TRANSACTION_notifyActiveProjectionCapturedContentVisibilityChanged = 8;
        static final int TRANSACTION_addCallback = 9;
        static final int TRANSACTION_removeCallback = 10;
        static final int TRANSACTION_setContentRecordingSession = 11;
        static final int TRANSACTION_setUserReviewGrantedConsentResult = 12;
        static final int TRANSACTION_notifyPermissionRequestInitiated = 13;
        static final int TRANSACTION_notifyPermissionRequestDisplayed = 14;
        static final int TRANSACTION_notifyPermissionRequestCancelled = 15;
        static final int TRANSACTION_notifyAppSelectorDisplayed = 16;
        static final int TRANSACTION_notifyWindowingModeChanged = 17;
        static final int TRANSACTION_notifyCaptureBoundsChanged = 18;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IMediaProjectionManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaProjectionManager) {
                return (IMediaProjectionManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "hasProjectionPermission";
                }
                case 2: {
                    return "createProjection";
                }
                case 3: {
                    return "getProjection";
                }
                case 4: {
                    return "isCurrentProjection";
                }
                case 5: {
                    return "requestConsentForInvalidProjection";
                }
                case 6: {
                    return "getActiveProjectionInfo";
                }
                case 7: {
                    return "stopActiveProjection";
                }
                case 8: {
                    return "notifyActiveProjectionCapturedContentVisibilityChanged";
                }
                case 9: {
                    return "addCallback";
                }
                case 10: {
                    return "removeCallback";
                }
                case 11: {
                    return "setContentRecordingSession";
                }
                case 12: {
                    return "setUserReviewGrantedConsentResult";
                }
                case 13: {
                    return "notifyPermissionRequestInitiated";
                }
                case 14: {
                    return "notifyPermissionRequestDisplayed";
                }
                case 15: {
                    return "notifyPermissionRequestCancelled";
                }
                case 16: {
                    return "notifyAppSelectorDisplayed";
                }
                case 17: {
                    return "notifyWindowingModeChanged";
                }
                case 18: {
                    return "notifyCaptureBoundsChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasProjectionPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    IMediaProjection _result = this.createProjection(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    IMediaProjection _result = this.getProjection(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    IMediaProjection _arg0 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.isCurrentProjection(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    IMediaProjection _arg0 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestConsentForInvalidProjection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    MediaProjectionInfo _result = this.getActiveProjectionInfo();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopActiveProjection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyActiveProjectionCapturedContentVisibilityChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IMediaProjectionWatcherCallback _arg0 = IMediaProjectionWatcherCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    MediaProjectionInfo _result = this.addCallback(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    IMediaProjectionWatcherCallback _arg0 = IMediaProjectionWatcherCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    ContentRecordingSession _arg0 = data.readTypedObject(ContentRecordingSession.CREATOR);
                    IMediaProjection _arg1 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.setContentRecordingSession(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    IMediaProjection _arg1 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setUserReviewGrantedConsentResult(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyPermissionRequestInitiated(_arg0, _arg1);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyPermissionRequestDisplayed(_arg0);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyPermissionRequestCancelled(_arg0);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAppSelectorDisplayed(_arg0);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyWindowingModeChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyCaptureBoundsChanged(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void getProjection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isCurrentProjection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void requestConsentForInvalidProjection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void stopActiveProjection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyActiveProjectionCapturedContentVisibilityChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void addCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setContentRecordingSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setUserReviewGrantedConsentResult_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyPermissionRequestInitiated_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyPermissionRequestDisplayed_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyPermissionRequestCancelled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyAppSelectorDisplayed_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyWindowingModeChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyCaptureBoundsChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_MEDIA_PROJECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements IMediaProjectionManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasProjectionPermission(int processUid, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(processUid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IMediaProjection createProjection(int processUid, String packageName, int type, boolean permanentGrant, int displayId) throws RemoteException {
                IMediaProjection _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(processUid);
                    _data.writeString(packageName);
                    _data.writeInt(type);
                    _data.writeBoolean(permanentGrant);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = IMediaProjection.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IMediaProjection getProjection(int processUid, String packageName) throws RemoteException {
                IMediaProjection _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(processUid);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = IMediaProjection.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCurrentProjection(IMediaProjection projection) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestConsentForInvalidProjection(IMediaProjection projection) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaProjectionInfo getActiveProjectionInfo() throws RemoteException {
                MediaProjectionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaProjectionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopActiveProjection(int stopReason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(stopReason);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyActiveProjectionCapturedContentVisibilityChanged(boolean isVisible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isVisible);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaProjectionInfo addCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
                MediaProjectionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(MediaProjectionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setContentRecordingSession(ContentRecordingSession incomingSession, IMediaProjection projection) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(incomingSession, 0);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserReviewGrantedConsentResult(int consentResult, IMediaProjection projection) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(consentResult);
                    _data.writeStrongInterface(projection);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPermissionRequestInitiated(int hostProcessUid, int sessionCreationSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hostProcessUid);
                    _data.writeInt(sessionCreationSource);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPermissionRequestDisplayed(int hostProcessUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hostProcessUid);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPermissionRequestCancelled(int hostProcessUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hostProcessUid);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAppSelectorDisplayed(int hostProcessUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hostProcessUid);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyWindowingModeChanged(int contentToRecord, int targetProcessUid, int windowingMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contentToRecord);
                    _data.writeInt(targetProcessUid);
                    _data.writeInt(windowingMode);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCaptureBoundsChanged(int contentToRecord, int targetProcessUid, Rect captureBounds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contentToRecord);
                    _data.writeInt(targetProcessUid);
                    _data.writeTypedObject(captureBounds, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMediaProjectionManager {
        @Override
        public boolean hasProjectionPermission(int processUid, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public IMediaProjection createProjection(int processUid, String packageName, int type, boolean permanentGrant, int displayId) throws RemoteException {
            return null;
        }

        @Override
        public IMediaProjection getProjection(int processUid, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public boolean isCurrentProjection(IMediaProjection projection) throws RemoteException {
            return false;
        }

        @Override
        public void requestConsentForInvalidProjection(IMediaProjection projection) throws RemoteException {
        }

        @Override
        public MediaProjectionInfo getActiveProjectionInfo() throws RemoteException {
            return null;
        }

        @Override
        public void stopActiveProjection(int stopReason) throws RemoteException {
        }

        @Override
        public void notifyActiveProjectionCapturedContentVisibilityChanged(boolean isVisible) throws RemoteException {
        }

        @Override
        public MediaProjectionInfo addCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public void removeCallback(IMediaProjectionWatcherCallback callback) throws RemoteException {
        }

        @Override
        public boolean setContentRecordingSession(ContentRecordingSession incomingSession, IMediaProjection projection) throws RemoteException {
            return false;
        }

        @Override
        public void setUserReviewGrantedConsentResult(int consentResult, IMediaProjection projection) throws RemoteException {
        }

        @Override
        public void notifyPermissionRequestInitiated(int hostProcessUid, int sessionCreationSource) throws RemoteException {
        }

        @Override
        public void notifyPermissionRequestDisplayed(int hostProcessUid) throws RemoteException {
        }

        @Override
        public void notifyPermissionRequestCancelled(int hostProcessUid) throws RemoteException {
        }

        @Override
        public void notifyAppSelectorDisplayed(int hostProcessUid) throws RemoteException {
        }

        @Override
        public void notifyWindowingModeChanged(int contentToRecord, int targetProcessUid, int windowingMode) throws RemoteException {
        }

        @Override
        public void notifyCaptureBoundsChanged(int contentToRecord, int targetProcessUid, Rect captureBounds) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

