/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.annotation.NonNull;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AudioPolicyConfig
implements Parcelable {
    private static final String TAG = "AudioPolicyConfig";
    protected final ArrayList<AudioMix> mMixes;
    protected int mDuckingPolicy = 0;
    private String mRegistrationId = null;
    private int mMixCounter = 0;
    @NonNull
    public static final Parcelable.Creator<AudioPolicyConfig> CREATOR = new Parcelable.Creator<AudioPolicyConfig>(){

        @Override
        public AudioPolicyConfig createFromParcel(Parcel p) {
            return new AudioPolicyConfig(p);
        }

        public AudioPolicyConfig[] newArray(int size) {
            return new AudioPolicyConfig[size];
        }
    };

    protected AudioPolicyConfig(AudioPolicyConfig conf) {
        this.mMixes = conf.mMixes;
    }

    @VisibleForTesting
    public AudioPolicyConfig(ArrayList<AudioMix> mixes) {
        this.mMixes = mixes;
    }

    public void addMix(AudioMix mix) throws IllegalArgumentException {
        if (mix == null) {
            throw new IllegalArgumentException("Illegal null AudioMix argument");
        }
        this.mMixes.add(mix);
    }

    public ArrayList<AudioMix> getMixes() {
        return this.mMixes;
    }

    public int hashCode() {
        return Objects.hash(this.mMixes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMixes.size());
        for (AudioMix mix : this.mMixes) {
            mix.writeToParcel(dest, flags);
        }
    }

    private AudioPolicyConfig(Parcel in) {
        int nbMixes = in.readInt();
        this.mMixes = new ArrayList(nbMixes);
        for (int i = 0; i < nbMixes; ++i) {
            this.mMixes.add(AudioMix.CREATOR.createFromParcel(in));
        }
    }

    public String toLogFriendlyString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicyConfig:\n");
        textDump = textDump + this.mMixes.size() + " AudioMix, reg:" + this.mRegistrationId + "\n";
        for (AudioMix mix : this.mMixes) {
            textDump = textDump + "* route flags=0x" + Integer.toHexString(mix.getRouteFlags()) + "\n";
            textDump = textDump + "  rate=" + mix.getFormat().getSampleRate() + "Hz\n";
            textDump = textDump + "  encoding=" + mix.getFormat().getEncoding() + "\n";
            textDump = textDump + "  channels=0x";
            textDump = textDump + Integer.toHexString(mix.getFormat().getChannelMask()).toUpperCase() + "\n";
            textDump = textDump + "  ignore playback capture opt out=" + mix.getRule().allowPrivilegedMediaPlaybackCapture() + "\n";
            textDump = textDump + "  allow voice communication capture=" + mix.getRule().voiceCommunicationCaptureAllowed() + "\n";
            textDump = textDump + "  specified mix type=" + mix.getRule().getTargetMixRole() + "\n";
            ArrayList<AudioMixingRule.AudioMixMatchCriterion> criteria = mix.getRule().getCriteria();
            for (AudioMixingRule.AudioMixMatchCriterion criterion : criteria) {
                switch (criterion.mRule) {
                    case 32769: {
                        textDump = textDump + "  exclude usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 1: {
                        textDump = textDump + "  match usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 32770: {
                        textDump = textDump + "  exclude capture preset ";
                        textDump = textDump + criterion.mAttr.getCapturePreset();
                        break;
                    }
                    case 2: {
                        textDump = textDump + "  match capture preset ";
                        textDump = textDump + criterion.mAttr.getCapturePreset();
                        break;
                    }
                    case 4: {
                        textDump = textDump + "  match UID ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    case 32772: {
                        textDump = textDump + "  exclude UID ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    case 8: {
                        textDump = textDump + "  match userId ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    case 32776: {
                        textDump = textDump + "  exclude userId ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    case 16: {
                        textDump = textDump + " match audio session id";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    case 32784: {
                        textDump = textDump + " exclude audio session id ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    default: {
                        textDump = textDump + "invalid rule!";
                    }
                }
                textDump = textDump + "\n";
            }
        }
        return textDump;
    }

    public String toCompactLogString() {
        String compactDump = "reg:" + this.mRegistrationId;
        int mixNum = 0;
        for (AudioMix mix : this.mMixes) {
            compactDump = compactDump + " Mix:" + mixNum + "-Typ:" + AudioPolicyConfig.mixTypePrefix(mix.getMixType()) + "-Rul:" + mix.getRule().getCriteria().size();
            ++mixNum;
        }
        return compactDump;
    }

    private static String mixTypePrefix(int mixType) {
        switch (mixType) {
            case 0: {
                return "p";
            }
            case 1: {
                return "r";
            }
        }
        return "#";
    }

    protected void reset() {
        this.mMixCounter = 0;
    }

    protected void setRegistration(String regId) {
        boolean newRegNull;
        boolean currentRegNull = this.mRegistrationId == null || this.mRegistrationId.isEmpty();
        boolean bl = newRegNull = regId == null || regId.isEmpty();
        if (!(currentRegNull || newRegNull || this.mRegistrationId.equals(regId))) {
            Log.e(TAG, "Invalid registration transition from " + this.mRegistrationId + " to " + regId);
            return;
        }
        this.mRegistrationId = regId == null ? "" : regId;
        for (AudioMix mix : this.mMixes) {
            this.setMixRegistration(mix);
        }
    }

    protected void setMixRegistration(@NonNull AudioMix mix) {
        if (!this.mRegistrationId.isEmpty()) {
            if ((mix.getRouteFlags() & 2) == 2) {
                mix.setRegistration(this.mRegistrationId + "mix" + AudioPolicyConfig.mixTypeId(mix.getMixType()) + ":" + this.mMixCounter++);
            } else if ((mix.getRouteFlags() & 1) == 1) {
                mix.setRegistration(mix.mDeviceAddress);
            }
        } else {
            mix.setRegistration("");
        }
    }

    @GuardedBy(value={"mMixes"})
    protected void add(@NonNull ArrayList<AudioMix> mixes) {
        for (AudioMix mix : mixes) {
            if (mix.getRegistration() == null || mix.getRegistration().isEmpty()) {
                this.setMixRegistration(mix);
            }
            this.mMixes.add(mix);
        }
    }

    @GuardedBy(value={"mMixes"})
    protected void remove(@NonNull ArrayList<AudioMix> mixes) {
        for (AudioMix mix : mixes) {
            this.mMixes.remove(mix);
        }
    }

    public void updateMixingRules(@NonNull List<Pair<AudioMix, AudioMixingRule>> audioMixingRuleUpdates) {
        Objects.requireNonNull(audioMixingRuleUpdates).forEach(update -> this.updateMixingRule((AudioMix)update.first, (AudioMixingRule)update.second));
    }

    private void updateMixingRule(AudioMix audioMixToUpdate, AudioMixingRule audioMixingRule) {
        this.mMixes.stream().filter(audioMixToUpdate::equals).findAny().ifPresent(mix -> mix.setAudioMixingRule(audioMixingRule));
    }

    private static String mixTypeId(int type) {
        if (type == 0) {
            return "p";
        }
        if (type == 1) {
            return "r";
        }
        return "i";
    }

    protected String getRegistration() {
        return this.mRegistrationId;
    }
}

