/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.media.AudioSystem;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.FileUtils;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.vibrator.persistence.ParsedVibration;
import android.os.vibrator.persistence.VibrationXmlParser;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.Executor;

@SuppressLint(value={"UnflaggedApi", "StaticUtils"})
public class Utils {
    private static final String TAG = "Utils";
    @SuppressLint(value={"UnflaggedApi"})
    public static final String VIBRATION_URI_PARAM = "vibration_uri";
    @SuppressLint(value={"UnflaggedApi"})
    public static final String SYNCHRONIZED_VIBRATION = "synchronized";

    public static <T extends Comparable<? super T>> void sortDistinctRanges(Range<T>[] ranges) {
        Arrays.sort(ranges, new Comparator<Range<T>>(){

            @Override
            public int compare(Range<T> lhs, Range<T> rhs) {
                if (lhs.getUpper().compareTo(rhs.getLower()) < 0) {
                    return -1;
                }
                if (lhs.getLower().compareTo(rhs.getUpper()) > 0) {
                    return 1;
                }
                throw new IllegalArgumentException("sample rate ranges must be distinct (" + lhs + " and " + rhs + ")");
            }
        });
    }

    public static <T extends Comparable<? super T>> Range<T>[] intersectSortedDistinctRanges(Range<T>[] one, Range<T>[] another) {
        int ix = 0;
        Vector<Range<T>> result = new Vector<Range<T>>();
        for (Range<T> range : another) {
            while (ix < one.length && one[ix].getUpper().compareTo(range.getLower()) < 0) {
                ++ix;
            }
            while (ix < one.length && one[ix].getUpper().compareTo(range.getUpper()) < 0) {
                result.add(range.intersect(one[ix]));
                ++ix;
            }
            if (ix == one.length) break;
            if (one[ix].getLower().compareTo(range.getUpper()) > 0) continue;
            result.add(range.intersect(one[ix]));
        }
        return result.toArray(new Range[result.size()]);
    }

    public static <T extends Comparable<? super T>> int binarySearchDistinctRanges(Range<T>[] ranges, T value) {
        return Arrays.binarySearch(ranges, Range.create(value, value), new Comparator<Range<T>>(){

            @Override
            public int compare(Range<T> lhs, Range<T> rhs) {
                if (lhs.getUpper().compareTo(rhs.getLower()) < 0) {
                    return -1;
                }
                if (lhs.getLower().compareTo(rhs.getUpper()) > 0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    static int gcd(int a, int b) {
        if (a == 0 && b == 0) {
            return 1;
        }
        if (b < 0) {
            b = -b;
        }
        if (a < 0) {
            a = -a;
        }
        while (a != 0) {
            int c = b % a;
            b = a;
            a = c;
        }
        return b;
    }

    static Range<Integer> factorRange(Range<Integer> range, int factor) {
        if (factor == 1) {
            return range;
        }
        return Range.create(Utils.divUp(range.getLower(), factor), range.getUpper() / factor);
    }

    static Range<Long> factorRange(Range<Long> range, long factor) {
        if (factor == 1L) {
            return range;
        }
        return Range.create(Utils.divUp(range.getLower(), factor), range.getUpper() / factor);
    }

    private static Rational scaleRatio(Rational ratio, int num, int den) {
        int common = Utils.gcd(num, den);
        return new Rational((int)((double)ratio.getNumerator() * (double)(num /= common)), (int)((double)ratio.getDenominator() * (double)(den /= common)));
    }

    static Range<Rational> scaleRange(Range<Rational> range, int num, int den) {
        if (num == den) {
            return range;
        }
        return Range.create(Utils.scaleRatio(range.getLower(), num, den), Utils.scaleRatio(range.getUpper(), num, den));
    }

    static Range<Integer> alignRange(Range<Integer> range, int align) {
        return range.intersect(Utils.divUp(range.getLower(), align) * align, range.getUpper() / align * align);
    }

    static int divUp(int num, int den) {
        return (num + den - 1) / den;
    }

    static long divUp(long num, long den) {
        return (num + den - 1L) / den;
    }

    private static long lcm(int a, int b) {
        if (a == 0 || b == 0) {
            throw new IllegalArgumentException("lce is not defined for zero arguments");
        }
        return (long)a * (long)b / (long)Utils.gcd(a, b);
    }

    static Range<Integer> intRangeFor(double v) {
        return Range.create((int)v, (int)Math.ceil(v));
    }

    static Range<Long> longRangeFor(double v) {
        return Range.create((long)v, (long)Math.ceil(v));
    }

    static Size parseSize(Object o, Size fallback) {
        if (o == null) {
            return fallback;
        }
        try {
            return Size.parseSize((String)o);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Log.w(TAG, "could not parse size '" + o + "'");
        return fallback;
    }

    static int parseIntSafely(Object o, int fallback) {
        if (o == null) {
            return fallback;
        }
        try {
            String s = (String)o;
            return Integer.parseInt(s);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Log.w(TAG, "could not parse integer '" + o + "'");
        return fallback;
    }

    static Range<Integer> parseIntRange(Object o, Range<Integer> fallback) {
        if (o == null) {
            return fallback;
        }
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Range.create(Integer.parseInt(s.substring(0, ix), 10), Integer.parseInt(s.substring(ix + 1), 10));
            }
            int value = Integer.parseInt(s);
            return Range.create(value, value);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w(TAG, "could not parse integer range '" + o + "'");
        return fallback;
    }

    static Range<Long> parseLongRange(Object o, Range<Long> fallback) {
        if (o == null) {
            return fallback;
        }
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Range.create(Long.parseLong(s.substring(0, ix), 10), Long.parseLong(s.substring(ix + 1), 10));
            }
            long value = Long.parseLong(s);
            return Range.create(value, value);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w(TAG, "could not parse long range '" + o + "'");
        return fallback;
    }

    static Range<Rational> parseRationalRange(Object o, Range<Rational> fallback) {
        if (o == null) {
            return fallback;
        }
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Range.create(Rational.parseRational(s.substring(0, ix)), Rational.parseRational(s.substring(ix + 1)));
            }
            Rational value = Rational.parseRational(s);
            return Range.create(value, value);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w(TAG, "could not parse rational range '" + o + "'");
        return fallback;
    }

    static Pair<Size, Size> parseSizeRange(Object o) {
        if (o == null) {
            return null;
        }
        try {
            String s = (String)o;
            int ix = s.indexOf(45);
            if (ix >= 0) {
                return Pair.create(Size.parseSize(s.substring(0, ix)), Size.parseSize(s.substring(ix + 1)));
            }
            Size value = Size.parseSize(s);
            return Pair.create(value, value);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Log.w(TAG, "could not parse size range '" + o + "'");
        return null;
    }

    public static File getUniqueExternalFile(Context context, String subdirectory, String fileName, String mimeType) {
        File externalStorage = Environment.getExternalStoragePublicDirectory(subdirectory);
        externalStorage.mkdirs();
        File outFile = null;
        try {
            outFile = FileUtils.buildUniqueFile(externalStorage, mimeType, fileName);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Unable to get a unique file name", e);
            return null;
        }
        return outFile;
    }

    static String getFileDisplayNameFromUri(Context context, Uri uri) {
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            return uri.getLastPathSegment();
        }
        if ("content".equals(scheme)) {
            String[] proj = new String[]{"_display_name"};
            try (Cursor cursor = context.getContentResolver().query(uri, proj, null, null, null);){
                if (cursor != null && cursor.getCount() != 0) {
                    cursor.moveToFirst();
                    String string2 = cursor.getString(cursor.getColumnIndex("_display_name"));
                    return string2;
                }
            }
        }
        return uri.toString();
    }

    @Nullable
    public static String anonymizeBluetoothAddress(@Nullable String address) {
        if (address == null) {
            return null;
        }
        if (address.length() != "AA:BB:CC:DD:EE:FF".length()) {
            return address;
        }
        return "XX:XX:XX:XX" + address.substring("XX:XX:XX:XX".length());
    }

    @Nullable
    public static String anonymizeBluetoothAddress(int deviceType, @Nullable String address) {
        if (!AudioSystem.isBluetoothDevice(deviceType)) {
            return address;
        }
        return Utils.anonymizeBluetoothAddress(address);
    }

    public static boolean isRingtoneVibrationSettingsSupported(Context context) {
        Resources res = context.getResources();
        return res != null && res.getBoolean(17891885);
    }

    public static boolean hasVibration(Uri ringtoneUri) {
        if (ringtoneUri == null) {
            return false;
        }
        String vibrationUriString = ringtoneUri.getQueryParameter(VIBRATION_URI_PARAM);
        return vibrationUriString != null;
    }

    @Nullable
    public static Uri getVibrationUri(Uri ringtoneUri) {
        if (ringtoneUri == null) {
            return null;
        }
        String vibrationUriString = ringtoneUri.getQueryParameter(VIBRATION_URI_PARAM);
        if (vibrationUriString == null) {
            return null;
        }
        return Uri.parse(vibrationUriString);
    }

    public static VibrationEffect parseVibrationEffect(Vibrator vibrator, Uri vibrationUri) {
        if (vibrationUri == null) {
            Log.w(TAG, "The vibration Uri is null.");
            return null;
        }
        String filePath = vibrationUri.getPath();
        if (filePath == null || filePath.equals(SYNCHRONIZED_VIBRATION)) {
            Log.w(TAG, "Ignore the vibration parsing for file:" + filePath);
            return null;
        }
        File vibrationFile = new File(filePath);
        if (vibrationFile.exists() && vibrationFile.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(vibrationFile);
                ParsedVibration parsedVibration = VibrationXmlParser.parseDocument(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
                return parsedVibration.resolve(vibrator);
            }
            catch (IOException e) {
                Log.e(TAG, "IOException", e);
            }
        } else {
            Log.w(TAG, "File exists:" + vibrationFile.exists() + ", canRead:" + vibrationFile.canRead());
        }
        return null;
    }

    public static class ListenerList<V> {
        @GuardedBy(value={"mListeners"})
        private HashMap<Object, ListenerWithCancellation<V>> mListeners = new HashMap();
        private final boolean mRestrictSingleCallerOnEvent;
        private final boolean mClearCallingIdentity;
        private final boolean mForceRemoveConsistency;

        public ListenerList() {
            this(true, true, false);
        }

        public ListenerList(boolean restrictSingleCallerOnEvent, boolean clearCallingIdentity, boolean forceRemoveConsistency) {
            this.mRestrictSingleCallerOnEvent = restrictSingleCallerOnEvent;
            this.mClearCallingIdentity = clearCallingIdentity;
            this.mForceRemoveConsistency = forceRemoveConsistency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NonNull Object key, final @NonNull Executor executor, final @NonNull Listener<V> listener) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(executor);
            Objects.requireNonNull(listener);
            ListenerWithCancellation listenerWithCancellation = new ListenerWithCancellation<V>(){
                private final Object mLock = new Object();
                private volatile boolean mCancelled = false;

                @Override
                public void onEvent(int eventCode, V info) {
                    executor.execute(() -> {
                        if (mRestrictSingleCallerOnEvent || mForceRemoveConsistency) {
                            Object object = this.mLock;
                            synchronized (object) {
                                if (this.mCancelled) {
                                    return;
                                }
                                listener.onEvent(eventCode, info);
                            }
                        } else {
                            if (this.mCancelled) {
                                return;
                            }
                            listener.onEvent(eventCode, info);
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void cancel() {
                    if (mForceRemoveConsistency) {
                        Object object = this.mLock;
                        synchronized (object) {
                            this.mCancelled = true;
                        }
                    } else {
                        this.mCancelled = true;
                    }
                }
            };
            HashMap<Object, ListenerWithCancellation<V>> hashMap = this.mListeners;
            synchronized (hashMap) {
                this.mListeners.put(key, listenerWithCancellation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@NonNull Object key) {
            ListenerWithCancellation<V> listener;
            Objects.requireNonNull(key);
            HashMap<Object, ListenerWithCancellation<V>> hashMap = this.mListeners;
            synchronized (hashMap) {
                listener = this.mListeners.get(key);
                if (listener == null) {
                    return;
                }
                this.mListeners.remove(key);
            }
            listener.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(int eventCode, @Nullable V info) {
            Object[] listeners;
            HashMap<Object, ListenerWithCancellation<V>> hashMap = this.mListeners;
            synchronized (hashMap) {
                if (this.mListeners.size() == 0) {
                    return;
                }
                listeners = this.mListeners.values().toArray();
            }
            Long identity = this.mClearCallingIdentity ? Long.valueOf(Binder.clearCallingIdentity()) : null;
            try {
                for (Object object : listeners) {
                    ListenerWithCancellation listener = (ListenerWithCancellation)object;
                    listener.onEvent(eventCode, info);
                }
            }
            finally {
                if (identity != null) {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        public static interface Listener<V> {
            public void onEvent(int var1, @Nullable V var2);
        }

        private static interface ListenerWithCancellation<V>
        extends Listener<V> {
            public void cancel();
        }
    }
}

