/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleTrack;
import android.media.TtmlCue;
import android.media.TtmlNode;
import android.media.TtmlNodeListener;
import android.media.TtmlParser;
import android.media.TtmlRenderingWidget;
import android.media.TtmlUtils;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParserException;

class TtmlTrack
extends SubtitleTrack
implements TtmlNodeListener {
    private static final String TAG = "TtmlTrack";
    private final TtmlParser mParser = new TtmlParser(this);
    private final TtmlRenderingWidget mRenderingWidget;
    private String mParsingData;
    private Long mCurrentRunID;
    private final LinkedList<TtmlNode> mTtmlNodes = new LinkedList();
    private final TreeSet<Long> mTimeEvents = new TreeSet();
    private TtmlNode mRootNode;

    TtmlTrack(TtmlRenderingWidget renderingWidget, MediaFormat format) {
        super(format);
        this.mRenderingWidget = renderingWidget;
        this.mParsingData = "";
    }

    @Override
    public TtmlRenderingWidget getRenderingWidget() {
        return this.mRenderingWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onData(byte[] data, boolean eos, long runID) {
        try {
            String str = new String(data, "UTF-8");
            TtmlParser ttmlParser = this.mParser;
            synchronized (ttmlParser) {
                if (this.mCurrentRunID != null && runID != this.mCurrentRunID) {
                    throw new IllegalStateException("Run #" + this.mCurrentRunID + " in progress.  Cannot process run #" + runID);
                }
                this.mCurrentRunID = runID;
                this.mParsingData = this.mParsingData + str;
                if (eos) {
                    try {
                        this.mParser.parse(this.mParsingData, this.mCurrentRunID);
                    }
                    catch (XmlPullParserException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.finishedRun(runID);
                    this.mParsingData = "";
                    this.mCurrentRunID = null;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.w(TAG, "subtitle data is not UTF-8 encoded: " + e);
        }
    }

    @Override
    public void onTtmlNodeParsed(TtmlNode node) {
        this.mTtmlNodes.addLast(node);
        this.addTimeEvents(node);
    }

    @Override
    public void onRootNodeParsed(TtmlNode node) {
        this.mRootNode = node;
        TtmlCue cue = null;
        while ((cue = this.getNextResult()) != null) {
            this.addCue(cue);
        }
        this.mRootNode = null;
        this.mTtmlNodes.clear();
        this.mTimeEvents.clear();
    }

    @Override
    public void updateView(Vector<SubtitleTrack.Cue> activeCues) {
        if (!this.mVisible) {
            return;
        }
        if (this.DEBUG && this.mTimeProvider != null) {
            try {
                Log.d(TAG, "at " + this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L + " ms the active cues are:");
            }
            catch (IllegalStateException e) {
                Log.d(TAG, "at (illegal state) the active cues are:");
            }
        }
        this.mRenderingWidget.setActiveCues(activeCues);
    }

    public TtmlCue getNextResult() {
        while (this.mTimeEvents.size() >= 2) {
            long end;
            long start = this.mTimeEvents.pollFirst();
            List<TtmlNode> activeCues = this.getActiveNodes(start, end = this.mTimeEvents.first().longValue());
            if (activeCues.isEmpty()) continue;
            return new TtmlCue(start, end, TtmlUtils.applySpacePolicy(TtmlUtils.extractText(this.mRootNode, start, end), false), TtmlUtils.extractTtmlFragment(this.mRootNode, start, end));
        }
        return null;
    }

    private void addTimeEvents(TtmlNode node) {
        this.mTimeEvents.add(node.mStartTimeMs);
        this.mTimeEvents.add(node.mEndTimeMs);
        for (int i = 0; i < node.mChildren.size(); ++i) {
            this.addTimeEvents(node.mChildren.get(i));
        }
    }

    private List<TtmlNode> getActiveNodes(long startTimeUs, long endTimeUs) {
        ArrayList<TtmlNode> activeNodes = new ArrayList<TtmlNode>();
        for (int i = 0; i < this.mTtmlNodes.size(); ++i) {
            TtmlNode node = this.mTtmlNodes.get(i);
            if (!node.isActive(startTimeUs, endTimeUs)) continue;
            activeNodes.add(node);
        }
        return activeNodes;
    }
}

