/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

@FlaggedApi(value="com.android.media.flags.enable_suggested_device_api")
public class SuggestedDeviceInfo
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<SuggestedDeviceInfo> CREATOR = new Parcelable.Creator<SuggestedDeviceInfo>(){

        @Override
        public SuggestedDeviceInfo createFromParcel(Parcel in) {
            return new SuggestedDeviceInfo(in);
        }

        public SuggestedDeviceInfo[] newArray(int size) {
            return new SuggestedDeviceInfo[size];
        }
    };
    @NonNull
    private final String mDeviceDisplayName;
    @NonNull
    private final String mRouteId;
    private final int mType;
    @NonNull
    private final Bundle mExtras;

    private SuggestedDeviceInfo(Builder builder) {
        this.mDeviceDisplayName = builder.mDeviceDisplayName;
        this.mRouteId = builder.mRouteId;
        this.mType = builder.mType;
        this.mExtras = builder.mExtras;
    }

    private SuggestedDeviceInfo(Parcel in) {
        this.mDeviceDisplayName = in.readString();
        this.mRouteId = in.readString();
        this.mType = in.readInt();
        this.mExtras = in.readBundle();
    }

    @NonNull
    public String getDeviceDisplayName() {
        return this.mDeviceDisplayName;
    }

    @NonNull
    public String getRouteId() {
        return this.mRouteId;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mDeviceDisplayName);
        dest.writeString(this.mRouteId);
        dest.writeInt(this.mType);
        dest.writeBundle(this.mExtras);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SuggestedDeviceInfo)) {
            return false;
        }
        return Objects.equals(this.mDeviceDisplayName, ((SuggestedDeviceInfo)obj).mDeviceDisplayName) && Objects.equals(this.mRouteId, ((SuggestedDeviceInfo)obj).mRouteId) && this.mType == ((SuggestedDeviceInfo)obj).mType;
    }

    public int hashCode() {
        return Objects.hash(this.mDeviceDisplayName, this.mRouteId, this.mType);
    }

    public String toString() {
        return this.mDeviceDisplayName + " | " + this.mRouteId + " | " + this.mType;
    }

    public static class Builder {
        @NonNull
        private final String mDeviceDisplayName;
        @NonNull
        private final String mRouteId;
        private final int mType;
        private Bundle mExtras = Bundle.EMPTY;

        public Builder(@NonNull String deviceDisplayName, @NonNull String routeId, int type) {
            if (TextUtils.isEmpty(deviceDisplayName)) {
                throw new IllegalArgumentException("Device display name cannot be empty");
            }
            this.mDeviceDisplayName = deviceDisplayName;
            if (TextUtils.isEmpty(routeId)) {
                throw new IllegalArgumentException("Route ID cannot be empty.");
            }
            this.mRouteId = routeId;
            this.mType = type;
        }

        @NonNull
        public SuggestedDeviceInfo build() {
            return new SuggestedDeviceInfo(this);
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras, "Extras must not be null");
            return this;
        }
    }
}

