/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaMetadata;
import android.media.MediaMetadataEditor;
import android.media.Rating;
import android.media.RemoteControlClient;
import android.media.session.MediaController;
import android.media.session.MediaSessionLegacyHelper;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import java.util.List;

@Deprecated
public class RemoteController {
    private static final int MAX_BITMAP_DIMENSION = 512;
    private static final String TAG = "RemoteController";
    private static final boolean DEBUG = false;
    private static final Object mInfoLock = new Object();
    private final Context mContext;
    private final int mMaxBitmapDimension;
    private MetadataEditor mMetadataEditor;
    private MediaSessionManager mSessionManager;
    private MediaSessionManager.OnActiveSessionsChangedListener mSessionListener;
    private MediaController.Callback mSessionCb = new MediaControllerCallback();
    private boolean mIsRegistered = false;
    private OnClientUpdateListener mOnClientUpdateListener;
    private PlaybackInfo mLastPlaybackInfo;
    private int mArtworkWidth = -1;
    private int mArtworkHeight = -1;
    private boolean mEnabled = true;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private MediaController mCurrentSession;
    public static final int POSITION_SYNCHRONIZATION_NONE = 0;
    public static final int POSITION_SYNCHRONIZATION_CHECK = 1;
    private final EventHandler mEventHandler;
    private static final int MSG_CLIENT_CHANGE = 0;
    private static final int MSG_NEW_PLAYBACK_STATE = 1;
    private static final int MSG_NEW_MEDIA_METADATA = 2;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;

    public RemoteController(Context context, OnClientUpdateListener updateListener) throws IllegalArgumentException {
        this(context, updateListener, null);
    }

    public RemoteController(Context context, OnClientUpdateListener updateListener, Looper looper) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("Invalid null Context");
        }
        if (updateListener == null) {
            throw new IllegalArgumentException("Invalid null OnClientUpdateListener");
        }
        if (looper != null) {
            this.mEventHandler = new EventHandler(this, looper);
        } else {
            Looper l = Looper.myLooper();
            if (l != null) {
                this.mEventHandler = new EventHandler(this, l);
            } else {
                throw new IllegalArgumentException("Calling thread not associated with a looper");
            }
        }
        this.mOnClientUpdateListener = updateListener;
        this.mContext = context;
        this.mSessionManager = (MediaSessionManager)context.getSystemService("media_session");
        this.mSessionListener = new TopTransportSessionListener();
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.mMaxBitmapDimension = 512;
        } else {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            this.mMaxBitmapDimension = Math.max(dm.widthPixels, dm.heightPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEstimatedMediaPosition() {
        Object object = mInfoLock;
        synchronized (object) {
            PlaybackState state;
            if (this.mCurrentSession != null && (state = this.mCurrentSession.getPlaybackState()) != null) {
                return state.getPosition();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMediaKeyEvent(KeyEvent keyEvent) throws IllegalArgumentException {
        if (!KeyEvent.isMediaSessionKey(keyEvent.getKeyCode())) {
            throw new IllegalArgumentException("not a media key event");
        }
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession != null) {
                return this.mCurrentSession.dispatchMediaButtonEvent(keyEvent);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean seekTo(long timeMs) throws IllegalArgumentException {
        if (!this.mEnabled) {
            Log.e(TAG, "Cannot use seekTo() from a disabled RemoteController");
            return false;
        }
        if (timeMs < 0L) {
            throw new IllegalArgumentException("illegal negative time value");
        }
        Object object = mInfoLock;
        synchronized (object) {
            if (this.mCurrentSession != null) {
                this.mCurrentSession.getTransportControls().seekTo(timeMs);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UnsupportedAppUsage
    public boolean setArtworkConfiguration(boolean wantBitmap, int width, int height) throws IllegalArgumentException {
        Object object = mInfoLock;
        synchronized (object) {
            if (wantBitmap) {
                if (width <= 0 || height <= 0) throw new IllegalArgumentException("Invalid dimensions");
                if (width > this.mMaxBitmapDimension) {
                    width = this.mMaxBitmapDimension;
                }
                if (height > this.mMaxBitmapDimension) {
                    height = this.mMaxBitmapDimension;
                }
                this.mArtworkWidth = width;
                this.mArtworkHeight = height;
            } else {
                this.mArtworkWidth = -1;
                this.mArtworkHeight = -1;
            }
            return true;
        }
    }

    public boolean setArtworkConfiguration(int width, int height) throws IllegalArgumentException {
        return this.setArtworkConfiguration(true, width, height);
    }

    public boolean clearArtworkConfiguration() {
        return this.setArtworkConfiguration(false, -1, -1);
    }

    public boolean setSynchronizationMode(int sync) throws IllegalArgumentException {
        if (sync != 0 && sync != 1) {
            throw new IllegalArgumentException("Unknown synchronization mode " + sync);
        }
        if (!this.mIsRegistered) {
            Log.e(TAG, "Cannot set synchronization mode on an unregistered RemoteController");
            return false;
        }
        return true;
    }

    public MetadataEditor editMetadata() {
        MetadataEditor editor = new MetadataEditor();
        editor.mEditorMetadata = new Bundle();
        editor.mEditorArtwork = null;
        editor.mMetadataChanged = true;
        editor.mArtworkChanged = true;
        editor.mEditableKeys = 0L;
        return editor;
    }

    void startListeningToSessions() {
        ComponentName listenerComponent = new ComponentName(this.mContext, this.mOnClientUpdateListener.getClass());
        Handler handler = null;
        if (Looper.myLooper() == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        this.mSessionManager.addOnActiveSessionsChangedListener(this.mSessionListener, listenerComponent, handler);
        this.mSessionListener.onActiveSessionsChanged(this.mSessionManager.getActiveSessions(listenerComponent));
    }

    void stopListeningToSessions() {
        this.mSessionManager.removeOnActiveSessionsChangedListener(this.mSessionListener);
    }

    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delayMs) {
        if (handler == null) {
            Log.e(TAG, "null event handler, will not deliver message " + msg);
            return;
        }
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClientChange(boolean clearing) {
        OnClientUpdateListener l;
        Object object = mInfoLock;
        synchronized (object) {
            l = this.mOnClientUpdateListener;
            this.mMetadataEditor = null;
        }
        if (l != null) {
            l.onClientChange(clearing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateController(MediaController controller) {
        Object object = mInfoLock;
        synchronized (object) {
            if (controller == null) {
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.unregisterCallback(this.mSessionCb);
                    this.mCurrentSession = null;
                    RemoteController.sendMsg(this.mEventHandler, 0, 0, 0, 1, null, 0);
                }
            } else if (this.mCurrentSession == null || !controller.getSessionToken().equals(this.mCurrentSession.getSessionToken())) {
                if (this.mCurrentSession != null) {
                    this.mCurrentSession.unregisterCallback(this.mSessionCb);
                }
                RemoteController.sendMsg(this.mEventHandler, 0, 0, 0, 0, null, 0);
                this.mCurrentSession = controller;
                this.mCurrentSession.registerCallback(this.mSessionCb, this.mEventHandler);
                PlaybackState state = controller.getPlaybackState();
                RemoteController.sendMsg(this.mEventHandler, 1, 0, 0, 0, state, 0);
                MediaMetadata metadata = controller.getMetadata();
                RemoteController.sendMsg(this.mEventHandler, 2, 0, 0, 0, metadata, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewPlaybackState(PlaybackState state) {
        OnClientUpdateListener l;
        Object object = mInfoLock;
        synchronized (object) {
            l = this.mOnClientUpdateListener;
        }
        if (l != null) {
            int playstate;
            int n = playstate = state == null ? 0 : RemoteControlClient.getRccStateFromState(state.getState());
            if (state == null || state.getPosition() == -1L) {
                l.onClientPlaybackStateUpdate(playstate);
            } else {
                l.onClientPlaybackStateUpdate(playstate, state.getLastPositionUpdateTime(), state.getPosition(), state.getPlaybackSpeed());
            }
            if (state != null) {
                l.onClientTransportControlUpdate(RemoteControlClient.getRccControlFlagsFromActions(state.getActions()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewMediaMetadata(MediaMetadata metadata) {
        MetadataEditor metadataEditor;
        OnClientUpdateListener l;
        if (metadata == null) {
            return;
        }
        Object object = mInfoLock;
        synchronized (object) {
            l = this.mOnClientUpdateListener;
            boolean canRate = this.mCurrentSession != null && this.mCurrentSession.getRatingType() != 0;
            long editableKeys = canRate ? 0x10000001L : 0L;
            Bundle legacyMetadata = MediaSessionLegacyHelper.getOldMetadata(metadata, this.mArtworkWidth, this.mArtworkHeight);
            metadataEditor = this.mMetadataEditor = new MetadataEditor(legacyMetadata, editableKeys);
        }
        if (l != null) {
            l.onClientMetadataUpdate(metadataEditor);
        }
    }

    @UnsupportedAppUsage
    OnClientUpdateListener getUpdateListener() {
        return this.mOnClientUpdateListener;
    }

    public static interface OnClientUpdateListener {
        public void onClientChange(boolean var1);

        public void onClientPlaybackStateUpdate(int var1);

        public void onClientPlaybackStateUpdate(int var1, long var2, long var4, float var6);

        public void onClientTransportControlUpdate(int var1);

        public void onClientMetadataUpdate(MetadataEditor var1);
    }

    private class MediaControllerCallback
    extends MediaController.Callback {
        private MediaControllerCallback() {
        }

        @Override
        public void onPlaybackStateChanged(PlaybackState state) {
            RemoteController.this.onNewPlaybackState(state);
        }

        @Override
        public void onMetadataChanged(MediaMetadata metadata) {
            RemoteController.this.onNewMediaMetadata(metadata);
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(RemoteController rc, Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    RemoteController.this.onClientChange(msg.arg2 == 1);
                    break;
                }
                case 1: {
                    RemoteController.this.onNewPlaybackState((PlaybackState)msg.obj);
                    break;
                }
                case 2: {
                    RemoteController.this.onNewMediaMetadata((MediaMetadata)msg.obj);
                    break;
                }
                default: {
                    Log.e(RemoteController.TAG, "unknown event " + msg.what);
                }
            }
        }
    }

    private class TopTransportSessionListener
    implements MediaSessionManager.OnActiveSessionsChangedListener {
        private TopTransportSessionListener() {
        }

        @Override
        public void onActiveSessionsChanged(List<MediaController> controllers) {
            int size = controllers.size();
            for (int i = 0; i < size; ++i) {
                MediaController controller = controllers.get(i);
                long flags = controller.getFlags();
                if ((flags & 2L) == 0L) continue;
                RemoteController.this.updateController(controller);
                return;
            }
            RemoteController.this.updateController(null);
        }
    }

    public class MetadataEditor
    extends MediaMetadataEditor {
        protected MetadataEditor() {
        }

        protected MetadataEditor(Bundle metadata, long editableKeys) {
            this.mEditorMetadata = metadata;
            this.mEditableKeys = editableKeys;
            this.mEditorArtwork = metadata.getParcelable(String.valueOf(100), Bitmap.class);
            if (this.mEditorArtwork != null) {
                this.cleanupBitmapFromBundle(100);
            }
            this.mMetadataChanged = true;
            this.mArtworkChanged = true;
            this.mApplied = false;
        }

        private void cleanupBitmapFromBundle(int key) {
            if (METADATA_KEYS_TYPE.get(key, -1) == 2) {
                this.mEditorMetadata.remove(String.valueOf(key));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void apply() {
            if (!this.mMetadataChanged) {
                return;
            }
            Object object = mInfoLock;
            synchronized (object) {
                Rating rating;
                if (RemoteController.this.mCurrentSession != null && this.mEditorMetadata.containsKey(String.valueOf(0x10000001)) && (rating = (Rating)this.getObject(0x10000001, null)) != null) {
                    RemoteController.this.mCurrentSession.getTransportControls().setRating(rating);
                }
            }
            this.mApplied = false;
        }
    }

    private static class PlaybackInfo {
        int mState;
        long mStateChangeTimeMs;
        long mCurrentPosMs;
        float mSpeed;

        PlaybackInfo(int state, long stateChangeTimeMs, long currentPosMs, float speed) {
            this.mState = state;
            this.mStateChangeTimeMs = stateChangeTimeMs;
            this.mCurrentPosMs = currentPosMs;
            this.mSpeed = speed;
        }
    }
}

