/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.media.MediaCommunicationManager;
import android.media.MediaServiceManager;
import android.media.MediaTranscodingManager;
import android.media.internal.annotation.MinSdk;
import android.media.internal.utils.build.SdkLevel;
import com.android.layoutlib.androidx.annotation.RequiresApi;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@MinSdk(value=31)
@RequiresApi(value=31)
public class MediaFrameworkInitializer {
    private static volatile MediaServiceManager sMediaServiceManager;

    private MediaFrameworkInitializer() {
    }

    public static void setMediaServiceManager(@NonNull MediaServiceManager mediaServiceManager) {
        if (sMediaServiceManager != null) {
            throw new IllegalStateException("setMediaServiceManager called twice!");
        }
        if (mediaServiceManager == null) {
            throw new NullPointerException("mediaServiceManager is null!");
        }
        sMediaServiceManager = mediaServiceManager;
    }

    public static MediaServiceManager getMediaServiceManager() {
        return sMediaServiceManager;
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("media_transcoding", MediaTranscodingManager.class, context -> new MediaTranscodingManager(context));
        if (SdkLevel.isAtLeastS()) {
            SystemServiceRegistry.registerContextAwareService("media_communication", MediaCommunicationManager.class, context -> new MediaCommunicationManager(context));
        }
    }
}

