/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.Controller2Link;
import android.media.IMediaSession2Service;
import android.media.MediaSession2;
import android.media.Session2Command;
import android.media.Session2CommandGroup;
import android.media.Session2Link;
import android.media.Session2Token;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import java.util.concurrent.Executor;

public class MediaController2
implements AutoCloseable {
    static final String TAG = "MediaController2";
    static final boolean DEBUG = Log.isLoggable("MediaController2", 3);
    final ControllerCallback mCallback;
    private final IBinder.DeathRecipient mDeathRecipient = () -> this.close();
    private final Context mContext;
    private final Session2Token mSessionToken;
    private final Executor mCallbackExecutor;
    private final Controller2Link mControllerStub;
    private final Handler mResultHandler;
    private final SessionServiceConnection mServiceConnection;
    private final Object mLock = new Object();
    private boolean mClosed;
    private int mNextSeqNumber;
    private Session2Link mSessionBinder;
    private Session2CommandGroup mAllowedCommands;
    private Session2Token mConnectedToken;
    private ArrayMap<ResultReceiver, Integer> mPendingCommands;
    private ArraySet<Integer> mRequestedCommandSeqNumbers;
    private boolean mPlaybackActive;

    MediaController2(@NonNull Context context, @NonNull Session2Token token, @NonNull Bundle connectionHints, @NonNull Executor executor, @NonNull ControllerCallback callback) {
        boolean connectRequested;
        if (context == null) {
            throw new IllegalArgumentException("context shouldn't be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token shouldn't be null");
        }
        this.mContext = context;
        this.mSessionToken = token;
        this.mCallbackExecutor = executor == null ? context.getMainExecutor() : executor;
        this.mCallback = callback == null ? new ControllerCallback(this){} : callback;
        this.mControllerStub = new Controller2Link(this);
        this.mResultHandler = new Handler(context.getMainLooper());
        this.mNextSeqNumber = 0;
        this.mPendingCommands = new ArrayMap();
        this.mRequestedCommandSeqNumbers = new ArraySet();
        if (token.getType() == 0) {
            this.mServiceConnection = null;
            connectRequested = this.requestConnectToSession(connectionHints);
        } else {
            this.mServiceConnection = new SessionServiceConnection(connectionHints);
            connectRequested = this.requestConnectToService();
        }
        if (!connectRequested) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            if (DEBUG) {
                Log.d(TAG, "closing " + this);
            }
            this.mClosed = true;
            if (this.mServiceConnection != null) {
                this.mContext.unbindService(this.mServiceConnection);
            }
            if (this.mSessionBinder != null) {
                try {
                    this.mSessionBinder.disconnect(this.mControllerStub, this.getNextSeqNumber());
                    this.mSessionBinder.unlinkToDeath(this.mDeathRecipient, 0);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this.mConnectedToken = null;
            this.mPendingCommands.clear();
            this.mRequestedCommandSeqNumbers.clear();
            this.mCallbackExecutor.execute(() -> this.mCallback.onDisconnected(this));
            this.mSessionBinder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Session2Token getConnectedToken() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConnectedToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaybackActive() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPlaybackActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Object sendSessionCommand(final @NonNull Session2Command command, @Nullable Bundle args) {
        if (command == null) {
            throw new IllegalArgumentException("command shouldn't be null");
        }
        ResultReceiver resultReceiver = new ResultReceiver(this.mResultHandler){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                Object object = MediaController2.this.mLock;
                synchronized (object) {
                    MediaController2.this.mPendingCommands.remove(this);
                }
                MediaController2.this.mCallbackExecutor.execute(() -> MediaController2.this.mCallback.onCommandResult(MediaController2.this, this, command, new Session2Command.Result(resultCode, resultData)));
            }
        };
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionBinder != null) {
                int seq = this.getNextSeqNumber();
                this.mPendingCommands.put(resultReceiver, seq);
                try {
                    this.mSessionBinder.sendSessionCommand(this.mControllerStub, seq, command, args, resultReceiver);
                }
                catch (RuntimeException e) {
                    this.mPendingCommands.remove(resultReceiver);
                    resultReceiver.send(-1, null);
                }
            }
        }
        return resultReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSessionCommand(@NonNull Object token) {
        if (token == null) {
            throw new IllegalArgumentException("token shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessionBinder == null) {
                return;
            }
            Integer seq = this.mPendingCommands.remove(token);
            if (seq != null) {
                this.mSessionBinder.cancelSessionCommand(this.mControllerStub, seq);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConnected(int seq, Bundle connectionResult) {
        Session2Link sessionBinder = (Session2Link)connectionResult.getParcelable("android.media.key.SESSION2LINK");
        Session2CommandGroup allowedCommands = (Session2CommandGroup)connectionResult.getParcelable("android.media.key.ALLOWED_COMMANDS");
        boolean playbackActive = connectionResult.getBoolean("android.media.key.PLAYBACK_ACTIVE");
        Bundle tokenExtras = connectionResult.getBundle("android.media.key.TOKEN_EXTRAS");
        if (tokenExtras == null) {
            Log.w(TAG, "extras shouldn't be null.");
            tokenExtras = Bundle.EMPTY;
        } else if (MediaSession2.hasCustomParcelable(tokenExtras)) {
            Log.w(TAG, "extras contain custom parcelable. Ignoring.");
            tokenExtras = Bundle.EMPTY;
        }
        if (DEBUG) {
            Log.d(TAG, "notifyConnected sessionBinder=" + sessionBinder + ", allowedCommands=" + allowedCommands);
        }
        if (sessionBinder == null || allowedCommands == null) {
            this.close();
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionBinder = sessionBinder;
            this.mAllowedCommands = allowedCommands;
            this.mPlaybackActive = playbackActive;
            sessionBinder.linkToDeath(this.mDeathRecipient, 0);
            this.mConnectedToken = new Session2Token(this.mSessionToken.getUid(), 0, this.mSessionToken.getPackageName(), sessionBinder, tokenExtras);
        }
        this.mCallbackExecutor.execute(() -> this.mCallback.onConnected(this, allowedCommands));
    }

    void onDisconnected(int seq) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPlaybackActiveChanged(int seq, boolean playbackActive) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPlaybackActive = playbackActive;
        }
        this.mCallbackExecutor.execute(() -> this.mCallback.onPlaybackActiveChanged(this, playbackActive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionCommand(int seq, Session2Command command, Bundle args, @Nullable ResultReceiver resultReceiver) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRequestedCommandSeqNumbers.add(seq);
        }
        this.mCallbackExecutor.execute(() -> {
            boolean isCanceled;
            Object object = this.mLock;
            synchronized (object) {
                isCanceled = !this.mRequestedCommandSeqNumbers.remove(seq);
            }
            if (isCanceled) {
                if (resultReceiver != null) {
                    resultReceiver.send(1, null);
                }
                return;
            }
            Session2Command.Result result = this.mCallback.onSessionCommand(this, command, args);
            if (resultReceiver != null) {
                if (result == null) {
                    resultReceiver.send(1, null);
                } else {
                    resultReceiver.send(result.getResultCode(), result.getResultData());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelCommand(int seq) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRequestedCommandSeqNumbers.remove(seq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSeqNumber() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNextSeqNumber++;
        }
    }

    private Bundle createConnectionRequest(@NonNull Bundle connectionHints) {
        Bundle connectionRequest = new Bundle();
        connectionRequest.putString("android.media.key.PACKAGE_NAME", this.mContext.getPackageName());
        connectionRequest.putInt("android.media.key.PID", Process.myPid());
        connectionRequest.putBundle("android.media.key.CONNECTION_HINTS", connectionHints);
        return connectionRequest;
    }

    private boolean requestConnectToSession(@NonNull Bundle connectionHints) {
        Session2Link sessionBinder = this.mSessionToken.getSessionLink();
        Bundle connectionRequest = this.createConnectionRequest(connectionHints);
        try {
            sessionBinder.connect(this.mControllerStub, this.getNextSeqNumber(), connectionRequest);
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Failed to call connection request", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestConnectToService() {
        Intent intent = new Intent("android.media.MediaSession2Service");
        intent.setClassName(this.mSessionToken.getPackageName(), this.mSessionToken.getServiceName());
        Object object = this.mLock;
        synchronized (object) {
            boolean result = this.mContext.bindService(intent, (ServiceConnection)this.mServiceConnection, 1);
            if (!result) {
                Log.w(TAG, "bind to " + this.mSessionToken + " failed");
                return false;
            }
            if (DEBUG) {
                Log.d(TAG, "bind to " + this.mSessionToken + " succeeded");
            }
        }
        return true;
    }

    public static abstract class ControllerCallback {
        public void onConnected(@NonNull MediaController2 controller, @NonNull Session2CommandGroup allowedCommands) {
        }

        public void onDisconnected(@NonNull MediaController2 controller) {
        }

        public void onPlaybackActiveChanged(@NonNull MediaController2 controller, boolean playbackActive) {
        }

        @Nullable
        public Session2Command.Result onSessionCommand(@NonNull MediaController2 controller, @NonNull Session2Command command, @Nullable Bundle args) {
            return null;
        }

        public void onCommandResult(@NonNull MediaController2 controller, @NonNull Object token, @NonNull Session2Command command, @NonNull Session2Command.Result result) {
        }
    }

    private class SessionServiceConnection
    implements ServiceConnection {
        private final Bundle mConnectionHints;

        SessionServiceConnection(Bundle connectionHints) {
            this.mConnectionHints = connectionHints;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            boolean connectRequested = false;
            try {
                if (DEBUG) {
                    Log.d(MediaController2.TAG, "onServiceConnected " + name + " " + this);
                }
                if (!MediaController2.this.mSessionToken.getPackageName().equals(name.getPackageName())) {
                    Log.wtf(MediaController2.TAG, "Expected connection to " + MediaController2.this.mSessionToken.getPackageName() + " but is connected to " + name);
                    return;
                }
                IMediaSession2Service iService = IMediaSession2Service.Stub.asInterface(service);
                if (iService == null) {
                    Log.wtf(MediaController2.TAG, "Service interface is missing.");
                    return;
                }
                Bundle connectionRequest = MediaController2.this.createConnectionRequest(this.mConnectionHints);
                iService.connect(MediaController2.this.mControllerStub, MediaController2.this.getNextSeqNumber(), connectionRequest);
                connectRequested = true;
            }
            catch (RemoteException e) {
                Log.w(MediaController2.TAG, "Service " + name + " has died prematurely", e);
            }
            finally {
                if (!connectRequested) {
                    MediaController2.this.close();
                }
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            if (DEBUG) {
                Log.w(MediaController2.TAG, "Session service " + name + " is disconnected.");
            }
            MediaController2.this.close();
        }

        @Override
        public void onBindingDied(ComponentName name) {
            MediaController2.this.close();
        }
    }

    public static class Builder {
        private Context mContext;
        private Session2Token mToken;
        private Bundle mConnectionHints;
        private Executor mCallbackExecutor;
        private ControllerCallback mCallback;

        public Builder(@NonNull Context context, @NonNull Session2Token token) {
            if (context == null) {
                throw new IllegalArgumentException("context shouldn't be null");
            }
            if (token == null) {
                throw new IllegalArgumentException("token shouldn't be null");
            }
            this.mContext = context;
            this.mToken = token;
        }

        @NonNull
        public Builder setConnectionHints(@NonNull Bundle connectionHints) {
            if (connectionHints == null) {
                throw new IllegalArgumentException("connectionHints shouldn't be null");
            }
            if (MediaSession2.hasCustomParcelable(connectionHints)) {
                throw new IllegalArgumentException("connectionHints shouldn't contain any custom parcelables");
            }
            this.mConnectionHints = new Bundle(connectionHints);
            return this;
        }

        @NonNull
        public Builder setControllerCallback(@NonNull Executor executor, @NonNull ControllerCallback callback) {
            if (executor == null) {
                throw new IllegalArgumentException("executor shouldn't be null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("callback shouldn't be null");
            }
            this.mCallbackExecutor = executor;
            this.mCallback = callback;
            return this;
        }

        @NonNull
        public MediaController2 build() {
            if (this.mCallbackExecutor == null) {
                this.mCallbackExecutor = this.mContext.getMainExecutor();
            }
            if (this.mCallback == null) {
                this.mCallback = new ControllerCallback(this){};
            }
            if (this.mConnectionHints == null) {
                this.mConnectionHints = Bundle.EMPTY;
            }
            return new MediaController2(this.mContext, this.mToken, this.mConnectionHints, this.mCallbackExecutor, this.mCallback);
        }
    }
}

