/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IAudioManagerNative
extends IInterface {
    public static final String DESCRIPTOR = "android.media.IAudioManagerNative";

    public void playbackHardeningEvent(int var1, byte var2, boolean var3) throws RemoteException;

    public void permissionUpdateBarrier() throws RemoteException;

    public void portMuteEvent(int var1, int var2) throws RemoteException;

    public static @interface HardeningType {
        public static final byte PARTIAL = 0;
        public static final byte FULL = 1;
    }

    public static abstract class Stub
    extends Binder
    implements IAudioManagerNative {
        static final int TRANSACTION_playbackHardeningEvent = 1;
        static final int TRANSACTION_permissionUpdateBarrier = 2;
        static final int TRANSACTION_portMuteEvent = 3;

        public Stub() {
            this.attachInterface(this, IAudioManagerNative.DESCRIPTOR);
        }

        public static IAudioManagerNative asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAudioManagerNative.DESCRIPTOR);
            if (iin != null && iin instanceof IAudioManagerNative) {
                return (IAudioManagerNative)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAudioManagerNative.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    byte _arg1 = data.readByte();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.playbackHardeningEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    this.permissionUpdateBarrier();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.portMuteEvent(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IAudioManagerNative {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAudioManagerNative.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playbackHardeningEvent(int uid, byte type, boolean bypassed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAudioManagerNative.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeByte(type);
                    _data.writeBoolean(bypassed);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void permissionUpdateBarrier() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAudioManagerNative.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void portMuteEvent(int portId, int event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAudioManagerNative.DESCRIPTOR);
                    _data.writeInt(portId);
                    _data.writeInt(event);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAudioManagerNative {
        @Override
        public void playbackHardeningEvent(int uid, byte type, boolean bypassed) throws RemoteException {
        }

        @Override
        public void permissionUpdateBarrier() throws RemoteException {
        }

        @Override
        public void portMuteEvent(int portId, int event) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

