/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.media.AudioFormat;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class AudioProfile
implements Parcelable {
    public static final int AUDIO_ENCAPSULATION_TYPE_NONE = 0;
    public static final int AUDIO_ENCAPSULATION_TYPE_IEC61937 = 1;
    public static final int AUDIO_ENCAPSULATION_TYPE_PCM = 2;
    private final int mFormat;
    private final int[] mSamplingRates;
    private final int[] mChannelMasks;
    private final int[] mChannelIndexMasks;
    private final int mEncapsulationType;
    @NonNull
    public static final Parcelable.Creator<AudioProfile> CREATOR = new Parcelable.Creator<AudioProfile>(){

        @Override
        public AudioProfile createFromParcel(Parcel p) {
            return new AudioProfile(p);
        }

        public AudioProfile[] newArray(int size) {
            return new AudioProfile[size];
        }
    };

    @SystemApi
    public AudioProfile(int format, @NonNull int[] samplingRates, @NonNull int[] channelMasks, @NonNull int[] channelIndexMasks, int encapsulationType) {
        this.mFormat = format;
        this.mSamplingRates = samplingRates;
        this.mChannelMasks = channelMasks;
        this.mChannelIndexMasks = channelIndexMasks;
        this.mEncapsulationType = encapsulationType;
    }

    public int getFormat() {
        return this.mFormat;
    }

    @NonNull
    public int[] getChannelMasks() {
        return this.mChannelMasks;
    }

    @NonNull
    public int[] getChannelIndexMasks() {
        return this.mChannelIndexMasks;
    }

    @NonNull
    public int[] getSampleRates() {
        return this.mSamplingRates;
    }

    public int getEncapsulationType() {
        return this.mEncapsulationType;
    }

    public int hashCode() {
        return Objects.hash(this.mFormat, Arrays.hashCode(this.mSamplingRates), Arrays.hashCode(this.mChannelMasks), Arrays.hashCode(this.mChannelIndexMasks), this.mEncapsulationType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioProfile that = (AudioProfile)o;
        return this.mFormat == that.mFormat && AudioProfile.hasIdenticalElements(this.mSamplingRates, that.mSamplingRates) && AudioProfile.hasIdenticalElements(this.mChannelMasks, that.mChannelMasks) && AudioProfile.hasIdenticalElements(this.mChannelIndexMasks, that.mChannelIndexMasks) && this.mEncapsulationType == that.mEncapsulationType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(AudioFormat.toLogFriendlyEncoding(this.mFormat));
        if (this.mSamplingRates != null && this.mSamplingRates.length > 0) {
            sb.append(", sampling rates=").append(Arrays.toString(this.mSamplingRates));
        }
        if (this.mChannelMasks != null && this.mChannelMasks.length > 0) {
            sb.append(", channel masks=").append(AudioProfile.toHexString(this.mChannelMasks));
        }
        if (this.mChannelIndexMasks != null && this.mChannelIndexMasks.length > 0) {
            sb.append(", channel index masks=").append(Arrays.toString(this.mChannelIndexMasks));
        }
        sb.append(", encapsulation type=" + this.mEncapsulationType);
        sb.append("}");
        return sb.toString();
    }

    private static String toHexString(int[] ints) {
        if (ints == null || ints.length == 0) {
            return "";
        }
        return Arrays.stream(ints).mapToObj(anInt -> String.format("0x%02X", anInt)).collect(Collectors.joining(", "));
    }

    private static boolean hasIdenticalElements(int[] array1, int[] array2) {
        int[] sortedArray1 = Arrays.copyOf(array1, array1.length);
        Arrays.sort(sortedArray1);
        int[] sortedArray2 = Arrays.copyOf(array2, array2.length);
        Arrays.sort(sortedArray2);
        return Arrays.equals(sortedArray1, sortedArray2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFormat);
        dest.writeIntArray(this.mSamplingRates);
        dest.writeIntArray(this.mChannelMasks);
        dest.writeIntArray(this.mChannelIndexMasks);
        dest.writeInt(this.mEncapsulationType);
    }

    private AudioProfile(@NonNull Parcel in) {
        this.mFormat = in.readInt();
        this.mSamplingRates = in.createIntArray();
        this.mChannelMasks = in.createIntArray();
        this.mChannelIndexMasks = in.createIntArray();
        this.mEncapsulationType = in.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapsulationType {
    }
}

