/*
 * Decompiled with CFR 0.152.
 */
package android.location.provider;

import android.location.Address;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IGeocodeCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.location.provider.IGeocodeCallback";

    public void onError(String var1) throws RemoteException;

    public void onResults(List<Address> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGeocodeCallback {
        static final int TRANSACTION_onError = 1;
        static final int TRANSACTION_onResults = 2;

        public Stub() {
            this.attachInterface(this, IGeocodeCallback.DESCRIPTOR);
        }

        public static IGeocodeCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IGeocodeCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IGeocodeCallback) {
                return (IGeocodeCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onError";
                }
                case 2: {
                    return "onResults";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IGeocodeCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                case 2: {
                    ArrayList<Address> _arg0 = data.createTypedArrayList(Address.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResults(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IGeocodeCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IGeocodeCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String error) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IGeocodeCallback.DESCRIPTOR);
                    _data.writeString(error);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResults(List<Address> results) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IGeocodeCallback.DESCRIPTOR);
                    _data.writeTypedList(results, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IGeocodeCallback {
        @Override
        public void onError(String error) throws RemoteException {
        }

        @Override
        public void onResults(List<Address> results) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

