/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GnssAntennaInfo
implements Parcelable {
    private final double mCarrierFrequencyMHz;
    private final PhaseCenterOffset mPhaseCenterOffset;
    @Nullable
    private final SphericalCorrections mPhaseCenterVariationCorrections;
    @Nullable
    private final SphericalCorrections mSignalGainCorrections;
    @NonNull
    public static final Parcelable.Creator<GnssAntennaInfo> CREATOR = new Parcelable.Creator<GnssAntennaInfo>(){

        @Override
        public GnssAntennaInfo createFromParcel(Parcel in) {
            double carrierFrequencyMHz = in.readDouble();
            PhaseCenterOffset phaseCenterOffset = in.readTypedObject(PhaseCenterOffset.CREATOR);
            SphericalCorrections phaseCenterVariationCorrections = in.readTypedObject(SphericalCorrections.CREATOR);
            SphericalCorrections signalGainCorrections = in.readTypedObject(SphericalCorrections.CREATOR);
            return new GnssAntennaInfo(carrierFrequencyMHz, phaseCenterOffset, phaseCenterVariationCorrections, signalGainCorrections);
        }

        public GnssAntennaInfo[] newArray(int size) {
            return new GnssAntennaInfo[size];
        }
    };

    private GnssAntennaInfo(double carrierFrequencyMHz, PhaseCenterOffset phaseCenterOffset, @Nullable SphericalCorrections phaseCenterVariationCorrections, @Nullable SphericalCorrections signalGainCorrectionDbi) {
        this.mCarrierFrequencyMHz = carrierFrequencyMHz;
        this.mPhaseCenterOffset = Objects.requireNonNull(phaseCenterOffset);
        this.mPhaseCenterVariationCorrections = phaseCenterVariationCorrections;
        this.mSignalGainCorrections = signalGainCorrectionDbi;
    }

    public double getCarrierFrequencyMHz() {
        return this.mCarrierFrequencyMHz;
    }

    @NonNull
    public PhaseCenterOffset getPhaseCenterOffset() {
        return this.mPhaseCenterOffset;
    }

    @Nullable
    public SphericalCorrections getPhaseCenterVariationCorrections() {
        return this.mPhaseCenterVariationCorrections;
    }

    @Nullable
    public SphericalCorrections getSignalGainCorrections() {
        return this.mSignalGainCorrections;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeDouble(this.mCarrierFrequencyMHz);
        parcel.writeTypedObject(this.mPhaseCenterOffset, flags);
        parcel.writeTypedObject(this.mPhaseCenterVariationCorrections, flags);
        parcel.writeTypedObject(this.mSignalGainCorrections, flags);
    }

    public String toString() {
        return "GnssAntennaInfo{CarrierFrequencyMHz=" + this.mCarrierFrequencyMHz + ", PhaseCenterOffset=" + this.mPhaseCenterOffset + ", PhaseCenterVariationCorrections=" + this.mPhaseCenterVariationCorrections + ", SignalGainCorrections=" + this.mSignalGainCorrections + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GnssAntennaInfo)) {
            return false;
        }
        GnssAntennaInfo that = (GnssAntennaInfo)o;
        return Double.compare(that.mCarrierFrequencyMHz, this.mCarrierFrequencyMHz) == 0 && this.mPhaseCenterOffset.equals(that.mPhaseCenterOffset) && Objects.equals(this.mPhaseCenterVariationCorrections, that.mPhaseCenterVariationCorrections) && Objects.equals(this.mSignalGainCorrections, that.mSignalGainCorrections);
    }

    public int hashCode() {
        return Objects.hash(this.mCarrierFrequencyMHz, this.mPhaseCenterOffset, this.mPhaseCenterVariationCorrections, this.mSignalGainCorrections);
    }

    public static class PhaseCenterOffset
    implements Parcelable {
        private final double mOffsetXMm;
        private final double mOffsetXUncertaintyMm;
        private final double mOffsetYMm;
        private final double mOffsetYUncertaintyMm;
        private final double mOffsetZMm;
        private final double mOffsetZUncertaintyMm;
        @NonNull
        public static final Parcelable.Creator<PhaseCenterOffset> CREATOR = new Parcelable.Creator<PhaseCenterOffset>(){

            @Override
            public PhaseCenterOffset createFromParcel(Parcel in) {
                return new PhaseCenterOffset(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
            }

            public PhaseCenterOffset[] newArray(int size) {
                return new PhaseCenterOffset[size];
            }
        };

        public PhaseCenterOffset(double offsetXMm, double offsetXUncertaintyMm, double offsetYMm, double offsetYUncertaintyMm, double offsetZMm, double offsetZUncertaintyMm) {
            this.mOffsetXMm = offsetXMm;
            this.mOffsetYMm = offsetYMm;
            this.mOffsetZMm = offsetZMm;
            this.mOffsetXUncertaintyMm = offsetXUncertaintyMm;
            this.mOffsetYUncertaintyMm = offsetYUncertaintyMm;
            this.mOffsetZUncertaintyMm = offsetZUncertaintyMm;
        }

        public double getXOffsetMm() {
            return this.mOffsetXMm;
        }

        public double getXOffsetUncertaintyMm() {
            return this.mOffsetXUncertaintyMm;
        }

        public double getYOffsetMm() {
            return this.mOffsetYMm;
        }

        public double getYOffsetUncertaintyMm() {
            return this.mOffsetYUncertaintyMm;
        }

        public double getZOffsetMm() {
            return this.mOffsetZMm;
        }

        public double getZOffsetUncertaintyMm() {
            return this.mOffsetZUncertaintyMm;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeDouble(this.mOffsetXMm);
            dest.writeDouble(this.mOffsetXUncertaintyMm);
            dest.writeDouble(this.mOffsetYMm);
            dest.writeDouble(this.mOffsetYUncertaintyMm);
            dest.writeDouble(this.mOffsetZMm);
            dest.writeDouble(this.mOffsetZUncertaintyMm);
        }

        public String toString() {
            return "PhaseCenterOffset{OffsetXMm=" + this.mOffsetXMm + " +/-" + this.mOffsetXUncertaintyMm + ", OffsetYMm=" + this.mOffsetYMm + " +/-" + this.mOffsetYUncertaintyMm + ", OffsetZMm=" + this.mOffsetZMm + " +/-" + this.mOffsetZUncertaintyMm + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PhaseCenterOffset)) {
                return false;
            }
            PhaseCenterOffset that = (PhaseCenterOffset)o;
            return Double.compare(that.mOffsetXMm, this.mOffsetXMm) == 0 && Double.compare(that.mOffsetXUncertaintyMm, this.mOffsetXUncertaintyMm) == 0 && Double.compare(that.mOffsetYMm, this.mOffsetYMm) == 0 && Double.compare(that.mOffsetYUncertaintyMm, this.mOffsetYUncertaintyMm) == 0 && Double.compare(that.mOffsetZMm, this.mOffsetZMm) == 0 && Double.compare(that.mOffsetZUncertaintyMm, this.mOffsetZUncertaintyMm) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.mOffsetXMm, this.mOffsetYMm, this.mOffsetZMm);
        }
    }

    public static class SphericalCorrections
    implements Parcelable {
        private final int mNumRows;
        private final int mNumColumns;
        private final double[][] mCorrections;
        private final double[][] mCorrectionUncertainties;
        @NonNull
        public static final Parcelable.Creator<SphericalCorrections> CREATOR = new Parcelable.Creator<SphericalCorrections>(){

            @Override
            public SphericalCorrections createFromParcel(Parcel in) {
                return new SphericalCorrections(in);
            }

            public SphericalCorrections[] newArray(int size) {
                return new SphericalCorrections[size];
            }
        };

        public SphericalCorrections(@NonNull double[][] corrections, @NonNull double[][] correctionUncertainties) {
            if (corrections.length != correctionUncertainties.length || corrections.length < 1) {
                throw new IllegalArgumentException("correction and uncertainty arrays must have the same (non-zero) dimensions");
            }
            this.mNumRows = corrections.length;
            this.mNumColumns = corrections[0].length;
            for (int i = 0; i < corrections.length; ++i) {
                if (corrections[i].length == this.mNumColumns && correctionUncertainties[i].length == this.mNumColumns && this.mNumColumns >= 2) continue;
                throw new IllegalArgumentException("correction and uncertainty arrays must all  have the same (greater than 2) number of columns");
            }
            this.mCorrections = corrections;
            this.mCorrectionUncertainties = correctionUncertainties;
        }

        private SphericalCorrections(Parcel in) {
            int numRows = in.readInt();
            int numColumns = in.readInt();
            double[][] corrections = new double[numRows][numColumns];
            double[][] correctionUncertainties = new double[numRows][numColumns];
            for (int row = 0; row < numRows; ++row) {
                for (int col = 0; col < numColumns; ++col) {
                    corrections[row][col] = in.readDouble();
                    correctionUncertainties[row][col] = in.readDouble();
                }
            }
            this.mNumRows = numRows;
            this.mNumColumns = numColumns;
            this.mCorrections = corrections;
            this.mCorrectionUncertainties = correctionUncertainties;
        }

        @NonNull
        public double[][] getCorrectionsArray() {
            return this.mCorrections;
        }

        @NonNull
        public double[][] getCorrectionUncertaintiesArray() {
            return this.mCorrectionUncertainties;
        }

        public double getDeltaTheta() {
            return 360.0 / (double)this.mNumRows;
        }

        public double getDeltaPhi() {
            return 180.0 / (double)(this.mNumColumns - 1);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mNumRows);
            dest.writeInt(this.mNumColumns);
            for (int row = 0; row < this.mNumRows; ++row) {
                for (int col = 0; col < this.mNumColumns; ++col) {
                    dest.writeDouble(this.mCorrections[row][col]);
                    dest.writeDouble(this.mCorrectionUncertainties[row][col]);
                }
            }
        }

        public String toString() {
            return "SphericalCorrections{Corrections=" + Arrays.deepToString((Object[])this.mCorrections) + ", CorrectionUncertainties=" + Arrays.deepToString((Object[])this.mCorrectionUncertainties) + ", DeltaTheta=" + this.getDeltaTheta() + ", DeltaPhi=" + this.getDeltaPhi() + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SphericalCorrections)) {
                return false;
            }
            SphericalCorrections that = (SphericalCorrections)o;
            return this.mNumRows == that.mNumRows && this.mNumColumns == that.mNumColumns && Arrays.deepEquals((Object[])this.mCorrections, (Object[])that.mCorrections) && Arrays.deepEquals((Object[])this.mCorrectionUncertainties, (Object[])that.mCorrectionUncertainties);
        }

        public int hashCode() {
            int result = Arrays.deepHashCode((Object[])this.mCorrections);
            result = 31 * result + Arrays.deepHashCode((Object[])this.mCorrectionUncertainties);
            return result;
        }
    }

    public static class Builder {
        private double mCarrierFrequencyMHz;
        private PhaseCenterOffset mPhaseCenterOffset;
        @Nullable
        private SphericalCorrections mPhaseCenterVariationCorrections;
        @Nullable
        private SphericalCorrections mSignalGainCorrections;

        @Deprecated
        public Builder() {
            this(0.0, new PhaseCenterOffset(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }

        public Builder(double carrierFrequencyMHz, @NonNull PhaseCenterOffset phaseCenterOffset) {
            this.mCarrierFrequencyMHz = carrierFrequencyMHz;
            this.mPhaseCenterOffset = Objects.requireNonNull(phaseCenterOffset);
        }

        public Builder(@NonNull GnssAntennaInfo antennaInfo) {
            this.mCarrierFrequencyMHz = antennaInfo.mCarrierFrequencyMHz;
            this.mPhaseCenterOffset = antennaInfo.mPhaseCenterOffset;
            this.mPhaseCenterVariationCorrections = antennaInfo.mPhaseCenterVariationCorrections;
            this.mSignalGainCorrections = antennaInfo.mSignalGainCorrections;
        }

        @NonNull
        public Builder setCarrierFrequencyMHz(double carrierFrequencyMHz) {
            this.mCarrierFrequencyMHz = carrierFrequencyMHz;
            return this;
        }

        @NonNull
        public Builder setPhaseCenterOffset(@NonNull PhaseCenterOffset phaseCenterOffset) {
            this.mPhaseCenterOffset = Objects.requireNonNull(phaseCenterOffset);
            return this;
        }

        @NonNull
        public Builder setPhaseCenterVariationCorrections(@Nullable SphericalCorrections phaseCenterVariationCorrections) {
            this.mPhaseCenterVariationCorrections = phaseCenterVariationCorrections;
            return this;
        }

        @NonNull
        public Builder setSignalGainCorrections(@Nullable SphericalCorrections signalGainCorrections) {
            this.mSignalGainCorrections = signalGainCorrections;
            return this;
        }

        @NonNull
        public GnssAntennaInfo build() {
            return new GnssAntennaInfo(this.mCarrierFrequencyMHz, this.mPhaseCenterOffset, this.mPhaseCenterVariationCorrections, this.mSignalGainCorrections);
        }
    }

    public static interface Listener {
        public void onGnssAntennaInfoReceived(@NonNull List<GnssAntennaInfo> var1);
    }
}

