/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice.navigationbar;

import android.annotation.Nullable;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.util.ArrayList;

class ReverseLinearLayout
extends LinearLayout {
    private boolean mIsLayoutReverse;
    private boolean mIsAlternativeOrder;

    ReverseLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.updateOrder();
    }

    @Override
    public void addView(View child) {
        ReverseLinearLayout.reverseParams(child.getLayoutParams(), child, this.mIsLayoutReverse);
        if (this.mIsLayoutReverse) {
            super.addView(child, 0);
        } else {
            super.addView(child);
        }
    }

    @Override
    public void addView(View child, ViewGroup.LayoutParams params) {
        ReverseLinearLayout.reverseParams(params, child, this.mIsLayoutReverse);
        if (this.mIsLayoutReverse) {
            super.addView(child, 0, params);
        } else {
            super.addView(child, params);
        }
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.updateOrder();
    }

    public void setAlternativeOrder(boolean alternative) {
        this.mIsAlternativeOrder = alternative;
        this.updateOrder();
    }

    private void updateOrder() {
        boolean isLayoutRtl = this.getLayoutDirection() == 1;
        boolean isLayoutReverse = isLayoutRtl ^ this.mIsAlternativeOrder;
        if (this.mIsLayoutReverse != isLayoutReverse) {
            int i;
            int childCount = this.getChildCount();
            ArrayList<View> childList = new ArrayList<View>(childCount);
            for (i = 0; i < childCount; ++i) {
                childList.add(this.getChildAt(i));
            }
            this.removeAllViews();
            for (i = childCount - 1; i >= 0; --i) {
                View child = (View)childList.get(i);
                super.addView(child);
            }
            this.mIsLayoutReverse = isLayoutReverse;
        }
    }

    private static void reverseParams(ViewGroup.LayoutParams params, View child, boolean isLayoutReverse) {
        if (child instanceof Reversible) {
            ((Reversible)((Object)child)).reverse(isLayoutReverse);
        }
        if (child.getPaddingLeft() == child.getPaddingRight() && child.getPaddingTop() == child.getPaddingBottom()) {
            child.setPadding(child.getPaddingTop(), child.getPaddingLeft(), child.getPaddingTop(), child.getPaddingLeft());
        }
        if (params == null) {
            return;
        }
        int width = params.width;
        params.width = params.height;
        params.height = width;
    }

    private static void reverseGroup(ViewGroup group, boolean isLayoutReverse) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            ReverseLinearLayout.reverseParams(child.getLayoutParams(), child, isLayoutReverse);
            if (!(child instanceof ViewGroup)) continue;
            ReverseLinearLayout.reverseGroup((ViewGroup)child, isLayoutReverse);
        }
    }

    static interface Reversible {
        public void reverse(boolean var1);
    }

    public static class ReverseRelativeLayout
    extends RelativeLayout
    implements Reversible {
        private int mDefaultGravity = 0;

        ReverseRelativeLayout(Context context) {
            super(context);
        }

        @Override
        public void reverse(boolean isLayoutReverse) {
            this.updateGravity(isLayoutReverse);
            ReverseLinearLayout.reverseGroup(this, isLayoutReverse);
        }

        public void setDefaultGravity(int gravity) {
            this.mDefaultGravity = gravity;
        }

        public void updateGravity(boolean isLayoutReverse) {
            if (this.mDefaultGravity != 48 && this.mDefaultGravity != 80) {
                return;
            }
            int gravityToApply = this.mDefaultGravity;
            if (isLayoutReverse) {
                int n = gravityToApply = this.mDefaultGravity == 48 ? 80 : 48;
            }
            if (this.getGravity() != gravityToApply) {
                this.setGravity(gravityToApply);
            }
        }
    }
}

