/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.Nullable;
import android.health.connect.datatypes.PlannedExerciseBlock;
import android.health.connect.internal.datatypes.PlannedExerciseStepInternal;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.List;

public class PlannedExerciseBlockInternal {
    private int mRepetitions;
    @Nullable
    private String mDescription;
    private List<PlannedExerciseStepInternal> mExerciseSteps = new ArrayList<PlannedExerciseStepInternal>();

    public static void writeToParcel(List<PlannedExerciseBlockInternal> blocks, Parcel parcel) {
        parcel.writeInt(blocks.size());
        for (PlannedExerciseBlockInternal block : blocks) {
            parcel.writeInt(block.getRepetitions());
            parcel.writeString(block.getDescription());
            PlannedExerciseStepInternal.writeToParcel(block.getExerciseSteps(), parcel);
        }
    }

    public static List<PlannedExerciseBlockInternal> readFromParcel(Parcel parcel) {
        ArrayList<PlannedExerciseBlockInternal> result = new ArrayList<PlannedExerciseBlockInternal>();
        int count = parcel.readInt();
        for (int i = 0; i < count; ++i) {
            PlannedExerciseBlockInternal block = new PlannedExerciseBlockInternal(parcel.readInt());
            block.setDescription(parcel.readString());
            block.setExerciseSteps(PlannedExerciseStepInternal.readFromParcel(parcel));
            result.add(block);
        }
        return result;
    }

    public PlannedExerciseBlockInternal(int repetitions) {
        this.mRepetitions = repetitions;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public int getRepetitions() {
        return this.mRepetitions;
    }

    public List<PlannedExerciseStepInternal> getExerciseSteps() {
        return this.mExerciseSteps;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setRepetitions(int repetitions) {
        this.mRepetitions = repetitions;
    }

    public void setExerciseSteps(List<PlannedExerciseStepInternal> exerciseSteps) {
        this.mExerciseSteps = exerciseSteps;
    }

    public PlannedExerciseBlock toExternalObject() {
        PlannedExerciseBlock.Builder builder = new PlannedExerciseBlock.Builder(this.mRepetitions);
        builder.setDescription(this.mDescription);
        for (PlannedExerciseStepInternal step : this.mExerciseSteps) {
            builder.addStep(step.toExternalObject());
        }
        return builder.build();
    }
}

