/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.ExerciseSegment;
import android.health.connect.datatypes.units.Mass;
import android.os.Parcel;
import com.android.healthfitness.flags.AconfigFlagHelper;
import com.android.healthfitness.flags.Flags;
import com.android.internal.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExerciseSegmentInternal {
    private long mStartTime;
    private long mEndTime;
    private int mSegmentType;
    private int mRepetitionsCount;
    @Nullable
    private Double mWeightGrams;
    private int mSetIndex = -1;
    private float mRateOfPerceivedExertion = Float.MIN_VALUE;

    @VisibleForTesting
    public static ExerciseSegmentInternal readFromParcel(Parcel parcel) {
        ExerciseSegmentInternal segment = new ExerciseSegmentInternal().setStartTime(parcel.readLong()).setEndTime(parcel.readLong()).setRepetitionsCount(parcel.readInt()).setSegmentType(parcel.readInt());
        if (AconfigFlagHelper.isExerciseSegmentImprovementsEnabled()) {
            boolean weightIsSet = parcel.readBoolean();
            if (weightIsSet) {
                segment.setWeightGrams(parcel.readDouble());
            }
            segment.setSetIndex(parcel.readInt());
            segment.setRateOfPerceivedExertion(parcel.readFloat());
        }
        return segment;
    }

    @Nullable
    static List<ExerciseSegmentInternal> populateSegmentsFromParcel(Parcel parcel) {
        int size = parcel.readInt();
        if (size == 0) {
            return null;
        }
        ArrayList<ExerciseSegmentInternal> segments = new ArrayList<ExerciseSegmentInternal>(size);
        for (int i = 0; i < size; ++i) {
            segments.add(ExerciseSegmentInternal.readFromParcel(parcel));
        }
        return segments;
    }

    static List<ExerciseSegment> getExternalSegments(@NonNull List<ExerciseSegmentInternal> internalSegments) {
        ArrayList<ExerciseSegment> externalSegments = new ArrayList<ExerciseSegment>(internalSegments.size());
        internalSegments.forEach(segment -> externalSegments.add(segment.toExternalRecord()));
        return externalSegments;
    }

    static void writeSegmentsToParcel(@Nullable List<ExerciseSegmentInternal> segments, Parcel parcel) {
        if (segments == null) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(segments.size());
        segments.forEach(segment -> segment.writeToParcel(parcel));
    }

    @VisibleForTesting
    public void writeToParcel(Parcel parcel) {
        parcel.writeLong(this.mStartTime);
        parcel.writeLong(this.mEndTime);
        parcel.writeInt(this.mRepetitionsCount);
        parcel.writeInt(this.mSegmentType);
        if (AconfigFlagHelper.isExerciseSegmentImprovementsEnabled()) {
            boolean weightIsSet = this.mWeightGrams != null;
            parcel.writeBoolean(weightIsSet);
            if (weightIsSet) {
                parcel.writeDouble(this.mWeightGrams);
            }
            parcel.writeInt(this.mSetIndex);
            parcel.writeFloat(this.mRateOfPerceivedExertion);
        }
    }

    @VisibleForTesting
    public ExerciseSegment toExternalRecord() {
        ExerciseSegment.Builder builder = new ExerciseSegment.Builder(Instant.ofEpochMilli(this.mStartTime), Instant.ofEpochMilli(this.mEndTime), this.getSegmentType());
        builder.setRepetitionsCount(this.mRepetitionsCount);
        if (Flags.exerciseSegmentImprovements() && AconfigFlagHelper.isExerciseSegmentImprovementsEnabled()) {
            if (this.mWeightGrams != null) {
                builder.setWeight(Mass.fromGrams(this.mWeightGrams));
            }
            if (this.mSetIndex != -1) {
                builder.setSetIndex(this.mSetIndex);
            }
            if (this.mRateOfPerceivedExertion != Float.MIN_VALUE) {
                builder.setRateOfPerceivedExertion(this.mRateOfPerceivedExertion);
            }
        }
        return builder.buildWithoutValidation();
    }

    public ExerciseSegmentInternal setStartTime(long startTime) {
        this.mStartTime = startTime;
        return this;
    }

    public ExerciseSegmentInternal setEndTime(long endTime) {
        this.mEndTime = endTime;
        return this;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public int getRepetitionsCount() {
        return this.mRepetitionsCount;
    }

    @Nullable
    public Double getWeightGrams() {
        return this.mWeightGrams;
    }

    public int getSetIndex() {
        return this.mSetIndex;
    }

    public float getRateOfPerceivedExertion() {
        return this.mRateOfPerceivedExertion;
    }

    public ExerciseSegmentInternal setRepetitionsCount(int repetitionsCount) {
        this.mRepetitionsCount = repetitionsCount;
        return this;
    }

    public ExerciseSegmentInternal setWeightGrams(double weightGrams) {
        this.mWeightGrams = weightGrams;
        return this;
    }

    public ExerciseSegmentInternal setSetIndex(int setIndex) {
        this.mSetIndex = setIndex;
        return this;
    }

    public ExerciseSegmentInternal setRateOfPerceivedExertion(float rateOfPerceivedExertion) {
        this.mRateOfPerceivedExertion = rateOfPerceivedExertion;
        return this;
    }

    public int getSegmentType() {
        return this.mSegmentType;
    }

    public ExerciseSegmentInternal setSegmentType(int segmentType) {
        this.mSegmentType = segmentType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseSegmentInternal)) {
            return false;
        }
        ExerciseSegmentInternal that = (ExerciseSegmentInternal)o;
        return this.mSegmentType == that.mSegmentType && this.mRepetitionsCount == that.mRepetitionsCount && this.mStartTime == that.mStartTime && this.mEndTime == that.mEndTime && Objects.equals(this.mWeightGrams, that.mWeightGrams) && this.mSetIndex == that.mSetIndex && this.mRateOfPerceivedExertion == that.mRateOfPerceivedExertion;
    }

    public int hashCode() {
        return Objects.hash(this.mStartTime, this.mEndTime, this.mSegmentType, this.mRepetitionsCount, this.mWeightGrams, this.mSetIndex, Float.valueOf(this.mRateOfPerceivedExertion));
    }
}

