/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.CyclingPedalingCadenceRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.internal.datatypes.SeriesRecordInternal;
import android.os.Parcel;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

@Identifier(recordIdentifier=12)
public class CyclingPedalingCadenceRecordInternal
extends SeriesRecordInternal<CyclingPedalingCadenceRecord, CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample> {
    private Set<CyclingPedalingCadenceRecordSample> mSamples = new TreeSet<CyclingPedalingCadenceRecordSample>(Comparator.comparingLong(CyclingPedalingCadenceRecordSample::getEpochMillis));

    public CyclingPedalingCadenceRecordInternal(Set<CyclingPedalingCadenceRecordSample> samples) {
        if (Flags.sampleTimeOrdering()) {
            this.mSamples.addAll(samples);
        } else {
            this.mSamples = samples;
        }
    }

    public CyclingPedalingCadenceRecordInternal(Parcel parcel) {
        super(parcel);
        int size = parcel.readInt();
        if (!Flags.sampleTimeOrdering()) {
            this.mSamples = new HashSet<CyclingPedalingCadenceRecordSample>(size);
        }
        for (int i = 0; i < size; ++i) {
            this.mSamples.add(new CyclingPedalingCadenceRecordSample(parcel.readDouble(), parcel.readLong()));
        }
    }

    @Override
    @NonNull
    public Set<CyclingPedalingCadenceRecordSample> getSamples() {
        return this.mSamples;
    }

    @Override
    @NonNull
    public CyclingPedalingCadenceRecord toExternalRecord() {
        return new CyclingPedalingCadenceRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExternalSamples()).setStartZoneOffset(this.getStartZoneOffset()).setEndZoneOffset(this.getEndZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateIntervalRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mSamples.size());
        for (CyclingPedalingCadenceRecordSample cyclingPedalingCadenceRecordSample : this.mSamples) {
            parcel.writeDouble(cyclingPedalingCadenceRecordSample.getRevolutionsPerMinute());
            parcel.writeLong(cyclingPedalingCadenceRecordSample.getEpochMillis());
        }
    }

    private List<CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample> getExternalSamples() {
        ArrayList<CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample> cyclingPedalingCadenceRecords = new ArrayList<CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample>(this.mSamples.size());
        for (CyclingPedalingCadenceRecordSample sample : this.mSamples) {
            cyclingPedalingCadenceRecords.add(new CyclingPedalingCadenceRecord.CyclingPedalingCadenceRecordSample(sample.getRevolutionsPerMinute(), Instant.ofEpochMilli(sample.getEpochMillis()), true));
        }
        return cyclingPedalingCadenceRecords;
    }

    public static class CyclingPedalingCadenceRecordSample
    implements SeriesRecordInternal.Sample {
        private final double mRevolutionsPerMinute;
        private final long mEpochMillis;

        public CyclingPedalingCadenceRecordSample(double revolutionsPerMinute, long epochMillis) {
            this.mRevolutionsPerMinute = revolutionsPerMinute;
            this.mEpochMillis = epochMillis;
        }

        public double getRevolutionsPerMinute() {
            return this.mRevolutionsPerMinute;
        }

        public long getEpochMillis() {
            return this.mEpochMillis;
        }

        public boolean equals(@Nullable Object object) {
            if (Flags.sampleTimeOrdering()) {
                if (object instanceof CyclingPedalingCadenceRecordSample) {
                    CyclingPedalingCadenceRecordSample other = (CyclingPedalingCadenceRecordSample)object;
                    return this.mEpochMillis == other.mEpochMillis && this.mRevolutionsPerMinute == other.mRevolutionsPerMinute;
                }
                return false;
            }
            if (super.equals(object) && object instanceof CyclingPedalingCadenceRecordSample) {
                CyclingPedalingCadenceRecordSample other = (CyclingPedalingCadenceRecordSample)object;
                return this.getEpochMillis() == other.getEpochMillis();
            }
            return false;
        }

        public int hashCode() {
            if (Flags.sampleTimeOrdering()) {
                return Objects.hash(this.mEpochMillis, this.mRevolutionsPerMinute);
            }
            return Objects.hash(this.mEpochMillis);
        }
    }
}

