/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.annotation.NonNull;
import android.health.connect.datatypes.BodyTemperatureRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.units.Temperature;
import android.health.connect.internal.datatypes.InstantRecordInternal;
import android.os.Parcel;

@Identifier(recordIdentifier=29)
public class BodyTemperatureRecordInternal
extends InstantRecordInternal<BodyTemperatureRecord> {
    private int mMeasurementLocation;
    private double mTemperature;

    public BodyTemperatureRecordInternal() {
    }

    public BodyTemperatureRecordInternal(Parcel parcel) {
        super(parcel);
        this.mMeasurementLocation = parcel.readInt();
        this.mTemperature = parcel.readDouble();
    }

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    @NonNull
    public BodyTemperatureRecordInternal setMeasurementLocation(int measurementLocation) {
        this.mMeasurementLocation = measurementLocation;
        return this;
    }

    public double getTemperature() {
        return this.mTemperature;
    }

    @NonNull
    public BodyTemperatureRecordInternal setTemperature(double temperature) {
        this.mTemperature = temperature;
        return this;
    }

    @Override
    @NonNull
    public BodyTemperatureRecord toExternalRecord() {
        return new BodyTemperatureRecord.Builder(this.buildMetaData(), this.getTime(), this.getMeasurementLocation(), Temperature.fromCelsius(this.getTemperature())).setZoneOffset(this.getZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateInstantRecordTo(@NonNull Parcel parcel) {
        parcel.writeInt(this.mMeasurementLocation);
        parcel.writeDouble(this.mTemperature);
    }
}

