/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.StepsCadenceRecordInternal;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

@Identifier(recordIdentifier=15)
public class StepsCadenceRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Double> STEPS_CADENCE_RATE_AVG = new AggregationType<Double>(81, 2, 15, Double.class);
    @NonNull
    public static final AggregationType<Double> STEPS_CADENCE_RATE_MIN = new AggregationType<Double>(82, 1, 15, Double.class);
    @NonNull
    public static final AggregationType<Double> STEPS_CADENCE_RATE_MAX = new AggregationType<Double>(83, 0, 15, Double.class);
    private final List<StepsCadenceRecordSample> mSamples;

    private StepsCadenceRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull List<StepsCadenceRecordSample> samples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(samples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, samples.stream().map(StepsCadenceRecordSample::getTime).toList());
        }
        this.mSamples = samples;
    }

    @NonNull
    public List<StepsCadenceRecordSample> getSamples() {
        return this.mSamples;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (super.equals(object) && object instanceof StepsCadenceRecord) {
            StepsCadenceRecord other = (StepsCadenceRecord)object;
            return Objects.equals(this.getSamples(), other.getSamples());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public StepsCadenceRecordInternal toRecordInternal() {
        HashSet<StepsCadenceRecordInternal.StepsCadenceRecordSample> samples = new HashSet<StepsCadenceRecordInternal.StepsCadenceRecordSample>(this.getSamples().size());
        for (StepsCadenceRecordSample stepsCadenceRecordSample : this.getSamples()) {
            samples.add(new StepsCadenceRecordInternal.StepsCadenceRecordSample(stepsCadenceRecordSample.getRate(), stepsCadenceRecordSample.getTime().toEpochMilli()));
        }
        StepsCadenceRecordInternal recordInternal = (StepsCadenceRecordInternal)new StepsCadenceRecordInternal(samples).setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        return recordInternal;
    }

    public static class StepsCadenceRecordSample {
        private final double mRate;
        private final Instant mTime;

        public StepsCadenceRecordSample(double rate, @NonNull Instant time) {
            this(rate, time, false);
        }

        public StepsCadenceRecordSample(double rate, @NonNull Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(rate, 0.0, 10000.0, "rate");
            }
            this.mTime = time;
            this.mRate = rate;
        }

        public double getRate() {
            return this.mRate;
        }

        @NonNull
        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof StepsCadenceRecordSample) {
                StepsCadenceRecordSample other = (StepsCadenceRecordSample)object;
                return this.getRate() == other.getRate() && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getRate(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<StepsCadenceRecordSample> mSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull List<StepsCadenceRecordSample> samples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(samples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            if (Flags.sampleTimeOrdering()) {
                TreeSet<StepsCadenceRecordSample> sampleSet = new TreeSet<StepsCadenceRecordSample>(Comparator.comparing(StepsCadenceRecordSample::getTime));
                sampleSet.addAll(samples);
                this.mSamples = sampleSet.stream().toList();
            } else {
                this.mSamples = samples;
            }
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public StepsCadenceRecord buildWithoutValidation() {
            return new StepsCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, true);
        }

        @NonNull
        public StepsCadenceRecord build() {
            return new StepsCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, false);
        }
    }
}

