/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Velocity;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.SpeedRecordInternal;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

@Identifier(recordIdentifier=14)
public class SpeedRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Velocity> SPEED_AVG = new AggregationType<Velocity>(78, 2, 14, Velocity.class);
    @NonNull
    public static final AggregationType<Velocity> SPEED_MIN = new AggregationType<Velocity>(79, 1, 14, Velocity.class);
    @NonNull
    public static final AggregationType<Velocity> SPEED_MAX = new AggregationType<Velocity>(80, 0, 14, Velocity.class);
    private final List<SpeedRecordSample> mSamples;

    private SpeedRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @NonNull List<SpeedRecordSample> samples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        Objects.requireNonNull(samples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, samples.stream().map(SpeedRecordSample::getTime).toList());
        }
        this.mSamples = samples;
    }

    @NonNull
    public List<SpeedRecordSample> getSamples() {
        return this.mSamples;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (super.equals(object) && object instanceof SpeedRecord) {
            SpeedRecord other = (SpeedRecord)object;
            return Objects.equals(this.getSamples(), other.getSamples());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public SpeedRecordInternal toRecordInternal() {
        HashSet<SpeedRecordInternal.SpeedRecordSample> samples = new HashSet<SpeedRecordInternal.SpeedRecordSample>(this.getSamples().size());
        for (SpeedRecordSample speedRecordSample : this.getSamples()) {
            samples.add(new SpeedRecordInternal.SpeedRecordSample(speedRecordSample.getSpeed().getInMetersPerSecond(), speedRecordSample.getTime().toEpochMilli()));
        }
        SpeedRecordInternal recordInternal = (SpeedRecordInternal)new SpeedRecordInternal(samples).setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        return recordInternal;
    }

    public static class SpeedRecordSample {
        private final Velocity mSpeed;
        private final Instant mTime;

        public SpeedRecordSample(@NonNull Velocity speed, @NonNull Instant time) {
            this(speed, time, false);
        }

        public SpeedRecordSample(@NonNull Velocity speed, @NonNull Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            Objects.requireNonNull(speed);
            if (!skipValidation) {
                ValidationUtils.requireInRange(speed.getInMetersPerSecond(), 0.0, 1000000.0, "speed");
            }
            this.mTime = time;
            this.mSpeed = speed;
        }

        @NonNull
        public Velocity getSpeed() {
            return this.mSpeed;
        }

        @NonNull
        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof SpeedRecordSample) {
                SpeedRecordSample other = (SpeedRecordSample)object;
                return this.getSpeed().equals(other.getSpeed()) && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getSpeed(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<SpeedRecordSample> mSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, @NonNull List<SpeedRecordSample> samples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(samples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            if (Flags.sampleTimeOrdering()) {
                TreeSet<SpeedRecordSample> sampleSet = new TreeSet<SpeedRecordSample>(Comparator.comparing(SpeedRecordSample::getTime));
                sampleSet.addAll(samples);
                this.mSamples = sampleSet.stream().toList();
            } else {
                this.mSamples = samples;
            }
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public SpeedRecord buildWithoutValidation() {
            return new SpeedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, true);
        }

        @NonNull
        public SpeedRecord build() {
            return new SpeedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSamples, false);
        }
    }
}

