/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.Record;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

public abstract class IntervalRecord
extends Record {
    private final Instant mStartTime;
    private final ZoneOffset mStartZoneOffset;
    private final Instant mEndTime;
    private final ZoneOffset mEndZoneOffset;

    IntervalRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, boolean skipValidation, boolean enforceFutureTimeRestrictions) {
        super(metadata);
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(startZoneOffset);
        Objects.requireNonNull(endTime);
        Objects.requireNonNull(endZoneOffset);
        if (!skipValidation && startTime.isAfter(Instant.now()) && enforceFutureTimeRestrictions) {
            throw new IllegalArgumentException("Record start time must not be in the future, start time: " + startTime + " currentTime: " + Instant.now());
        }
        if (endTime.toEpochMilli() < startTime.toEpochMilli()) {
            throw new IllegalArgumentException("end time in millis needs to be after start time in millis. startTime instant: " + startTime + " endTime instant: " + endTime);
        }
        this.mStartTime = startTime;
        this.mStartZoneOffset = startZoneOffset;
        this.mEndTime = endTime;
        this.mEndZoneOffset = endZoneOffset;
    }

    @NonNull
    public Instant getStartTime() {
        return this.mStartTime;
    }

    @NonNull
    public ZoneOffset getStartZoneOffset() {
        return this.mStartZoneOffset;
    }

    @NonNull
    public Instant getEndTime() {
        return this.mEndTime;
    }

    @NonNull
    public ZoneOffset getEndZoneOffset() {
        return this.mEndZoneOffset;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (super.equals(object)) {
            if (!(object instanceof IntervalRecord)) {
                return false;
            }
            IntervalRecord other = (IntervalRecord)object;
            return this.getStartTime().toEpochMilli() == other.getStartTime().toEpochMilli() && this.getEndTime().toEpochMilli() == other.getEndTime().toEpochMilli() && ((Object)this.getStartZoneOffset()).equals(other.getStartZoneOffset()) && ((Object)this.getEndZoneOffset()).equals(other.getEndZoneOffset());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStartTime(), this.getStartZoneOffset(), this.getEndTime(), this.getEndZoneOffset());
    }
}

