/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.healthfitness.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class FhirResource
implements Parcelable {
    public static final int FHIR_RESOURCE_TYPE_IMMUNIZATION = 1;
    public static final int FHIR_RESOURCE_TYPE_ALLERGY_INTOLERANCE = 2;
    public static final int FHIR_RESOURCE_TYPE_OBSERVATION = 3;
    public static final int FHIR_RESOURCE_TYPE_CONDITION = 4;
    public static final int FHIR_RESOURCE_TYPE_PROCEDURE = 5;
    public static final int FHIR_RESOURCE_TYPE_MEDICATION = 6;
    public static final int FHIR_RESOURCE_TYPE_MEDICATION_REQUEST = 7;
    public static final int FHIR_RESOURCE_TYPE_MEDICATION_STATEMENT = 8;
    public static final int FHIR_RESOURCE_TYPE_PATIENT = 9;
    public static final int FHIR_RESOURCE_TYPE_PRACTITIONER = 10;
    public static final int FHIR_RESOURCE_TYPE_PRACTITIONER_ROLE = 11;
    public static final int FHIR_RESOURCE_TYPE_ENCOUNTER = 12;
    public static final int FHIR_RESOURCE_TYPE_LOCATION = 13;
    public static final int FHIR_RESOURCE_TYPE_ORGANIZATION = 14;
    public static final int FHIR_RESOURCE_TYPE_DEVICE = 15;
    private final int mType;
    @NonNull
    private final String mId;
    @NonNull
    private final String mData;
    @NonNull
    public static final Parcelable.Creator<FhirResource> CREATOR = new Parcelable.Creator<FhirResource>(){

        @Override
        public FhirResource createFromParcel(Parcel in) {
            return new FhirResource(in);
        }

        public FhirResource[] newArray(int size) {
            return new FhirResource[size];
        }
    };
    private static final Set<Integer> VALID_TYPES = Set.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

    private FhirResource(int type, @NonNull String id2, @NonNull String data) {
        FhirResource.validateFhirResourceType(type);
        Objects.requireNonNull(id2);
        Objects.requireNonNull(data);
        this.mType = type;
        this.mId = id2;
        this.mData = data;
    }

    private FhirResource(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mType = in.readInt();
        FhirResource.validateFhirResourceType(this.mType);
        this.mId = Objects.requireNonNull(in.readString());
        this.mData = Objects.requireNonNull(in.readString());
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public String getData() {
        return this.mData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.getType());
        dest.writeString(this.getId());
        dest.writeString(this.getData());
    }

    public static void validateFhirResourceType(int fhirResourceType) {
        if (!Flags.deviceResource() && fhirResourceType == 15) {
            throw new IllegalArgumentException("Unsupported FHIR Resource type Device");
        }
        ValidationUtils.validateIntDefValue(fhirResourceType, VALID_TYPES, FhirResourceType.class.getSimpleName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FhirResource)) {
            return false;
        }
        FhirResource that = (FhirResource)o;
        return this.getType() == that.getType() && this.getId().equals(that.getId()) && this.getData().equals(that.getData());
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getId(), this.getData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("type=").append(this.getType());
        sb.append(",id=").append(this.getId());
        sb.append(",data=").append(this.getData());
        sb.append("}");
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FhirResourceType {
    }

    public static class Builder {
        private int mType;
        @NonNull
        private String mId;
        @NonNull
        private String mData;

        public Builder(int type, @NonNull String id2, @NonNull String data) {
            FhirResource.validateFhirResourceType(type);
            Objects.requireNonNull(id2);
            Objects.requireNonNull(data);
            this.mType = type;
            this.mId = id2;
            this.mData = data;
        }

        public Builder(@NonNull Builder other) {
            Objects.requireNonNull(other);
            this.mType = other.mType;
            this.mId = other.mId;
            this.mData = other.mData;
        }

        public Builder(@NonNull FhirResource other) {
            Objects.requireNonNull(other);
            this.mType = other.getType();
            this.mId = other.getId();
            this.mData = other.getData();
        }

        @NonNull
        public Builder setType(int type) {
            FhirResource.validateFhirResourceType(type);
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setId(@NonNull String id2) {
            Objects.requireNonNull(id2);
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setData(@NonNull String data) {
            Objects.requireNonNull(data);
            this.mData = data;
            return this;
        }

        @NonNull
        public FhirResource build() {
            return new FhirResource(this.mType, this.mId, this.mData);
        }
    }
}

