/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.ExerciseLap;
import android.health.connect.datatypes.ExerciseRoute;
import android.health.connect.datatypes.ExerciseSegment;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ExerciseSessionTypesValidation;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ExerciseSessionRecordInternal;
import com.android.healthfitness.flags.Flags;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

@Identifier(recordIdentifier=37)
public class ExerciseSessionRecord
extends IntervalRecord {
    @NonNull
    public static final AggregationType<Long> EXERCISE_DURATION_TOTAL = new AggregationType<Long>(67, 3, 37, Long.class);
    private final int mExerciseType;
    private final CharSequence mNotes;
    private final CharSequence mTitle;
    private final ExerciseRoute mRoute;
    private final boolean mHasRoute;
    private final List<ExerciseSegment> mSegments;
    private final List<ExerciseLap> mLaps;
    private final String mPlannedExerciseSessionId;
    private final float mRateOfPerceivedExertion;

    private ExerciseSessionRecord(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull ZoneOffset startZoneOffset, @NonNull Instant endTime, @NonNull ZoneOffset endZoneOffset, @Nullable CharSequence notes, @NonNull int exerciseType, @Nullable CharSequence title, @Nullable ExerciseRoute route, boolean hasRoute, @NonNull List<ExerciseSegment> segments, @NonNull List<ExerciseLap> laps, @Nullable String plannedExerciseSessionId, float rateOfPerceivedExertion, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation, true);
        this.mNotes = notes;
        this.mExerciseType = exerciseType;
        this.mTitle = title;
        if (route != null && !hasRoute) {
            throw new IllegalArgumentException("HasRoute must be true if the route is not null");
        }
        this.mRoute = route;
        if (!skipValidation) {
            ExerciseSessionTypesValidation.validateExerciseRouteTimestamps(startTime, endTime, route);
        }
        this.mHasRoute = hasRoute;
        this.mSegments = Collections.unmodifiableList(ValidationUtils.sortAndValidateTimeIntervalHolders(startTime, endTime, segments));
        if (!skipValidation) {
            ExerciseSessionTypesValidation.validateSessionAndSegmentsTypes(exerciseType, this.mSegments);
        }
        this.mLaps = Collections.unmodifiableList(ValidationUtils.sortAndValidateTimeIntervalHolders(startTime, endTime, laps));
        this.mPlannedExerciseSessionId = plannedExerciseSessionId;
        this.mRateOfPerceivedExertion = rateOfPerceivedExertion;
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    @Nullable
    public CharSequence getNotes() {
        return this.mNotes;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public ExerciseRoute getRoute() {
        return this.mRoute;
    }

    @NonNull
    public List<ExerciseSegment> getSegments() {
        return this.mSegments;
    }

    @NonNull
    public List<ExerciseLap> getLaps() {
        return this.mLaps;
    }

    @NonNull
    public boolean hasRoute() {
        return this.mHasRoute;
    }

    @Nullable
    @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
    public String getPlannedExerciseSessionId() {
        return this.mPlannedExerciseSessionId;
    }

    @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
    public float getRateOfPerceivedExertion() {
        if (this.mRateOfPerceivedExertion == Float.MIN_VALUE) {
            throw new IllegalStateException("Rate of perceived exertion is not set. Use `hasRateOfPerceivedExertion` to check whether RPE exists for this session.");
        }
        return this.mRateOfPerceivedExertion;
    }

    @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
    public boolean hasRateOfPerceivedExertion() {
        return this.mRateOfPerceivedExertion != Float.MIN_VALUE;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseSessionRecord)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExerciseSessionRecord that = (ExerciseSessionRecord)o;
        return this.getExerciseType() == that.getExerciseType() && RecordUtils.isEqualNullableCharSequences(this.getNotes(), that.getNotes()) && RecordUtils.isEqualNullableCharSequences(this.getTitle(), that.getTitle()) && Objects.equals(this.getRoute(), that.getRoute()) && Objects.equals(this.getSegments(), that.getSegments()) && Objects.equals(this.getPlannedExerciseSessionId(), that.getPlannedExerciseSessionId()) && Objects.equals(this.getLaps(), that.getLaps()) && this.mRateOfPerceivedExertion == that.mRateOfPerceivedExertion;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExerciseType(), this.getNotes(), this.getTitle(), this.getRoute(), this.getSegments(), this.getPlannedExerciseSessionId(), this.getLaps(), Float.valueOf(this.mRateOfPerceivedExertion));
    }

    public ExerciseSessionRecordInternal toRecordInternal() {
        ExerciseSessionRecordInternal recordInternal = (ExerciseSessionRecordInternal)new ExerciseSessionRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTimeInterval(this);
        if (this.getNotes() != null) {
            recordInternal.setNotes(this.getNotes().toString());
        }
        if (this.getTitle() != null) {
            recordInternal.setTitle(this.getTitle().toString());
        }
        recordInternal.setHasRoute(this.hasRoute());
        if (this.getRoute() != null) {
            recordInternal.setRoute(this.getRoute().toRouteInternal());
        }
        if (this.getLaps() != null && !this.getLaps().isEmpty()) {
            recordInternal.setExerciseLaps(this.getLaps().stream().map(ExerciseLap::toExerciseLapInternal).collect(Collectors.toList()));
        }
        if (this.getSegments() != null && !this.getSegments().isEmpty()) {
            recordInternal.setExerciseSegments(this.getSegments().stream().map(ExerciseSegment::toSegmentInternal).collect(Collectors.toList()));
        }
        recordInternal.setExerciseType(this.mExerciseType);
        if (this.mPlannedExerciseSessionId != null) {
            recordInternal.setPlannedExerciseSessionId(UUID.fromString(this.mPlannedExerciseSessionId));
        }
        if (Flags.exerciseSegmentImprovements() && this.hasRateOfPerceivedExertion()) {
            recordInternal.setRateOfPerceivedExertion(this.getRateOfPerceivedExertion());
        }
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private final int mExerciseType;
        @Nullable
        private CharSequence mNotes;
        @Nullable
        private CharSequence mTitle;
        @Nullable
        private ExerciseRoute mRoute;
        private final List<ExerciseSegment> mSegments;
        private final List<ExerciseLap> mLaps;
        private boolean mHasRoute;
        @Nullable
        private String mPlannedExerciseSessionId;
        private float mRateOfPerceivedExertion = Float.MIN_VALUE;

        public Builder(@NonNull Metadata metadata, @NonNull Instant startTime, @NonNull Instant endTime, int exerciseType) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mExerciseType = exerciseType;
            this.mSegments = new ArrayList<ExerciseSegment>();
            this.mLaps = new ArrayList<ExerciseLap>();
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        @NonNull
        public Builder setStartZoneOffset(@NonNull ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        @NonNull
        public Builder setEndZoneOffset(@NonNull ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        @NonNull
        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public Builder setNotes(@Nullable CharSequence notes) {
            this.mNotes = notes;
            return this;
        }

        @NonNull
        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        @NonNull
        public Builder setRoute(@Nullable ExerciseRoute route) {
            this.mRoute = route;
            this.mHasRoute = route != null;
            return this;
        }

        @NonNull
        public Builder setLaps(@NonNull List<ExerciseLap> laps) {
            Objects.requireNonNull(laps);
            this.mLaps.clear();
            this.mLaps.addAll(laps);
            return this;
        }

        @NonNull
        public Builder setSegments(@NonNull List<ExerciseSegment> segments) {
            Objects.requireNonNull(segments);
            this.mSegments.clear();
            this.mSegments.addAll(segments);
            return this;
        }

        @NonNull
        public Builder setHasRoute(boolean hasRoute) {
            this.mHasRoute = hasRoute;
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.healthconnect.flags.training_plans")
        public Builder setPlannedExerciseSessionId(@Nullable String id2) {
            this.mPlannedExerciseSessionId = id2;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder setRateOfPerceivedExertion(float rateOfPerceivedExertion) {
            if (rateOfPerceivedExertion < 0.0f || rateOfPerceivedExertion > 10.0f) {
                throw new IllegalArgumentException("Rate of perceived exertion must be in the range 0 to 10 inclusive");
            }
            this.mRateOfPerceivedExertion = rateOfPerceivedExertion;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder clearRateOfPerceivedExertion() {
            this.mRateOfPerceivedExertion = Float.MIN_VALUE;
            return this;
        }

        @NonNull
        public ExerciseSessionRecord buildWithoutValidation() {
            return new ExerciseSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mNotes, this.mExerciseType, this.mTitle, this.mRoute, this.mHasRoute, this.mSegments, this.mLaps, this.mPlannedExerciseSessionId, this.mRateOfPerceivedExertion, true);
        }

        @NonNull
        public ExerciseSessionRecord build() {
            return new ExerciseSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mNotes, this.mExerciseType, this.mTitle, this.mRoute, this.mHasRoute, this.mSegments, this.mLaps, this.mPlannedExerciseSessionId, this.mRateOfPerceivedExertion, false);
        }
    }
}

