/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.TimeInterval;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ExerciseSegmentInternal;
import com.android.healthfitness.flags.AconfigFlagHelper;
import java.time.Instant;
import java.util.Objects;

public class ExerciseSegment
implements TimeInterval.TimeIntervalHolder {
    private final TimeInterval mInterval;
    private final int mSegmentType;
    private final int mRepetitionsCount;
    @Nullable
    private final Mass mWeight;
    private final int mSetIndex;
    private final float mRateOfPerceivedExertion;

    private ExerciseSegment(@NonNull TimeInterval interval, int segmentType, int repetitionsCount, @Nullable Mass weight, int setIndex, float rateOfPerceivedExertion, boolean skipValidation) {
        Objects.requireNonNull(interval);
        this.mInterval = interval;
        this.mSegmentType = segmentType;
        if (!skipValidation) {
            ValidationUtils.requireNonNegative(repetitionsCount, "repetitionsCount");
        }
        this.mRepetitionsCount = repetitionsCount;
        this.mWeight = weight;
        this.mSetIndex = setIndex;
        this.mRateOfPerceivedExertion = rateOfPerceivedExertion;
    }

    public int getSegmentType() {
        return this.mSegmentType;
    }

    public int getRepetitionsCount() {
        return this.mRepetitionsCount;
    }

    @Nullable
    @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
    public Mass getWeight() {
        return this.mWeight;
    }

    @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
    public int getSetIndex() {
        if (this.mSetIndex == -1) {
            throw new IllegalStateException("Set index is not set. Use `hasSetIndex` to check whether set index exists for this segment.");
        }
        return this.mSetIndex;
    }

    @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
    public boolean hasSetIndex() {
        return this.mSetIndex != -1;
    }

    @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
    public float getRateOfPerceivedExertion() {
        if (this.mRateOfPerceivedExertion == Float.MIN_VALUE) {
            throw new IllegalStateException("Rate of perceived exertion is not set. Use `hasRateOfPerceivedExertion` to check whether RPE exists for this segment.");
        }
        return this.mRateOfPerceivedExertion;
    }

    @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
    public boolean hasRateOfPerceivedExertion() {
        return this.mRateOfPerceivedExertion != Float.MIN_VALUE;
    }

    @NonNull
    public Instant getStartTime() {
        return this.mInterval.getStartTime();
    }

    @NonNull
    public Instant getEndTime() {
        return this.mInterval.getEndTime();
    }

    @Override
    public TimeInterval getInterval() {
        return this.mInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseSegment)) {
            return false;
        }
        ExerciseSegment that = (ExerciseSegment)o;
        return this.mSegmentType == that.mSegmentType && this.mRepetitionsCount == that.mRepetitionsCount && Objects.equals(this.mWeight, that.mWeight) && this.mSetIndex == that.mSetIndex && this.mRateOfPerceivedExertion == that.mRateOfPerceivedExertion && Objects.equals(this.mInterval, that.mInterval);
    }

    public int hashCode() {
        return Objects.hash(this.mSegmentType, this.mRepetitionsCount, this.mWeight, this.mSetIndex, Float.valueOf(this.mRateOfPerceivedExertion), this.mInterval);
    }

    public ExerciseSegmentInternal toSegmentInternal() {
        ExerciseSegmentInternal segment = new ExerciseSegmentInternal().setStartTime(this.getStartTime().toEpochMilli()).setEndTime(this.getEndTime().toEpochMilli()).setSegmentType(this.getSegmentType()).setRepetitionsCount(this.getRepetitionsCount());
        if (AconfigFlagHelper.isExerciseSegmentImprovementsEnabled()) {
            if (this.getWeight() != null) {
                segment.setWeightGrams(this.getWeight().getInGrams());
            }
            if (this.hasSetIndex()) {
                segment.setSetIndex(this.getSetIndex());
            }
            if (this.hasRateOfPerceivedExertion()) {
                segment.setRateOfPerceivedExertion(this.getRateOfPerceivedExertion());
            }
        }
        return segment;
    }

    public static class Builder {
        private final TimeInterval mInterval;
        private final int mSegmentType;
        private int mRepetitionsCount = 0;
        @Nullable
        private Mass mWeight;
        private int mSetIndex = -1;
        private float mRateOfPerceivedExertion = Float.MIN_VALUE;

        public Builder(@NonNull Instant startTime, @NonNull Instant endTime, int segmentType) {
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mInterval = new TimeInterval(startTime, endTime);
            this.mSegmentType = segmentType;
        }

        @NonNull
        public Builder setRepetitionsCount(int repetitionsCount) {
            if (repetitionsCount < 0) {
                throw new IllegalArgumentException("Number of repetitions must be non negative.");
            }
            this.mRepetitionsCount = repetitionsCount;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder setWeight(@NonNull Mass weight) {
            if (weight.getInGrams() < 0.0) {
                throw new IllegalArgumentException("Weight must be non negative.");
            }
            if (weight.getInGrams() > 2500000.0) {
                throw new IllegalArgumentException("Weight must not exceed 2500kg.");
            }
            this.mWeight = weight;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder clearWeight() {
            this.mWeight = null;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder setSetIndex(int setIndex) {
            if (setIndex < 0) {
                throw new IllegalArgumentException("Set index must be non-negative");
            }
            this.mSetIndex = setIndex;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder clearSetIndex() {
            this.mSetIndex = -1;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder setRateOfPerceivedExertion(float rateOfPerceivedExertion) {
            if (rateOfPerceivedExertion < 0.0f || rateOfPerceivedExertion > 10.0f) {
                throw new IllegalArgumentException("Rate of perceived exertion must be in the range 0 to 10 inclusive");
            }
            this.mRateOfPerceivedExertion = rateOfPerceivedExertion;
            return this;
        }

        @FlaggedApi(value="com.android.healthfitness.flags.exercise_segment_improvements")
        @NonNull
        public Builder clearRateOfPerceivedExertion() {
            this.mRateOfPerceivedExertion = Float.MIN_VALUE;
            return this;
        }

        @NonNull
        public ExerciseSegment buildWithoutValidation() {
            return new ExerciseSegment(this.mInterval, this.mSegmentType, this.mRepetitionsCount, this.mWeight, this.mSetIndex, this.mRateOfPerceivedExertion, true);
        }

        @NonNull
        public ExerciseSegment build() {
            return new ExerciseSegment(this.mInterval, this.mSegmentType, this.mRepetitionsCount, this.mWeight, this.mSetIndex, this.mRateOfPerceivedExertion, false);
        }
    }
}

