/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Pressure;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BloodPressureRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=23)
public class BloodPressureRecord
extends InstantRecord {
    private static final double SYSTOLIC_MIN_VALUE = 20.0;
    private static final double SYSTOLIC_MAX_VALUE = 300.0;
    private static final double DIASTOLIC_MIN_VALUE = 10.0;
    private static final double DIASTOLIC_MAX_VALUE = 300.0;
    @NonNull
    public static final AggregationType<Pressure> DIASTOLIC_AVG = new AggregationType<Pressure>(68, 2, 23, Pressure.class);
    @NonNull
    public static final AggregationType<Pressure> DIASTOLIC_MAX = new AggregationType<Pressure>(69, 0, 23, Pressure.class);
    @NonNull
    public static final AggregationType<Pressure> DIASTOLIC_MIN = new AggregationType<Pressure>(70, 1, 23, Pressure.class);
    @NonNull
    public static final AggregationType<Pressure> SYSTOLIC_AVG = new AggregationType<Pressure>(71, 2, 23, Pressure.class);
    @NonNull
    public static final AggregationType<Pressure> SYSTOLIC_MAX = new AggregationType<Pressure>(72, 0, 23, Pressure.class);
    @NonNull
    public static final AggregationType<Pressure> SYSTOLIC_MIN = new AggregationType<Pressure>(73, 1, 23, Pressure.class);
    private final int mMeasurementLocation;
    private final Pressure mSystolic;
    private final Pressure mDiastolic;
    private final int mBodyPosition;

    private BloodPressureRecord(@NonNull Metadata metadata, @NonNull Instant time, @NonNull ZoneOffset zoneOffset, int measurementLocation, @NonNull Pressure systolic, @NonNull Pressure diastolic, int bodyPosition, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(systolic);
        Objects.requireNonNull(diastolic);
        ValidationUtils.validateIntDefValue(measurementLocation, BloodPressureMeasurementLocation.VALID_TYPES, BloodPressureMeasurementLocation.class.getSimpleName());
        if (!skipValidation) {
            ValidationUtils.requireInRange(systolic.getInMillimetersOfMercury(), 20.0, 300.0, "systolic");
            ValidationUtils.requireInRange(diastolic.getInMillimetersOfMercury(), 10.0, 300.0, "diastolic");
        }
        ValidationUtils.validateIntDefValue(bodyPosition, BodyPosition.VALID_TYPES, BodyPosition.class.getSimpleName());
        this.mMeasurementLocation = measurementLocation;
        this.mSystolic = systolic;
        this.mDiastolic = diastolic;
        this.mBodyPosition = bodyPosition;
    }

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    @NonNull
    public Pressure getSystolic() {
        return this.mSystolic;
    }

    @NonNull
    public Pressure getDiastolic() {
        return this.mDiastolic;
    }

    public int getBodyPosition() {
        return this.mBodyPosition;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof BloodPressureRecord)) {
            return false;
        }
        BloodPressureRecord that = (BloodPressureRecord)o;
        return this.getMeasurementLocation() == that.getMeasurementLocation() && this.getBodyPosition() == that.getBodyPosition() && this.getSystolic().equals(that.getSystolic()) && this.getDiastolic().equals(that.getDiastolic());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeasurementLocation(), this.getSystolic(), this.getDiastolic(), this.getBodyPosition());
    }

    public BloodPressureRecordInternal toRecordInternal() {
        BloodPressureRecordInternal recordInternal = (BloodPressureRecordInternal)new BloodPressureRecordInternal().setMetaData(this.getMetadata());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setMeasurementLocation(this.mMeasurementLocation);
        recordInternal.setSystolic(this.mSystolic.getInMillimetersOfMercury());
        recordInternal.setDiastolic(this.mDiastolic.getInMillimetersOfMercury());
        recordInternal.setBodyPosition(this.mBodyPosition);
        return recordInternal;
    }

    public static class BloodPressureMeasurementLocation {
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_UNKNOWN = 0;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_WRIST = 1;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_WRIST = 2;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_UPPER_ARM = 3;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_UPPER_ARM = 4;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));

        private BloodPressureMeasurementLocation() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BloodPressureMeasurementLocations {
        }
    }

    public static class BodyPosition {
        public static final int BODY_POSITION_UNKNOWN = 0;
        public static final int BODY_POSITION_STANDING_UP = 1;
        public static final int BODY_POSITION_SITTING_DOWN = 2;
        public static final int BODY_POSITION_LYING_DOWN = 3;
        public static final int BODY_POSITION_RECLINING = 4;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));

        private BodyPosition() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BodyPositionType {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mMeasurementLocation;
        private final Pressure mSystolic;
        private final Pressure mDiastolic;
        private final int mBodyPosition;

        public Builder(@NonNull Metadata metadata, @NonNull Instant time, int measurementLocation, @NonNull Pressure systolic, @NonNull Pressure diastolic, int bodyPosition) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(systolic);
            Objects.requireNonNull(diastolic);
            ValidationUtils.validateIntDefValue(measurementLocation, BloodPressureMeasurementLocation.VALID_TYPES, BloodPressureMeasurementLocation.class.getSimpleName());
            this.mMetadata = metadata;
            this.mTime = time;
            this.mMeasurementLocation = measurementLocation;
            this.mSystolic = systolic;
            this.mDiastolic = diastolic;
            this.mBodyPosition = bodyPosition;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        @NonNull
        public Builder setZoneOffset(@NonNull ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        @NonNull
        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        @NonNull
        public BloodPressureRecord buildWithoutValidation() {
            return new BloodPressureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mSystolic, this.mDiastolic, this.mBodyPosition, true);
        }

        @NonNull
        public BloodPressureRecord build() {
            return new BloodPressureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mSystolic, this.mDiastolic, this.mBodyPosition, false);
        }
    }
}

