/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.MedicalResourceId;
import android.health.connect.changelog.ChangeLogsResponse;
import android.health.connect.internal.ParcelUtils;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

@FlaggedApi(value="com.android.healthfitness.flags.phr_change_logs")
public class DeletedMedicalResourcesParcel
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<DeletedMedicalResourcesParcel> CREATOR = new Parcelable.Creator<DeletedMedicalResourcesParcel>(){

        @Override
        public DeletedMedicalResourcesParcel createFromParcel(Parcel in) {
            return new DeletedMedicalResourcesParcel(in);
        }

        public DeletedMedicalResourcesParcel[] newArray(int size) {
            return new DeletedMedicalResourcesParcel[size];
        }
    };
    private final List<ChangeLogsResponse.DeletedMedicalResource> mDeletedMedicalResources;

    public DeletedMedicalResourcesParcel(@NonNull List<ChangeLogsResponse.DeletedMedicalResource> deletedMedicalResources) {
        this.mDeletedMedicalResources = deletedMedicalResources;
    }

    private DeletedMedicalResourcesParcel(@NonNull Parcel in) {
        in = ParcelUtils.getParcelForSharedMemoryIfRequired(in);
        int size = in.readInt();
        this.mDeletedMedicalResources = new ArrayList<ChangeLogsResponse.DeletedMedicalResource>(size);
        for (int i = 0; i < size; ++i) {
            MedicalResourceId id2 = in.readParcelable(MedicalResourceId.class.getClassLoader(), MedicalResourceId.class);
            long time = in.readLong();
            this.mDeletedMedicalResources.add(new ChangeLogsResponse.DeletedMedicalResource(id2, Instant.ofEpochMilli(time)));
        }
    }

    @NonNull
    public List<ChangeLogsResponse.DeletedMedicalResource> getDeletedMedicalResources() {
        return this.mDeletedMedicalResources;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        ParcelUtils.putToRequiredMemory(dest, flags, this::writeToParcelInternal);
    }

    private void writeToParcelInternal(@NonNull Parcel dest) {
        dest.writeInt(this.mDeletedMedicalResources.size());
        for (ChangeLogsResponse.DeletedMedicalResource deletedMedicalResource : this.mDeletedMedicalResources) {
            dest.writeParcelable(deletedMedicalResource.getDeletedMedicalResourceId(), 0);
            dest.writeLong(deletedMedicalResource.getDeletedTime().toEpochMilli());
        }
    }
}

