/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.datatypes.FhirVersion;
import android.health.connect.datatypes.MedicalDataSource;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;
import java.util.Set;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class UpsertMedicalResourceRequest
implements Parcelable {
    @NonNull
    private final String mDataSourceId;
    @NonNull
    private final FhirVersion mFhirVersion;
    @NonNull
    private final String mData;
    private int mDataSize;
    @NonNull
    public static final Parcelable.Creator<UpsertMedicalResourceRequest> CREATOR = new Parcelable.Creator<UpsertMedicalResourceRequest>(){

        @Override
        public UpsertMedicalResourceRequest createFromParcel(Parcel in) {
            return new UpsertMedicalResourceRequest(in);
        }

        public UpsertMedicalResourceRequest[] newArray(int size) {
            return new UpsertMedicalResourceRequest[size];
        }
    };

    private UpsertMedicalResourceRequest(@NonNull String dataSourceId, @NonNull FhirVersion fhirVersion, @NonNull String data) {
        Objects.requireNonNull(dataSourceId);
        Objects.requireNonNull(fhirVersion);
        Objects.requireNonNull(data);
        MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
        this.mDataSourceId = dataSourceId;
        this.mFhirVersion = fhirVersion;
        this.mData = data;
    }

    private UpsertMedicalResourceRequest(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        int dataAvailStartPosition = in.dataAvail();
        this.mDataSourceId = Objects.requireNonNull(in.readString());
        MedicalDataSource.validateMedicalDataSourceIds(Set.of(this.mDataSourceId));
        this.mFhirVersion = Objects.requireNonNull(in.readParcelable(FhirVersion.class.getClassLoader(), FhirVersion.class));
        this.mData = Objects.requireNonNull(in.readString());
        this.mDataSize = dataAvailStartPosition - in.dataAvail();
    }

    @NonNull
    public String getDataSourceId() {
        return this.mDataSourceId;
    }

    @NonNull
    public FhirVersion getFhirVersion() {
        return this.mFhirVersion;
    }

    @NonNull
    public String getData() {
        return this.mData;
    }

    public long getDataSize() {
        return this.mDataSize;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeString(this.mDataSourceId);
        dest.writeParcelable(this.mFhirVersion, 0);
        dest.writeString(this.mData);
    }

    public int hashCode() {
        return Objects.hash(this.getDataSourceId(), this.getFhirVersion(), this.getData());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpsertMedicalResourceRequest)) {
            return false;
        }
        UpsertMedicalResourceRequest that = (UpsertMedicalResourceRequest)o;
        return this.getDataSourceId().equals(that.getDataSourceId()) && this.getFhirVersion().equals(that.getFhirVersion()) && this.getData().equals(that.getData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append("dataSourceId=").append(this.mDataSourceId);
        sb.append(",fhirVersion=").append(this.mFhirVersion);
        sb.append(",data=").append(this.mData);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private String mDataSourceId;
        private FhirVersion mFhirVersion;
        private String mData;

        public Builder(@NonNull String dataSourceId, @NonNull FhirVersion fhirVersion, @NonNull String data) {
            Objects.requireNonNull(dataSourceId);
            Objects.requireNonNull(fhirVersion);
            Objects.requireNonNull(data);
            MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
            this.mDataSourceId = dataSourceId;
            this.mFhirVersion = fhirVersion;
            this.mData = data;
        }

        public Builder(@NonNull Builder other) {
            Objects.requireNonNull(other);
            this.mDataSourceId = other.mDataSourceId;
            this.mFhirVersion = other.mFhirVersion;
            this.mData = other.mData;
        }

        public Builder(@NonNull UpsertMedicalResourceRequest other) {
            Objects.requireNonNull(other);
            this.mDataSourceId = other.getDataSourceId();
            this.mFhirVersion = other.getFhirVersion();
            this.mData = other.getData();
        }

        @NonNull
        public Builder setDataSourceId(@NonNull String dataSourceId) {
            Objects.requireNonNull(dataSourceId);
            MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
            this.mDataSourceId = dataSourceId;
            return this;
        }

        @NonNull
        public Builder setFhirVersion(@NonNull FhirVersion fhirVersion) {
            Objects.requireNonNull(fhirVersion);
            this.mFhirVersion = fhirVersion;
            return this;
        }

        @NonNull
        public Builder setData(@NonNull String data) {
            Objects.requireNonNull(data);
            this.mData = data;
            return this;
        }

        @NonNull
        public UpsertMedicalResourceRequest build() {
            return new UpsertMedicalResourceRequest(this.mDataSourceId, this.mFhirVersion, this.mData);
        }
    }
}

