/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.health.connect.ReadMedicalResourcesRequest;
import android.health.connect.aidl.ReadMedicalResourcesRequestParcel;
import android.health.connect.datatypes.MedicalDataSource;
import android.health.connect.datatypes.MedicalResource;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.util.ArraySet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@FlaggedApi(value="com.android.healthfitness.flags.personal_health_record")
public class ReadMedicalResourcesInitialRequest
extends ReadMedicalResourcesRequest {
    private final int mMedicalResourceType;
    @NonNull
    private final Set<String> mDataSourceIds;

    private ReadMedicalResourcesInitialRequest(int medicalResourceType, @NonNull Set<String> dataSourceIds, int pageSize) {
        super(pageSize);
        MedicalResource.validateMedicalResourceType(medicalResourceType);
        Objects.requireNonNull(dataSourceIds);
        MedicalDataSource.validateMedicalDataSourceIds(dataSourceIds);
        this.mMedicalResourceType = medicalResourceType;
        this.mDataSourceIds = dataSourceIds;
    }

    public int getMedicalResourceType() {
        return this.mMedicalResourceType;
    }

    @NonNull
    public Set<String> getDataSourceIds() {
        return new ArraySet<String>(this.mDataSourceIds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadMedicalResourcesInitialRequest)) {
            return false;
        }
        ReadMedicalResourcesInitialRequest that = (ReadMedicalResourcesInitialRequest)o;
        return this.getMedicalResourceType() == that.getMedicalResourceType() && this.getDataSourceIds().equals(that.getDataSourceIds()) && this.getPageSize() == that.getPageSize();
    }

    public int hashCode() {
        return Objects.hash(this.getMedicalResourceType(), this.getDataSourceIds(), this.getPageSize());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{medicalResourceType=" + this.getMedicalResourceType() + ",dataSourceIds=" + this.getDataSourceIds() + ",pageSize=" + this.getPageSize() + "}";
    }

    @Override
    public ReadMedicalResourcesRequestParcel toParcel() {
        return new ReadMedicalResourcesRequestParcel(this);
    }

    public static class Builder {
        private int mMedicalResourceType;
        @NonNull
        private Set<String> mDataSourceIds = new HashSet<String>();
        private int mPageSize = 1000;

        public Builder(int medicalResourceType) {
            MedicalResource.validateMedicalResourceType(medicalResourceType);
            this.mMedicalResourceType = medicalResourceType;
        }

        public Builder(@NonNull Builder other) {
            this.mMedicalResourceType = other.mMedicalResourceType;
            this.mDataSourceIds.addAll(other.mDataSourceIds);
            this.mPageSize = other.mPageSize;
        }

        public Builder(@NonNull ReadMedicalResourcesInitialRequest other) {
            this.mMedicalResourceType = other.getMedicalResourceType();
            this.mDataSourceIds.addAll(other.getDataSourceIds());
            this.mPageSize = other.getPageSize();
        }

        @NonNull
        public Builder setMedicalResourceType(int medicalResourceType) {
            MedicalResource.validateMedicalResourceType(medicalResourceType);
            this.mMedicalResourceType = medicalResourceType;
            return this;
        }

        @NonNull
        public Builder addDataSourceId(@NonNull String dataSourceId) {
            Objects.requireNonNull(dataSourceId);
            MedicalDataSource.validateMedicalDataSourceIds(Set.of(dataSourceId));
            this.mDataSourceIds.add(dataSourceId);
            return this;
        }

        @NonNull
        public Builder addDataSourceIds(@NonNull Set<String> dataSourceIds) {
            Objects.requireNonNull(dataSourceIds);
            MedicalDataSource.validateMedicalDataSourceIds(dataSourceIds);
            this.mDataSourceIds.addAll(dataSourceIds);
            return this;
        }

        @NonNull
        public Builder clearDataSourceIds() {
            this.mDataSourceIds.clear();
            return this;
        }

        @NonNull
        public Builder setPageSize(int pageSize) {
            ValidationUtils.requireInRange(pageSize, 1, 5000, "pageSize");
            this.mPageSize = pageSize;
            return this;
        }

        @NonNull
        public ReadMedicalResourcesInitialRequest build() {
            return new ReadMedicalResourcesInitialRequest(this.mMedicalResourceType, this.mDataSourceIds, this.mPageSize);
        }
    }
}

