/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.NonNull;
import android.health.connect.TimeRangeFilter;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.DataOrigin;
import android.util.ArraySet;
import java.util.Objects;
import java.util.Set;

public class AggregateRecordsRequest<T> {
    private final TimeRangeFilter mTimeRangeFilter;
    private final Set<AggregationType<T>> mAggregationTypes;
    private final Set<DataOrigin> mDataOriginsFilter;

    private AggregateRecordsRequest(@NonNull Set<AggregationType<T>> aggregationTypes, @NonNull TimeRangeFilter timeRangeFilter, @NonNull Set<DataOrigin> dataOriginsFilter) {
        Objects.requireNonNull(timeRangeFilter);
        Objects.requireNonNull(aggregationTypes);
        Objects.requireNonNull(dataOriginsFilter);
        this.mTimeRangeFilter = timeRangeFilter;
        this.mAggregationTypes = aggregationTypes;
        this.mDataOriginsFilter = dataOriginsFilter;
    }

    @NonNull
    public TimeRangeFilter getTimeRangeFilter() {
        return this.mTimeRangeFilter;
    }

    @NonNull
    public Set<AggregationType<T>> getAggregationTypes() {
        return this.mAggregationTypes;
    }

    @NonNull
    public Set<DataOrigin> getDataOriginsFilters() {
        return this.mDataOriginsFilter;
    }

    public static class Builder<T> {
        private final TimeRangeFilter mTimeRangeFilter;
        private final Set<AggregationType<T>> mAggregationTypes = new ArraySet<AggregationType<T>>();
        private final Set<DataOrigin> mDataOriginsFilter = new ArraySet<DataOrigin>();

        public Builder(@NonNull TimeRangeFilter timeRangeFilter) {
            Objects.requireNonNull(timeRangeFilter);
            this.mTimeRangeFilter = timeRangeFilter;
        }

        @NonNull
        public Builder<T> addAggregationType(@NonNull AggregationType<T> aggregationType) {
            this.mAggregationTypes.add(aggregationType);
            return this;
        }

        @NonNull
        public Builder<T> addDataOriginsFilter(@NonNull DataOrigin dataOriginsFilter) {
            Objects.requireNonNull(dataOriginsFilter);
            this.mDataOriginsFilter.add(dataOriginsFilter);
            return this;
        }

        @NonNull
        public AggregateRecordsRequest<T> build() {
            if (this.mAggregationTypes.isEmpty()) {
                throw new IllegalArgumentException("At least one of the aggregation types must be set");
            }
            return new AggregateRecordsRequest<T>(this.mAggregationTypes, this.mTimeRangeFilter, this.mDataOriginsFilter);
        }
    }
}

