/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.IUsbOperationInternal;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class UsbOperationInternal
extends IUsbOperationInternal.Stub {
    private static final String TAG = "UsbPortStatus";
    private final int mOperationID;
    private final String mId;
    private boolean mOperationComplete;
    private boolean mAsynchronous = false;
    private Executor mExecutor;
    private Consumer<Integer> mConsumer;
    private int mResult = 0;
    private int mStatus;
    final ReentrantLock mLock = new ReentrantLock();
    final Condition mOperationWait = this.mLock.newCondition();
    private static final int USB_OPERATION_TIMEOUT_MSECS = 5000;
    public static final int USB_OPERATION_SUCCESS = 0;
    public static final int USB_OPERATION_ERROR_INTERNAL = 1;
    public static final int USB_OPERATION_ERROR_NOT_SUPPORTED = 2;
    public static final int USB_OPERATION_ERROR_PORT_MISMATCH = 3;

    UsbOperationInternal(int operationID, String id2, Executor executor, Consumer<Integer> consumer) {
        this.mOperationID = operationID;
        this.mId = id2;
        this.mExecutor = executor;
        this.mConsumer = consumer;
        this.mAsynchronous = true;
    }

    UsbOperationInternal(int operationID, String id2) {
        this.mOperationID = operationID;
        this.mId = id2;
    }

    @Override
    public void onOperationComplete(int status) {
        this.mLock.lock();
        try {
            this.mOperationComplete = true;
            this.mStatus = status;
            Log.i(TAG, "Port:" + this.mId + " opID:" + this.mOperationID + " status:" + this.mStatus);
            if (this.mAsynchronous) {
                switch (this.mStatus) {
                    case 0: {
                        this.mResult = 0;
                        break;
                    }
                    case 1: {
                        this.mResult = 1;
                        break;
                    }
                    case 2: {
                        this.mResult = 2;
                        break;
                    }
                    case 3: {
                        this.mResult = 3;
                        break;
                    }
                    default: {
                        this.mResult = 4;
                    }
                }
                this.mExecutor.execute(() -> this.mConsumer.accept(this.mResult));
            } else {
                this.mOperationWait.signal();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOperationComplete() {
        this.mLock.lock();
        try {
            long now = System_Delegate.currentTimeMillis();
            long deadline = now + 5000L;
            do {
                this.mOperationWait.await(deadline - System_Delegate.currentTimeMillis(), TimeUnit.MILLISECONDS);
            } while (!this.mOperationComplete && System_Delegate.currentTimeMillis() < deadline);
            if (!this.mOperationComplete) {
                Log.e(TAG, "Port:" + this.mId + " opID:" + this.mOperationID + " operationComplete not received in " + 5000 + "msecs");
            }
        }
        catch (InterruptedException e) {
            Log.e(TAG, "Port:" + this.mId + " opID:" + this.mOperationID + " operationComplete interrupted");
        }
        finally {
            this.mLock.unlock();
        }
    }

    public int getStatus() {
        return this.mOperationComplete ? this.mStatus : 1;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface UsbOperationStatus {
    }
}

