/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.usb.DisplayPortAltModeInfo;
import android.hardware.usb.IDisplayPortAltModeInfoListener;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.IUsbOperationInternal;
import android.hardware.usb.ParcelableUsbPort;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.Binder;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class UsbManager {
    private static final String TAG = "UsbManager";
    @SystemApi
    public static final String ACTION_USB_STATE = "android.hardware.usb.action.USB_STATE";
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public static final String ACTION_USB_PORT_CHANGED = "android.hardware.usb.action.USB_PORT_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public static final String ACTION_USB_PORT_COMPLIANCE_CHANGED = "android.hardware.usb.action.USB_PORT_COMPLIANCE_CHANGED";
    public static final String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    public static final String ACTION_USB_DEVICE_DETACHED = "android.hardware.usb.action.USB_DEVICE_DETACHED";
    public static final String ACTION_USB_ACCESSORY_ATTACHED = "android.hardware.usb.action.USB_ACCESSORY_ATTACHED";
    public static final String ACTION_USB_ACCESSORY_DETACHED = "android.hardware.usb.action.USB_ACCESSORY_DETACHED";
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public static final String ACTION_USB_ACCESSORY_HANDSHAKE = "android.hardware.usb.action.USB_ACCESSORY_HANDSHAKE";
    @SystemApi
    public static final String USB_CONNECTED = "connected";
    public static final String USB_HOST_CONNECTED = "host_connected";
    @SystemApi
    public static final String USB_CONFIGURED = "configured";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String USB_DATA_UNLOCKED = "unlocked";
    @UnsupportedAppUsage
    public static final String USB_FUNCTION_NONE = "none";
    public static final String USB_FUNCTION_ADB = "adb";
    @SystemApi
    public static final String USB_FUNCTION_RNDIS = "rndis";
    public static final String USB_FUNCTION_MTP = "mtp";
    public static final String USB_FUNCTION_PTP = "ptp";
    public static final String USB_FUNCTION_AUDIO_SOURCE = "audio_source";
    public static final String USB_FUNCTION_MIDI = "midi";
    public static final String USB_FUNCTION_ACCESSORY = "accessory";
    @SystemApi
    public static final String USB_FUNCTION_NCM = "ncm";
    public static final String USB_FUNCTION_UVC = "uvc";
    public static final String GADGET_HAL_UNKNOWN = "unknown";
    public static final String GADGET_HAL_VERSION_1_0 = "V1_0";
    public static final String GADGET_HAL_VERSION_1_1 = "V1_1";
    public static final String GADGET_HAL_VERSION_1_2 = "V1_2";
    public static final String GADGET_HAL_VERSION_2_0 = "V2_0";
    public static final String EXTRA_PORT = "port";
    public static final String EXTRA_PORT_STATUS = "portStatus";
    public static final String EXTRA_DEVICE = "device";
    public static final String EXTRA_ACCESSORY = "accessory";
    @SystemApi
    public static final String EXTRA_ACCESSORY_UEVENT_TIME = "android.hardware.usb.extra.ACCESSORY_UEVENT_TIME";
    @SystemApi
    public static final String EXTRA_ACCESSORY_STRING_COUNT = "android.hardware.usb.extra.ACCESSORY_STRING_COUNT";
    @SystemApi
    public static final String EXTRA_ACCESSORY_START = "android.hardware.usb.extra.ACCESSORY_START";
    @SystemApi
    public static final String EXTRA_ACCESSORY_HANDSHAKE_END = "android.hardware.usb.extra.ACCESSORY_HANDSHAKE_END";
    public static final String EXTRA_PERMISSION_GRANTED = "permission";
    public static final String EXTRA_PACKAGE = "android.hardware.usb.extra.PACKAGE";
    public static final String EXTRA_CAN_BE_DEFAULT = "android.hardware.usb.extra.CAN_BE_DEFAULT";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int GADGET_HAL_NOT_SUPPORTED = -1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int GADGET_HAL_V1_0 = 10;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int GADGET_HAL_V1_1 = 11;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int GADGET_HAL_V1_2 = 12;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int GADGET_HAL_V2_0 = 20;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_UNKNOWN = -1;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_LOW_SPEED = 2;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_FULL_SPEED = 12;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_HIGH_SPEED = 480;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_5G = 5120;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_10G = 10240;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_20G = 20480;
    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    public static final int USB_DATA_TRANSFER_RATE_40G = 40960;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int USB_HAL_RETRY = -2;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int USB_HAL_NOT_SUPPORTED = -1;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int USB_HAL_V1_0 = 10;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int USB_HAL_V1_1 = 11;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int USB_HAL_V1_2 = 12;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int USB_HAL_V1_3 = 13;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int USB_HAL_V2_0 = 20;
    @SystemApi
    public static final long FUNCTION_NONE = 0L;
    @SystemApi
    public static final long FUNCTION_MTP = 4L;
    @SystemApi
    public static final long FUNCTION_PTP = 16L;
    @SystemApi
    public static final long FUNCTION_RNDIS = 32L;
    @SystemApi
    public static final long FUNCTION_MIDI = 8L;
    @SystemApi
    public static final long FUNCTION_ACCESSORY = 2L;
    @SystemApi
    public static final long FUNCTION_AUDIO_SOURCE = 64L;
    @SystemApi
    public static final long FUNCTION_ADB = 1L;
    @SystemApi
    public static final long FUNCTION_NCM = 1024L;
    @SystemApi
    public static final long FUNCTION_UVC = 128L;
    private static final long SETTABLE_FUNCTIONS = 1212L;
    private static final Map<String, Long> FUNCTION_NAME_TO_CODE = new HashMap<String, Long>();
    private static final AtomicInteger sUsbOperationCount = new AtomicInteger();
    private final Context mContext;
    private final IUsbManager mService;
    private final Object mDisplayPortListenersLock = new Object();
    @GuardedBy(value={"mDisplayPortListenersLock"})
    private ArrayMap<DisplayPortAltModeInfoListener, Executor> mDisplayPortListeners;
    @GuardedBy(value={"mDisplayPortListenersLock"})
    private DisplayPortAltModeInfoDispatchingListener mDisplayPortServiceListener;
    private final Object mAccessoryHandleMapLock = new Object();
    @GuardedBy(value={"mAccessoryHandleMapLock"})
    private ArrayMap<UsbAccessory, AccessoryHandle> mAccessoryHandleMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessoryHandle openHandleForAccessory(UsbAccessory accessory, boolean openingInputStream) throws RemoteException {
        Object object = this.mAccessoryHandleMapLock;
        synchronized (object) {
            if (this.mAccessoryHandleMap == null) {
                this.mAccessoryHandleMap = new ArrayMap();
            }
            if (!this.mAccessoryHandleMap.containsKey(accessory)) {
                ParcelFileDescriptor pfd = this.mService.openAccessory(accessory);
                AccessoryHandle newHandle = new AccessoryHandle(pfd, openingInputStream, !openingInputStream);
                this.mAccessoryHandleMap.put(accessory, newHandle);
                return newHandle;
            }
            AccessoryHandle currentHandle = this.mAccessoryHandleMap.get(accessory);
            if (currentHandle == null) {
                throw new IllegalStateException("Accessory doesn't have an associated handle yet!");
            }
            AccessoryHandle modifiedHandle = this.getModifiedHandleForOpeningStream(openingInputStream, currentHandle);
            this.mAccessoryHandleMap.put(accessory, modifiedHandle);
            return modifiedHandle;
        }
    }

    private AccessoryHandle getModifiedHandleForOpeningStream(boolean openingInputStream, @NonNull AccessoryHandle currentHandle) {
        if (currentHandle.isInputStreamOpened() && openingInputStream) {
            throw new IllegalStateException("Input stream already open for this accessory! Please close the existing input stream before opening a new one.");
        }
        if (currentHandle.isOutputStreamOpened() && !openingInputStream) {
            throw new IllegalStateException("Output stream already open for this accessory! Please close the existing output stream before opening a new one.");
        }
        boolean isInputStreamOpened = openingInputStream || currentHandle.isInputStreamOpened();
        boolean isOutputStreamOpened = !openingInputStream || currentHandle.isOutputStreamOpened();
        return new AccessoryHandle(currentHandle.getPfd(), isInputStreamOpened, isOutputStreamOpened);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHandleForAccessory(UsbAccessory accessory, boolean closingInputStream) throws IOException {
        Object object = this.mAccessoryHandleMapLock;
        synchronized (object) {
            AccessoryHandle currentHandle = this.mAccessoryHandleMap.get(accessory);
            if (currentHandle == null) {
                throw new IllegalStateException("No handle has been initialised for this accessory!");
            }
            AccessoryHandle modifiedHandle = this.getModifiedHandleForClosingStream(closingInputStream, currentHandle);
            if (!modifiedHandle.isOpen()) {
                modifiedHandle.getPfd().close();
                this.mAccessoryHandleMap.remove(accessory);
            } else {
                this.mAccessoryHandleMap.put(accessory, modifiedHandle);
            }
        }
    }

    private AccessoryHandle getModifiedHandleForClosingStream(boolean closingInputStream, @NonNull AccessoryHandle currentHandle) {
        if (!currentHandle.isInputStreamOpened() && closingInputStream) {
            throw new IllegalStateException("Attempting to close an input stream that has not been opened for this accessory!");
        }
        if (!currentHandle.isOutputStreamOpened() && !closingInputStream) {
            throw new IllegalStateException("Attempting to close an output stream that has not been opened for this accessory!");
        }
        boolean isInputStreamOpened = !closingInputStream && currentHandle.isInputStreamOpened();
        boolean isOutputStreamOpened = closingInputStream && currentHandle.isOutputStreamOpened();
        return new AccessoryHandle(currentHandle.getPfd(), isInputStreamOpened, isOutputStreamOpened);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public UsbManager(Context context, IUsbManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public HashMap<String, UsbDevice> getDeviceList() {
        HashMap<String, UsbDevice> result = new HashMap<String, UsbDevice>();
        if (this.mService == null) {
            return result;
        }
        Bundle bundle = new Bundle();
        try {
            this.mService.getDeviceList(bundle);
            for (String name : bundle.keySet()) {
                result.put(name, (UsbDevice)bundle.get(name));
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public UsbDeviceConnection openDevice(UsbDevice device) {
        try {
            String deviceName = device.getDeviceName();
            ParcelFileDescriptor pfd = this.mService.openDevice(deviceName, this.mContext.getPackageName());
            if (pfd != null) {
                UsbDeviceConnection connection = new UsbDeviceConnection(device);
                boolean result = connection.open(deviceName, pfd, this.mContext);
                pfd.close();
                if (result) {
                    return connection;
                }
            }
        }
        catch (Exception e) {
            Log.e(TAG, "exception in UsbManager.openDevice", e);
        }
        return null;
    }

    public UsbAccessory[] getAccessoryList() {
        if (this.mService == null) {
            return null;
        }
        try {
            UsbAccessory accessory = this.mService.getCurrentAccessory();
            if (accessory == null) {
                return null;
            }
            return new UsbAccessory[]{accessory};
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        try {
            return this.mService.openAccessory(accessory);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.hardware.usb.flags.enable_accessory_stream_api")
    @NonNull
    public InputStream openAccessoryInputStream(@NonNull UsbAccessory accessory) {
        try {
            return new AccessoryAutoCloseInputStream(accessory, this.openHandleForAccessory(accessory, true).getPfd());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.hardware.usb.flags.enable_accessory_stream_api")
    @NonNull
    public OutputStream openAccessoryOutputStream(@NonNull UsbAccessory accessory) {
        try {
            return new AccessoryAutoCloseOutputStream(accessory, this.openHandleForAccessory(accessory, false).getPfd());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ParcelFileDescriptor getControlFd(long function) {
        try {
            return this.mService.getControlFd(function);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasPermission(UsbDevice device) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasDevicePermission(device, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    public boolean hasPermission(@NonNull UsbDevice device, @NonNull String packageName, int pid, int uid) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasDevicePermissionWithIdentity(device, packageName, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasPermission(UsbAccessory accessory) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasAccessoryPermission(accessory);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    public boolean hasPermission(@NonNull UsbAccessory accessory, int pid, int uid) {
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.hasAccessoryPermissionWithIdentity(accessory, pid, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestPermission(UsbDevice device, PendingIntent pi) {
        try {
            this.mService.requestDevicePermission(device, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestPermission(UsbAccessory accessory, PendingIntent pi) {
        try {
            this.mService.requestAccessoryPermission(accessory, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void grantPermission(UsbDevice device) {
        this.grantPermission(device, Process.myUid());
    }

    public void grantPermission(UsbDevice device, int uid) {
        try {
            this.mService.grantDevicePermission(device, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public void grantPermission(UsbDevice device, String packageName) {
        try {
            int uid = this.mContext.getPackageManager().getPackageUidAsUser(packageName, this.mContext.getUserId());
            this.grantPermission(device, uid);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Package " + packageName + " not found.", e);
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isFunctionEnabled(String function) {
        try {
            return this.mService.isFunctionEnabled(function);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public boolean isUvcGadgetSupportEnabled() {
        try {
            return this.mService.isUvcGadgetSupportEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public void setCurrentFunctions(long functions) {
        int operationId = sUsbOperationCount.incrementAndGet() + Binder.getCallingUid();
        try {
            this.mService.setCurrentFunctions(functions, operationId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "setCurrentFunctions: failed to call setCurrentFunctions. functions:" + functions + ", opId:" + operationId, e);
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public void setCurrentFunction(String functions, boolean usbDataUnlocked) {
        int operationId = sUsbOperationCount.incrementAndGet() + Binder.getCallingUid();
        try {
            this.mService.setCurrentFunction(functions, usbDataUnlocked, operationId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "setCurrentFunction: failed to call setCurrentFunction. functions:" + functions + ", opId:" + operationId, e);
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public long getCurrentFunctions() {
        try {
            return this.mService.getCurrentFunctions();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setScreenUnlockedFunctions(long functions) {
        try {
            this.mService.setScreenUnlockedFunctions(functions);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long getScreenUnlockedFunctions() {
        try {
            return this.mService.getScreenUnlockedFunctions();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="android.hardware.usb.flags.expose_usb_speed_system_api")
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public int getUsbBandwidthMbps() {
        int usbSpeed;
        try {
            usbSpeed = this.mService.getCurrentUsbSpeed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return UsbManager.usbSpeedToBandwidth(usbSpeed);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public int getGadgetHalVersion() {
        try {
            return this.mService.getGadgetHalVersion();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public int getUsbHalVersion() {
        try {
            return this.mService.getUsbHalVersion();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public void resetUsbGadget() {
        try {
            this.mService.resetUsbGadget();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static boolean isUvcSupportEnabled() {
        return SystemProperties.getBoolean("ro.usb.uvc.enabled", false);
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    public boolean enableUsbDataSignal(boolean enable) {
        return this.setUsbDataSignal(this.getPorts(), !enable, true);
    }

    private boolean setUsbDataSignal(List<UsbPort> usbPorts, boolean disable, boolean revertOnFailure) {
        ArrayList<UsbPort> changedPorts = new ArrayList<UsbPort>();
        for (int i = 0; i < usbPorts.size(); ++i) {
            UsbPort port = usbPorts.get(i);
            if (this.isPortDisabled(port) == disable) continue;
            changedPorts.add(port);
            if (port.enableUsbData(!disable) == 0 || !revertOnFailure) continue;
            Log.e(TAG, "Failed to set usb data signal for portID(" + port.getId() + ")");
            this.setUsbDataSignal(changedPorts, !disable, false);
            return false;
        }
        return true;
    }

    private boolean isPortDisabled(UsbPort usbPort) {
        return (this.getPortStatus(usbPort).getUsbDataStatus() & 0x10) == 16;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    @NonNull
    public List<UsbPort> getPorts() {
        List<ParcelableUsbPort> parcelablePorts;
        if (this.mService == null) {
            return Collections.emptyList();
        }
        try {
            parcelablePorts = this.mService.getPorts();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (parcelablePorts == null) {
            return Collections.emptyList();
        }
        int numPorts = parcelablePorts.size();
        ArrayList<UsbPort> ports = new ArrayList<UsbPort>(numPorts);
        for (int i = 0; i < numPorts; ++i) {
            ports.add(parcelablePorts.get(i).getUsbPort(this));
        }
        return ports;
    }

    UsbPortStatus getPortStatus(UsbPort port) {
        try {
            return this.mService.getPortStatus(port.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    boolean isModeChangeSupported(UsbPort port) {
        try {
            return this.mService.isModeChangeSupported(port.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setPortRoles(UsbPort port, int powerRole, int dataRole) {
        Log.d(TAG, "setPortRoles Package:" + this.mContext.getPackageName());
        try {
            this.mService.setPortRoles(port.getId(), powerRole, dataRole);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    void enableContaminantDetection(@NonNull UsbPort port, boolean enable) {
        try {
            this.mService.enableContaminantDetection(port.getId(), enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    void enableLimitPowerTransfer(@NonNull UsbPort port, boolean limit, int operationId, IUsbOperationInternal callback) {
        Objects.requireNonNull(port, "enableLimitPowerTransfer:port must not be null. opId:" + operationId);
        try {
            this.mService.enableLimitPowerTransfer(port.getId(), limit, operationId, callback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "enableLimitPowerTransfer failed. opId:" + operationId, e);
            try {
                callback.onOperationComplete(1);
            }
            catch (RemoteException r) {
                Log.e(TAG, "enableLimitPowerTransfer failed to call onOperationComplete. opId:" + operationId, r);
            }
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    void resetUsbPort(@NonNull UsbPort port, int operationId, IUsbOperationInternal callback) {
        Objects.requireNonNull(port, "resetUsbPort: port must not be null. opId:" + operationId);
        try {
            this.mService.resetUsbPort(port.getId(), operationId, callback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "resetUsbPort: failed. ", e);
            try {
                callback.onOperationComplete(1);
            }
            catch (RemoteException r) {
                Log.e(TAG, "resetUsbPort: failed to call onOperationComplete. opId:" + operationId, r);
            }
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    boolean enableUsbData(@NonNull UsbPort port, boolean enable, int operationId, IUsbOperationInternal callback) {
        Objects.requireNonNull(port, "enableUsbData: port must not be null. opId:" + operationId);
        try {
            return this.mService.enableUsbData(port.getId(), enable, operationId, callback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "enableUsbData: failed. opId:" + operationId, e);
            try {
                callback.onOperationComplete(1);
            }
            catch (RemoteException r) {
                Log.e(TAG, "enableUsbData: failed to call onOperationComplete. opId:" + operationId, r);
            }
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_USB")
    void enableUsbDataWhileDocked(@NonNull UsbPort port, int operationId, IUsbOperationInternal callback) {
        Objects.requireNonNull(port, "enableUsbDataWhileDocked: port must not be null. opId:" + operationId);
        try {
            this.mService.enableUsbDataWhileDocked(port.getId(), operationId, callback);
        }
        catch (RemoteException e) {
            Log.e(TAG, "enableUsbDataWhileDocked: failed. opId:" + operationId, e);
            try {
                callback.onOperationComplete(1);
            }
            catch (RemoteException r) {
                Log.e(TAG, "enableUsbDataWhileDocked: failed to call onOperationComplete. opId:" + operationId, r);
            }
            throw e.rethrowFromSystemServer();
        }
    }

    @GuardedBy(value={"mDisplayPortListenersLock"})
    @RequiresPermission(value="android.permission.MANAGE_USB")
    private boolean registerDisplayPortAltModeEventsIfNeededLocked() {
        DisplayPortAltModeInfoDispatchingListener displayPortDispatchingListener = new DisplayPortAltModeInfoDispatchingListener();
        try {
            if (this.mService.registerForDisplayPortEvents(displayPortDispatchingListener)) {
                this.mDisplayPortServiceListener = displayPortDispatchingListener;
                return true;
            }
            return false;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public void registerDisplayPortAltModeInfoListener(@NonNull Executor executor, @NonNull DisplayPortAltModeInfoListener listener) {
        Objects.requireNonNull(executor, "registerDisplayPortAltModeInfoListener: executor must not be null.");
        Objects.requireNonNull(listener, "registerDisplayPortAltModeInfoListener: listener must not be null.");
        Object object = this.mDisplayPortListenersLock;
        synchronized (object) {
            if (this.mDisplayPortListeners == null) {
                this.mDisplayPortListeners = new ArrayMap();
            }
            if (this.mDisplayPortServiceListener == null && !this.registerDisplayPortAltModeEventsIfNeededLocked()) {
                throw new IllegalStateException("Unexpected failure registering service listener");
            }
            if (this.mDisplayPortListeners.containsKey(listener)) {
                throw new IllegalStateException("Listener has already been registered.");
            }
            this.mDisplayPortListeners.put(listener, executor);
        }
    }

    @GuardedBy(value={"mDisplayPortListenersLock"})
    @RequiresPermission(value="android.permission.MANAGE_USB")
    private void unregisterDisplayPortAltModeEventsLocked() {
        if (this.mDisplayPortServiceListener != null) {
            try {
                this.mService.unregisterForDisplayPortEvents(this.mDisplayPortServiceListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            finally {
                this.mDisplayPortServiceListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USB")
    public void unregisterDisplayPortAltModeInfoListener(@NonNull DisplayPortAltModeInfoListener listener) {
        Object object = this.mDisplayPortListenersLock;
        synchronized (object) {
            if (this.mDisplayPortListeners == null) {
                return;
            }
            this.mDisplayPortListeners.remove(listener);
            if (this.mDisplayPortListeners.isEmpty()) {
                this.unregisterDisplayPortAltModeEventsLocked();
            }
        }
    }

    public void setUsbDeviceConnectionHandler(@Nullable ComponentName usbDeviceConnectionHandler) {
        try {
            this.mService.setUsbDeviceConnectionHandler(usbDeviceConnectionHandler);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean areSettableFunctions(long functions) {
        return functions == 0L || (0xFFFFFFFFFFFFFB43L & functions) == 0L && (Long.bitCount(functions) == 1 || functions == 1056L);
    }

    public static String usbFunctionsToString(long functions) {
        StringJoiner joiner = new StringJoiner(",");
        if ((functions & 4L) != 0L) {
            joiner.add(USB_FUNCTION_MTP);
        }
        if ((functions & 0x10L) != 0L) {
            joiner.add(USB_FUNCTION_PTP);
        }
        if ((functions & 0x20L) != 0L) {
            joiner.add(USB_FUNCTION_RNDIS);
        }
        if ((functions & 8L) != 0L) {
            joiner.add(USB_FUNCTION_MIDI);
        }
        if ((functions & 2L) != 0L) {
            joiner.add("accessory");
        }
        if ((functions & 0x40L) != 0L) {
            joiner.add(USB_FUNCTION_AUDIO_SOURCE);
        }
        if ((functions & 0x400L) != 0L) {
            joiner.add(USB_FUNCTION_NCM);
        }
        if ((functions & 0x80L) != 0L) {
            joiner.add(USB_FUNCTION_UVC);
        }
        if ((functions & 1L) != 0L) {
            joiner.add(USB_FUNCTION_ADB);
        }
        return ((Object)joiner).toString();
    }

    public static long usbFunctionsFromString(String functions) {
        if (functions == null || functions.equals(USB_FUNCTION_NONE)) {
            return 0L;
        }
        long ret = 0L;
        for (String function : functions.split(",")) {
            if (FUNCTION_NAME_TO_CODE.containsKey(function)) {
                ret |= FUNCTION_NAME_TO_CODE.get(function).longValue();
                continue;
            }
            if (function.length() <= 0) continue;
            throw new IllegalArgumentException("Invalid usb function " + functions);
        }
        return ret;
    }

    public static int usbSpeedToBandwidth(int speed) {
        switch (speed) {
            case 9: {
                return 40960;
            }
            case 8: {
                return 20480;
            }
            case 7: {
                return 20480;
            }
            case 6: {
                return 10240;
            }
            case 5: {
                return 20480;
            }
            case 4: {
                return 10240;
            }
            case 3: {
                return 5120;
            }
            case 2: {
                return 480;
            }
            case 1: {
                return 12;
            }
            case 0: {
                return 2;
            }
        }
        return -1;
    }

    @NonNull
    public static String usbGadgetHalVersionToString(int version) {
        String halVersion = version == 20 ? GADGET_HAL_VERSION_2_0 : (version == 12 ? GADGET_HAL_VERSION_1_2 : (version == 11 ? GADGET_HAL_VERSION_1_1 : (version == 10 ? GADGET_HAL_VERSION_1_0 : GADGET_HAL_UNKNOWN)));
        return halVersion;
    }

    static {
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_MTP, 4L);
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_PTP, 16L);
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_RNDIS, 32L);
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_MIDI, 8L);
        FUNCTION_NAME_TO_CODE.put("accessory", 2L);
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_AUDIO_SOURCE, 64L);
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_ADB, 1L);
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_NCM, 1024L);
        FUNCTION_NAME_TO_CODE.put(USB_FUNCTION_UVC, 128L);
    }

    private static class AccessoryHandle {
        private final ParcelFileDescriptor mPfd;
        private final boolean mInputStreamOpened;
        private final boolean mOutputStreamOpened;

        AccessoryHandle(ParcelFileDescriptor parcelFileDescriptor, boolean inputStreamOpened, boolean outputStreamOpened) {
            this.mPfd = parcelFileDescriptor;
            this.mInputStreamOpened = inputStreamOpened;
            this.mOutputStreamOpened = outputStreamOpened;
        }

        public ParcelFileDescriptor getPfd() {
            return this.mPfd;
        }

        public boolean isInputStreamOpened() {
            return this.mInputStreamOpened;
        }

        public boolean isOutputStreamOpened() {
            return this.mOutputStreamOpened;
        }

        public boolean isOpen() {
            return this.mInputStreamOpened || this.mOutputStreamOpened;
        }
    }

    private class AccessoryAutoCloseInputStream
    extends FileInputStream {
        private final ParcelFileDescriptor mPfd;
        private final UsbAccessory mAccessory;

        AccessoryAutoCloseInputStream(UsbAccessory accessory, ParcelFileDescriptor pfd) {
            super(pfd.getFileDescriptor());
            this.mAccessory = accessory;
            this.mPfd = pfd;
        }

        @Override
        public void close() throws IOException {
            super.close();
            UsbManager.this.closeHandleForAccessory(this.mAccessory, true);
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            this.checkError(result);
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = super.read(b);
            this.checkError(result);
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            this.checkError(result);
            return result;
        }

        private void checkError(int result) throws IOException {
            if (result == -1 && this.mPfd.canDetectErrors()) {
                this.mPfd.checkError();
            }
        }
    }

    private class AccessoryAutoCloseOutputStream
    extends FileOutputStream {
        private final UsbAccessory mAccessory;

        AccessoryAutoCloseOutputStream(UsbAccessory accessory, ParcelFileDescriptor pfd) {
            super(pfd.getFileDescriptor());
            this.mAccessory = accessory;
        }

        @Override
        public void close() throws IOException {
            super.close();
            UsbManager.this.closeHandleForAccessory(this.mAccessory, false);
        }
    }

    private class DisplayPortAltModeInfoDispatchingListener
    extends IDisplayPortAltModeInfoListener.Stub {
        private DisplayPortAltModeInfoDispatchingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayPortAltModeInfoChanged(String portId, DisplayPortAltModeInfo displayPortAltModeInfo) {
            Object object = UsbManager.this.mDisplayPortListenersLock;
            synchronized (object) {
                for (Map.Entry<DisplayPortAltModeInfoListener, Executor> entry : UsbManager.this.mDisplayPortListeners.entrySet()) {
                    Executor executor = entry.getValue();
                    DisplayPortAltModeInfoListener callback = entry.getKey();
                    long token = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onDisplayPortAltModeInfoChanged(portId, displayPortAltModeInfo));
                    }
                    catch (Exception e) {
                        Slog.e(UsbManager.TAG, "Exception during onDisplayPortAltModeInfoChanged from executor: " + executor, e);
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            }
        }
    }

    @SystemApi
    public static interface DisplayPortAltModeInfoListener {
        public void onDisplayPortAltModeInfoChanged(@NonNull String var1, @NonNull DisplayPortAltModeInfo var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsbHalVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsbGadgetHalVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsbFunctionMode {
    }
}

