/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.KeyEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class VirtualKeyEvent
implements Parcelable {
    public static final int ACTION_UNKNOWN = -1;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    private final int mAction;
    private final int mKeyCode;
    private final long mEventTimeNanos;
    @NonNull
    public static final Parcelable.Creator<VirtualKeyEvent> CREATOR = new Parcelable.Creator<VirtualKeyEvent>(){

        @Override
        public VirtualKeyEvent createFromParcel(Parcel source) {
            return new VirtualKeyEvent(source);
        }

        public VirtualKeyEvent[] newArray(int size) {
            return new VirtualKeyEvent[size];
        }
    };

    private VirtualKeyEvent(int action, int keyCode, long eventTimeNanos) {
        this.mAction = action;
        this.mKeyCode = keyCode;
        this.mEventTimeNanos = eventTimeNanos;
    }

    private VirtualKeyEvent(@NonNull Parcel parcel) {
        this.mAction = parcel.readInt();
        this.mKeyCode = parcel.readInt();
        this.mEventTimeNanos = parcel.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelableFlags) {
        parcel.writeInt(this.mAction);
        parcel.writeInt(this.mKeyCode);
        parcel.writeLong(this.mEventTimeNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "VirtualKeyEvent( action=" + KeyEvent.actionToString(this.mAction) + " keyCode=" + KeyEvent.keyCodeToString(this.mKeyCode) + " eventTime(ns)=" + this.mEventTimeNanos;
    }

    public int getKeyCode() {
        return this.mKeyCode;
    }

    public int getAction() {
        return this.mAction;
    }

    public long getEventTimeNanos() {
        return this.mEventTimeNanos;
    }

    public static class Builder {
        private int mAction = -1;
        private int mKeyCode = -1;
        private long mEventTimeNanos = 0L;

        @NonNull
        public VirtualKeyEvent build() {
            if (this.mAction == -1 || this.mKeyCode == -1) {
                throw new IllegalArgumentException("Cannot build virtual key event with unset fields");
            }
            return new VirtualKeyEvent(this.mAction, this.mKeyCode, this.mEventTimeNanos);
        }

        @NonNull
        public Builder setKeyCode(int keyCode) {
            this.mKeyCode = keyCode;
            return this;
        }

        @NonNull
        public Builder setAction(int action) {
            if (action != 0 && action != 1) {
                throw new IllegalArgumentException("Unsupported action type");
            }
            this.mAction = action;
            return this;
        }

        @NonNull
        public Builder setEventTimeNanos(long eventTimeNanos) {
            if (eventTimeNanos < 0L) {
                throw new IllegalArgumentException("Event time cannot be negative");
            }
            this.mEventTimeNanos = eventTimeNanos;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedKeycode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
    }
}

