/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseIntArray;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class KeyGlyphMap
implements Parcelable {
    private static final String TAG = "KeyGlyphMap";
    @NonNull
    private final ComponentName mComponentName;
    @NonNull
    private final SparseIntArray mKeyGlyphs;
    @NonNull
    private final SparseIntArray mModifierGlyphs;
    @NonNull
    private final int[] mFunctionRowKeys;
    @NonNull
    private final Map<KeyCombination, Integer> mHardwareShortcuts;
    @NonNull
    public static final Parcelable.Creator<KeyGlyphMap> CREATOR = new Parcelable.Creator<KeyGlyphMap>(){

        @Override
        public KeyGlyphMap createFromParcel(Parcel in) {
            return new KeyGlyphMap(in);
        }

        public KeyGlyphMap[] newArray(int size) {
            return new KeyGlyphMap[size];
        }
    };

    public KeyGlyphMap(@NonNull ComponentName componentName, @NonNull SparseIntArray keyGlyphs, @NonNull SparseIntArray modifierGlyphs, @NonNull int[] functionRowKeys, @NonNull Map<KeyCombination, Integer> hardwareShortcuts) {
        this.mComponentName = componentName;
        this.mKeyGlyphs = keyGlyphs;
        this.mModifierGlyphs = modifierGlyphs;
        this.mFunctionRowKeys = functionRowKeys;
        this.mHardwareShortcuts = hardwareShortcuts;
    }

    public KeyGlyphMap(Parcel in) {
        this.mComponentName = in.readParcelable(this.getClass().getClassLoader(), ComponentName.class);
        this.mKeyGlyphs = in.readSparseIntArray();
        this.mModifierGlyphs = in.readSparseIntArray();
        this.mFunctionRowKeys = new int[in.readInt()];
        in.readIntArray(this.mFunctionRowKeys);
        this.mHardwareShortcuts = new HashMap<KeyCombination, Integer>(in.readInt());
        in.readMap(this.mHardwareShortcuts, this.getClass().getClassLoader(), KeyCombination.class, Integer.class);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mComponentName, 0);
        dest.writeSparseIntArray(this.mKeyGlyphs);
        dest.writeSparseIntArray(this.mModifierGlyphs);
        dest.writeInt(this.mFunctionRowKeys.length);
        dest.writeIntArray(this.mFunctionRowKeys);
        dest.writeInt(this.mHardwareShortcuts.size());
        dest.writeMap(this.mHardwareShortcuts);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int[] getFunctionRowKeys() {
        return this.mFunctionRowKeys;
    }

    public Map<KeyCombination, Integer> getHardwareShortcuts() {
        return this.mHardwareShortcuts;
    }

    @Nullable
    public Drawable getDrawableForKeycode(Context context, int keycode) {
        return this.getDrawable(context, this.mKeyGlyphs.get(keycode, 0));
    }

    @Nullable
    public Drawable getDrawableForModifier(Context context, int modifierKeycode) {
        int n;
        switch (modifierKeycode) {
            case 117: 
            case 118: {
                n = 65536;
                break;
            }
            case 113: 
            case 114: {
                n = 4096;
                break;
            }
            case 57: 
            case 58: {
                n = 2;
                break;
            }
            case 59: 
            case 60: {
                n = 1;
                break;
            }
            case 119: {
                n = 8;
                break;
            }
            case 63: {
                n = 4;
                break;
            }
            case 115: {
                n = 0x100000;
                break;
            }
            case 143: {
                n = 0x200000;
                break;
            }
            case 116: {
                n = 0x400000;
                break;
            }
            default: {
                n = 0;
            }
        }
        int modifier = n;
        return this.getDrawable(context, this.mModifierGlyphs.get(modifier, 0));
    }

    @Nullable
    public Drawable getDrawableForModifierState(Context context, int modifierState) {
        return this.getDrawable(context, this.mModifierGlyphs.get(modifierState, 0));
    }

    @Nullable
    private Drawable getDrawable(Context context, int drawableRes) {
        PackageManager pm = context.getPackageManager();
        try {
            ActivityInfo receiver = pm.getReceiverInfo(this.mComponentName, 786560);
            Resources resources = pm.getResourcesForApplication(receiver.applicationInfo);
            return resources.getDrawable(drawableRes, null);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            Log.e(TAG, "Package name not found for " + this.mComponentName);
        }
        catch (Resources.NotFoundException ignored) {
            Log.e(TAG, "Resource not found for " + this.mComponentName);
        }
        return null;
    }

    public String toString() {
        return "KeyGlyphMap{mComponentName=" + this.mComponentName + ", mKeyGlyphs=" + this.mKeyGlyphs + ", mModifierGlyphs=" + this.mModifierGlyphs + ", mFunctionRowKeys=" + Arrays.toString(this.mFunctionRowKeys) + ", mHardwareShortcuts=" + this.mHardwareShortcuts + '}';
    }

    public static class KeyCombination
    implements Parcelable {
        private final int mModifierState;
        private final int mKeycode;
        public static final Parcelable.Creator<KeyCombination> CREATOR = new Parcelable.Creator<KeyCombination>(){

            @Override
            public KeyCombination createFromParcel(Parcel in) {
                return new KeyCombination(in);
            }

            public KeyCombination[] newArray(int size) {
                return new KeyCombination[size];
            }
        };

        public KeyCombination(int modifierState, int keycode) {
            this.mModifierState = modifierState;
            this.mKeycode = keycode;
        }

        public KeyCombination(Parcel in) {
            this(in.readInt(), in.readInt());
        }

        public int getModifierState() {
            return this.mModifierState;
        }

        public int getKeycode() {
            return this.mKeycode;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
            dest.writeInt(this.mModifierState);
            dest.writeInt(this.mKeycode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyCombination)) {
                return false;
            }
            KeyCombination that = (KeyCombination)o;
            return this.mModifierState == that.mModifierState && this.mKeycode == that.mKeycode;
        }

        public int hashCode() {
            return Objects.hash(this.mModifierState, this.mKeycode);
        }
    }
}

