/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.ComponentInfoInternal;
import android.hardware.biometrics.SensorLocationInternal;
import android.hardware.biometrics.SensorPropertiesInternal;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.List;

public class FingerprintSensorPropertiesInternal
extends SensorPropertiesInternal {
    public final int sensorType;
    public final boolean halControlsIllumination;
    private final List<SensorLocationInternal> mSensorLocations;
    public static final Parcelable.Creator<FingerprintSensorPropertiesInternal> CREATOR = new Parcelable.Creator<FingerprintSensorPropertiesInternal>(){

        @Override
        public FingerprintSensorPropertiesInternal createFromParcel(Parcel in) {
            return new FingerprintSensorPropertiesInternal(in);
        }

        public FingerprintSensorPropertiesInternal[] newArray(int size) {
            return new FingerprintSensorPropertiesInternal[size];
        }
    };

    public FingerprintSensorPropertiesInternal(int sensorId, int strength, int maxEnrollmentsPerUser, @NonNull List<ComponentInfoInternal> componentInfo, int sensorType, boolean halControlsIllumination, boolean resetLockoutRequiresHardwareAuthToken, @NonNull List<SensorLocationInternal> sensorLocations) {
        super(sensorId, strength, maxEnrollmentsPerUser, componentInfo, resetLockoutRequiresHardwareAuthToken, false);
        this.sensorType = sensorType;
        this.halControlsIllumination = halControlsIllumination;
        this.mSensorLocations = List.copyOf(sensorLocations);
    }

    public FingerprintSensorPropertiesInternal(int sensorId, int strength, int maxEnrollmentsPerUser, @NonNull List<ComponentInfoInternal> componentInfo, int sensorType, boolean resetLockoutRequiresHardwareAuthToken) {
        this(sensorId, strength, maxEnrollmentsPerUser, componentInfo, sensorType, false, resetLockoutRequiresHardwareAuthToken, List.of(new SensorLocationInternal("", 540, 1636, 130)));
    }

    protected FingerprintSensorPropertiesInternal(Parcel in) {
        super(in);
        this.sensorType = in.readInt();
        this.halControlsIllumination = in.readBoolean();
        this.mSensorLocations = in.createTypedArrayList(SensorLocationInternal.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.sensorType);
        dest.writeBoolean(this.halControlsIllumination);
        dest.writeTypedList(this.mSensorLocations);
    }

    public boolean isAnyUdfpsType() {
        switch (this.sensorType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isUltrasonicUdfps() {
        return this.sensorType == 2;
    }

    public boolean isOpticalUdfps() {
        return this.sensorType == 3;
    }

    public boolean isAnySidefpsType() {
        switch (this.sensorType) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    @NonNull
    public SensorLocationInternal getLocation() {
        SensorLocationInternal location = this.getLocation("");
        return location != null ? location : SensorLocationInternal.DEFAULT;
    }

    @Nullable
    public SensorLocationInternal getLocation(String displayId) {
        for (SensorLocationInternal location : this.mSensorLocations) {
            if (!location.displayId.equals(displayId)) continue;
            return location;
        }
        return null;
    }

    @NonNull
    public List<SensorLocationInternal> getAllLocations() {
        return this.mSensorLocations;
    }

    @Override
    public String toString() {
        return "ID: " + this.sensorId + ", Strength: " + this.sensorStrength + ", Type: " + this.sensorType;
    }
}

