/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.biometrics.AuthenticateOptions;
import android.hardware.biometrics.common.AuthenticateReason;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class FingerprintAuthenticateOptions
implements AuthenticateOptions,
Parcelable {
    private final int mUserId;
    private int mSensorId;
    private final boolean mIgnoreEnrollmentState;
    private final int mDisplayState;
    @NonNull
    private String mOpPackageName;
    @Nullable
    private String mAttributionTag;
    @Nullable
    private AuthenticateReason.Vendor mVendorReason;
    private boolean mIsMandatoryBiometrics;
    @NonNull
    public static final Parcelable.Creator<FingerprintAuthenticateOptions> CREATOR = new Parcelable.Creator<FingerprintAuthenticateOptions>(){

        public FingerprintAuthenticateOptions[] newArray(int size) {
            return new FingerprintAuthenticateOptions[size];
        }

        @Override
        public FingerprintAuthenticateOptions createFromParcel(@NonNull Parcel in) {
            return new FingerprintAuthenticateOptions(in);
        }
    };

    private static int defaultUserId() {
        return 0;
    }

    private static int defaultSensorId() {
        return -1;
    }

    private static boolean defaultIgnoreEnrollmentState() {
        return false;
    }

    private static int defaultDisplayState() {
        return 0;
    }

    private static String defaultOpPackageName() {
        return "";
    }

    private static String defaultAttributionTag() {
        return null;
    }

    private static AuthenticateReason.Vendor defaultVendorReason() {
        return null;
    }

    FingerprintAuthenticateOptions(int userId, int sensorId, boolean ignoreEnrollmentState, int displayState, @NonNull String opPackageName, @Nullable String attributionTag, @Nullable AuthenticateReason.Vendor vendorReason, boolean isMandatoryBiometrics) {
        this.mUserId = userId;
        this.mSensorId = sensorId;
        this.mIgnoreEnrollmentState = ignoreEnrollmentState;
        this.mDisplayState = displayState;
        AnnotationValidations.validate(AuthenticateOptions.DisplayState.class, null, this.mDisplayState);
        this.mOpPackageName = opPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOpPackageName);
        this.mAttributionTag = attributionTag;
        this.mVendorReason = vendorReason;
        this.mIsMandatoryBiometrics = isMandatoryBiometrics;
    }

    @Override
    public int getUserId() {
        return this.mUserId;
    }

    @Override
    public int getSensorId() {
        return this.mSensorId;
    }

    public boolean isIgnoreEnrollmentState() {
        return this.mIgnoreEnrollmentState;
    }

    @Override
    public int getDisplayState() {
        return this.mDisplayState;
    }

    @Override
    @NonNull
    public String getOpPackageName() {
        return this.mOpPackageName;
    }

    @Override
    @Nullable
    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    @Nullable
    public AuthenticateReason.Vendor getVendorReason() {
        return this.mVendorReason;
    }

    @Override
    public boolean isMandatoryBiometrics() {
        return this.mIsMandatoryBiometrics;
    }

    @NonNull
    public FingerprintAuthenticateOptions setSensorId(int value) {
        this.mSensorId = value;
        return this;
    }

    @NonNull
    public FingerprintAuthenticateOptions setOpPackageName(@NonNull String value) {
        this.mOpPackageName = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOpPackageName);
        return this;
    }

    @NonNull
    public FingerprintAuthenticateOptions setAttributionTag(@NonNull String value) {
        this.mAttributionTag = value;
        return this;
    }

    @NonNull
    public FingerprintAuthenticateOptions setVendorReason(@NonNull AuthenticateReason.Vendor value) {
        this.mVendorReason = value;
        return this;
    }

    @NonNull
    public FingerprintAuthenticateOptions setIsMandatoryBiometrics(boolean value) {
        this.mIsMandatoryBiometrics = value;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FingerprintAuthenticateOptions that = (FingerprintAuthenticateOptions)o;
        return this.mUserId == that.mUserId && this.mSensorId == that.mSensorId && this.mIgnoreEnrollmentState == that.mIgnoreEnrollmentState && this.mDisplayState == that.mDisplayState && Objects.equals(this.mOpPackageName, that.mOpPackageName) && Objects.equals(this.mAttributionTag, that.mAttributionTag) && Objects.equals(this.mVendorReason, that.mVendorReason) && this.mIsMandatoryBiometrics == that.mIsMandatoryBiometrics;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mUserId;
        _hash = 31 * _hash + this.mSensorId;
        _hash = 31 * _hash + Boolean.hashCode(this.mIgnoreEnrollmentState);
        _hash = 31 * _hash + this.mDisplayState;
        _hash = 31 * _hash + Objects.hashCode(this.mOpPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionTag);
        _hash = 31 * _hash + Objects.hashCode(this.mVendorReason);
        _hash = 31 * _hash + Boolean.hashCode(this.mIsMandatoryBiometrics);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        int flg = 0;
        if (this.mIgnoreEnrollmentState) {
            flg |= 4;
        }
        if (this.mIsMandatoryBiometrics) {
            flg |= 0x80;
        }
        if (this.mAttributionTag != null) {
            flg |= 0x20;
        }
        if (this.mVendorReason != null) {
            flg |= 0x40;
        }
        dest.writeInt(flg);
        dest.writeInt(this.mUserId);
        dest.writeInt(this.mSensorId);
        dest.writeInt(this.mDisplayState);
        dest.writeString(this.mOpPackageName);
        if (this.mAttributionTag != null) {
            dest.writeString(this.mAttributionTag);
        }
        if (this.mVendorReason != null) {
            dest.writeTypedObject(this.mVendorReason, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    FingerprintAuthenticateOptions(@NonNull Parcel in) {
        int flg = in.readInt();
        boolean ignoreEnrollmentState = (flg & 4) != 0;
        boolean isMandatoryBiometrics = (flg & 0x80) != 0;
        int userId = in.readInt();
        int sensorId = in.readInt();
        int displayState = in.readInt();
        String opPackageName = in.readString();
        String attributionTag = (flg & 0x20) == 0 ? null : in.readString();
        AuthenticateReason.Vendor vendorReason = (flg & 0x40) == 0 ? null : in.readTypedObject(AuthenticateReason.Vendor.CREATOR);
        this.mUserId = userId;
        this.mSensorId = sensorId;
        this.mIgnoreEnrollmentState = ignoreEnrollmentState;
        this.mDisplayState = displayState;
        AnnotationValidations.validate(AuthenticateOptions.DisplayState.class, null, this.mDisplayState);
        this.mOpPackageName = opPackageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mOpPackageName);
        this.mAttributionTag = attributionTag;
        this.mVendorReason = vendorReason;
        this.mIsMandatoryBiometrics = isMandatoryBiometrics;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private int mUserId;
        private int mSensorId;
        private boolean mIgnoreEnrollmentState;
        private int mDisplayState;
        @NonNull
        private String mOpPackageName;
        @Nullable
        private String mAttributionTag;
        @Nullable
        private AuthenticateReason.Vendor mVendorReason;
        private boolean mIsMandatoryBiometrics;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setUserId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mUserId = value;
            return this;
        }

        @NonNull
        public Builder setSensorId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mSensorId = value;
            return this;
        }

        @NonNull
        public Builder setIgnoreEnrollmentState(boolean value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mIgnoreEnrollmentState = value;
            return this;
        }

        @NonNull
        public Builder setDisplayState(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mDisplayState = value;
            return this;
        }

        @NonNull
        public Builder setOpPackageName(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mOpPackageName = value;
            return this;
        }

        @NonNull
        public Builder setAttributionTag(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mAttributionTag = value;
            return this;
        }

        @NonNull
        public Builder setVendorReason(@NonNull AuthenticateReason.Vendor value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mVendorReason = value;
            return this;
        }

        @NonNull
        public Builder setIsMandatoryBiometrics(boolean value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            this.mIsMandatoryBiometrics = value;
            return this;
        }

        @NonNull
        public FingerprintAuthenticateOptions build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x100L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mUserId = FingerprintAuthenticateOptions.defaultUserId();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mSensorId = FingerprintAuthenticateOptions.defaultSensorId();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mIgnoreEnrollmentState = FingerprintAuthenticateOptions.defaultIgnoreEnrollmentState();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mDisplayState = FingerprintAuthenticateOptions.defaultDisplayState();
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mOpPackageName = FingerprintAuthenticateOptions.defaultOpPackageName();
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mAttributionTag = FingerprintAuthenticateOptions.defaultAttributionTag();
            }
            if ((this.mBuilderFieldsSet & 0x40L) == 0L) {
                this.mVendorReason = FingerprintAuthenticateOptions.defaultVendorReason();
            }
            FingerprintAuthenticateOptions o = new FingerprintAuthenticateOptions(this.mUserId, this.mSensorId, this.mIgnoreEnrollmentState, this.mDisplayState, this.mOpPackageName, this.mAttributionTag, this.mVendorReason, this.mIsMandatoryBiometrics);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x100L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

