/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.hardware.display.Time;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface IColorDisplayManager
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.display.IColorDisplayManager";

    public boolean isDeviceColorManaged() throws RemoteException;

    public boolean setSaturationLevel(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setAppSaturationLevel(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean isSaturationActivated() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public int getTransformCapabilities() throws RemoteException;

    public boolean isNightDisplayActivated() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setNightDisplayActivated(boolean var1) throws RemoteException;

    public int getNightDisplayColorTemperature() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setNightDisplayColorTemperature(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public int getNightDisplayAutoMode() throws RemoteException;

    public int getNightDisplayAutoModeRaw() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setNightDisplayAutoMode(int var1) throws RemoteException;

    public Time getNightDisplayCustomStartTime() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setNightDisplayCustomStartTime(Time var1) throws RemoteException;

    public Time getNightDisplayCustomEndTime() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setNightDisplayCustomEndTime(Time var1) throws RemoteException;

    public int getColorMode() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public void setColorMode(int var1) throws RemoteException;

    public boolean isDisplayWhiteBalanceEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setDisplayWhiteBalanceEnabled(boolean var1) throws RemoteException;

    public boolean isReduceBrightColorsActivated() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setReduceBrightColorsActivated(boolean var1) throws RemoteException;

    public int getReduceBrightColorsStrength() throws RemoteException;

    @EnforcePermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    public boolean setReduceBrightColorsStrength(int var1) throws RemoteException;

    public float getReduceBrightColorsOffsetFactor() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IColorDisplayManager {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_isDeviceColorManaged = 1;
        static final int TRANSACTION_setSaturationLevel = 2;
        static final int TRANSACTION_setAppSaturationLevel = 3;
        static final int TRANSACTION_isSaturationActivated = 4;
        static final int TRANSACTION_getTransformCapabilities = 5;
        static final int TRANSACTION_isNightDisplayActivated = 6;
        static final int TRANSACTION_setNightDisplayActivated = 7;
        static final int TRANSACTION_getNightDisplayColorTemperature = 8;
        static final int TRANSACTION_setNightDisplayColorTemperature = 9;
        static final int TRANSACTION_getNightDisplayAutoMode = 10;
        static final int TRANSACTION_getNightDisplayAutoModeRaw = 11;
        static final int TRANSACTION_setNightDisplayAutoMode = 12;
        static final int TRANSACTION_getNightDisplayCustomStartTime = 13;
        static final int TRANSACTION_setNightDisplayCustomStartTime = 14;
        static final int TRANSACTION_getNightDisplayCustomEndTime = 15;
        static final int TRANSACTION_setNightDisplayCustomEndTime = 16;
        static final int TRANSACTION_getColorMode = 17;
        static final int TRANSACTION_setColorMode = 18;
        static final int TRANSACTION_isDisplayWhiteBalanceEnabled = 19;
        static final int TRANSACTION_setDisplayWhiteBalanceEnabled = 20;
        static final int TRANSACTION_isReduceBrightColorsActivated = 21;
        static final int TRANSACTION_setReduceBrightColorsActivated = 22;
        static final int TRANSACTION_getReduceBrightColorsStrength = 23;
        static final int TRANSACTION_setReduceBrightColorsStrength = 24;
        static final int TRANSACTION_getReduceBrightColorsOffsetFactor = 25;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IColorDisplayManager.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IColorDisplayManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IColorDisplayManager.DESCRIPTOR);
            if (iin != null && iin instanceof IColorDisplayManager) {
                return (IColorDisplayManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isDeviceColorManaged";
                }
                case 2: {
                    return "setSaturationLevel";
                }
                case 3: {
                    return "setAppSaturationLevel";
                }
                case 4: {
                    return "isSaturationActivated";
                }
                case 5: {
                    return "getTransformCapabilities";
                }
                case 6: {
                    return "isNightDisplayActivated";
                }
                case 7: {
                    return "setNightDisplayActivated";
                }
                case 8: {
                    return "getNightDisplayColorTemperature";
                }
                case 9: {
                    return "setNightDisplayColorTemperature";
                }
                case 10: {
                    return "getNightDisplayAutoMode";
                }
                case 11: {
                    return "getNightDisplayAutoModeRaw";
                }
                case 12: {
                    return "setNightDisplayAutoMode";
                }
                case 13: {
                    return "getNightDisplayCustomStartTime";
                }
                case 14: {
                    return "setNightDisplayCustomStartTime";
                }
                case 15: {
                    return "getNightDisplayCustomEndTime";
                }
                case 16: {
                    return "setNightDisplayCustomEndTime";
                }
                case 17: {
                    return "getColorMode";
                }
                case 18: {
                    return "setColorMode";
                }
                case 19: {
                    return "isDisplayWhiteBalanceEnabled";
                }
                case 20: {
                    return "setDisplayWhiteBalanceEnabled";
                }
                case 21: {
                    return "isReduceBrightColorsActivated";
                }
                case 22: {
                    return "setReduceBrightColorsActivated";
                }
                case 23: {
                    return "getReduceBrightColorsStrength";
                }
                case 24: {
                    return "setReduceBrightColorsStrength";
                }
                case 25: {
                    return "getReduceBrightColorsOffsetFactor";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IColorDisplayManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _result = this.isDeviceColorManaged();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setSaturationLevel(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setAppSaturationLevel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    boolean _result = this.isSaturationActivated();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _result = this.getTransformCapabilities();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    boolean _result = this.isNightDisplayActivated();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNightDisplayActivated(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    int _result = this.getNightDisplayColorTemperature();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNightDisplayColorTemperature(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    int _result = this.getNightDisplayAutoMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    int _result = this.getNightDisplayAutoModeRaw();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setNightDisplayAutoMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    Time _result = this.getNightDisplayCustomStartTime();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    Time _arg0 = data.readTypedObject(Time.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setNightDisplayCustomStartTime(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    Time _result = this.getNightDisplayCustomEndTime();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 16: {
                    Time _arg0 = data.readTypedObject(Time.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setNightDisplayCustomEndTime(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    int _result = this.getColorMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setColorMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    boolean _result = this.isDisplayWhiteBalanceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setDisplayWhiteBalanceEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    boolean _result = this.isReduceBrightColorsActivated();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 22: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.setReduceBrightColorsActivated(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    int _result = this.getReduceBrightColorsStrength();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setReduceBrightColorsStrength(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    float _result = this.getReduceBrightColorsOffsetFactor();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setAppSaturationLevel_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isSaturationActivated_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getTransformCapabilities_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNightDisplayActivated_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNightDisplayColorTemperature_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getNightDisplayAutoMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNightDisplayAutoMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNightDisplayCustomStartTime_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setNightDisplayCustomEndTime_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setColorMode_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDisplayWhiteBalanceEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setReduceBrightColorsActivated_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setReduceBrightColorsStrength_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements IColorDisplayManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IColorDisplayManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceColorManaged() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSaturationLevel(int saturationLevel) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeInt(saturationLevel);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAppSaturationLevel(String packageName, int saturationLevel) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(saturationLevel);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSaturationActivated() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTransformCapabilities() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isNightDisplayActivated() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNightDisplayActivated(boolean activated) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeBoolean(activated);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNightDisplayColorTemperature() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNightDisplayColorTemperature(int temperature) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeInt(temperature);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNightDisplayAutoMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNightDisplayAutoModeRaw() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNightDisplayAutoMode(int autoMode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeInt(autoMode);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Time getNightDisplayCustomStartTime() throws RemoteException {
                Time _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Time.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNightDisplayCustomStartTime(Time time) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeTypedObject(time, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Time getNightDisplayCustomEndTime() throws RemoteException {
                Time _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Time.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setNightDisplayCustomEndTime(Time time) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeTypedObject(time, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getColorMode() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setColorMode(int colorMode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeInt(colorMode);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDisplayWhiteBalanceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setDisplayWhiteBalanceEnabled(boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isReduceBrightColorsActivated() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setReduceBrightColorsActivated(boolean activated) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeBoolean(activated);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getReduceBrightColorsStrength() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setReduceBrightColorsStrength(int strength) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    _data.writeInt(strength);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getReduceBrightColorsOffsetFactor() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IColorDisplayManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IColorDisplayManager {
        @Override
        public boolean isDeviceColorManaged() throws RemoteException {
            return false;
        }

        @Override
        public boolean setSaturationLevel(int saturationLevel) throws RemoteException {
            return false;
        }

        @Override
        public boolean setAppSaturationLevel(String packageName, int saturationLevel) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSaturationActivated() throws RemoteException {
            return false;
        }

        @Override
        public int getTransformCapabilities() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isNightDisplayActivated() throws RemoteException {
            return false;
        }

        @Override
        public boolean setNightDisplayActivated(boolean activated) throws RemoteException {
            return false;
        }

        @Override
        public int getNightDisplayColorTemperature() throws RemoteException {
            return 0;
        }

        @Override
        public boolean setNightDisplayColorTemperature(int temperature) throws RemoteException {
            return false;
        }

        @Override
        public int getNightDisplayAutoMode() throws RemoteException {
            return 0;
        }

        @Override
        public int getNightDisplayAutoModeRaw() throws RemoteException {
            return 0;
        }

        @Override
        public boolean setNightDisplayAutoMode(int autoMode) throws RemoteException {
            return false;
        }

        @Override
        public Time getNightDisplayCustomStartTime() throws RemoteException {
            return null;
        }

        @Override
        public boolean setNightDisplayCustomStartTime(Time time) throws RemoteException {
            return false;
        }

        @Override
        public Time getNightDisplayCustomEndTime() throws RemoteException {
            return null;
        }

        @Override
        public boolean setNightDisplayCustomEndTime(Time time) throws RemoteException {
            return false;
        }

        @Override
        public int getColorMode() throws RemoteException {
            return 0;
        }

        @Override
        public void setColorMode(int colorMode) throws RemoteException {
        }

        @Override
        public boolean isDisplayWhiteBalanceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean setDisplayWhiteBalanceEnabled(boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public boolean isReduceBrightColorsActivated() throws RemoteException {
            return false;
        }

        @Override
        public boolean setReduceBrightColorsActivated(boolean activated) throws RemoteException {
            return false;
        }

        @Override
        public int getReduceBrightColorsStrength() throws RemoteException {
            return 0;
        }

        @Override
        public boolean setReduceBrightColorsStrength(int strength) throws RemoteException {
            return false;
        }

        @Override
        public float getReduceBrightColorsOffsetFactor() throws RemoteException {
            return 0.0f;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

