/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.Display;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class HdrConversionMode
implements Parcelable {
    public static final int HDR_CONVERSION_UNSUPPORTED = 0;
    public static final int HDR_CONVERSION_PASSTHROUGH = 1;
    public static final int HDR_CONVERSION_SYSTEM = 2;
    public static final int HDR_CONVERSION_FORCE = 3;
    @NonNull
    public static final Parcelable.Creator<HdrConversionMode> CREATOR = new Parcelable.Creator<HdrConversionMode>(){

        @Override
        public HdrConversionMode createFromParcel(Parcel source) {
            return new HdrConversionMode(source);
        }

        public HdrConversionMode[] newArray(int size) {
            return new HdrConversionMode[size];
        }
    };
    private final int mConversionMode;
    private int mPreferredHdrOutputType;

    public HdrConversionMode(int conversionMode, int preferredHdrOutputType) {
        if ((conversionMode == 1 || conversionMode == 0) && preferredHdrOutputType != -1) {
            throw new IllegalArgumentException("preferredHdrOutputType must not be set if the conversion mode is " + HdrConversionMode.hdrConversionModeString(conversionMode));
        }
        this.mConversionMode = conversionMode;
        this.mPreferredHdrOutputType = preferredHdrOutputType;
    }

    public HdrConversionMode(int conversionMode) {
        this.mConversionMode = conversionMode;
        this.mPreferredHdrOutputType = -1;
    }

    private HdrConversionMode(Parcel source) {
        this(source.readInt(), source.readInt());
    }

    public int getConversionMode() {
        return this.mConversionMode;
    }

    public int getPreferredHdrOutputType() {
        return this.mPreferredHdrOutputType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mConversionMode);
        dest.writeInt(this.mPreferredHdrOutputType);
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof HdrConversionMode && this.equals((HdrConversionMode)o);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "HdrConversionMode{ConversionMode=" + HdrConversionMode.hdrConversionModeString(this.getConversionMode()) + ", PreferredHdrOutputType=" + Display.HdrCapabilities.hdrTypeToString(this.getPreferredHdrOutputType()) + "}";
    }

    private boolean equals(HdrConversionMode other) {
        return other != null && this.mConversionMode == other.getConversionMode() && this.mPreferredHdrOutputType == other.getPreferredHdrOutputType();
    }

    private static String hdrConversionModeString(int hdrConversionMode) {
        switch (hdrConversionMode) {
            case 1: {
                return "HDR_CONVERSION_PASSTHROUGH";
            }
            case 2: {
                return "HDR_CONVERSION_SYSTEM";
            }
            case 3: {
                return "HDR_CONVERSION_FORCE";
            }
        }
        return "HDR_CONVERSION_UNSUPPORTED";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConversionMode {
    }
}

