/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.graphics.RectF;
import android.hardware.display.DisplayTopology;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DisplayTopologyGraph {
    private final int mPrimaryDisplayId;
    private final DisplayNode[] mDisplayNodes;

    public DisplayTopologyGraph(int primaryDisplayId, DisplayNode[] displayNodes) {
        this.mPrimaryDisplayId = primaryDisplayId;
        this.mDisplayNodes = displayNodes;
    }

    public int getPrimaryDisplayId() {
        return this.mPrimaryDisplayId;
    }

    @NonNull
    public List<DisplayNode> getDisplayNodes() {
        return Arrays.asList(this.mDisplayNodes);
    }

    public static class DisplayNode {
        private final int mDisplayId;
        private final int mDensity;
        private final RectF mBoundsInGlobalDp;
        private final AdjacentDisplay[] mAdjacentDisplays;

        public DisplayNode(int displayId, int density, @NonNull RectF boundsInGlobalDp, AdjacentDisplay[] adjacentDisplays) {
            this.mDisplayId = displayId;
            this.mDensity = density;
            this.mBoundsInGlobalDp = boundsInGlobalDp;
            this.mAdjacentDisplays = adjacentDisplays;
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public int getDensity() {
            return this.mDensity;
        }

        @NonNull
        public RectF getBoundsInGlobalDp() {
            return this.mBoundsInGlobalDp;
        }

        @NonNull
        public List<AdjacentDisplay> getAdjacentDisplays() {
            return Arrays.asList(this.mAdjacentDisplays);
        }
    }

    public static class AdjacentDisplay {
        private final int mDisplayId;
        private final int mPosition;
        private final float mOffsetDp;

        public AdjacentDisplay(int displayId, int position, float offsetDp) {
            this.mDisplayId = displayId;
            this.mPosition = position;
            this.mOffsetDp = offsetDp;
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public int getPosition() {
            return this.mPosition;
        }

        public float getOffsetDp() {
            return this.mOffsetDp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdjacentDisplay rhs = (AdjacentDisplay)o;
            return this.mDisplayId == rhs.mDisplayId && this.mPosition == rhs.mPosition && this.mOffsetDp == rhs.mOffsetDp;
        }

        public int hashCode() {
            return Objects.hash(this.mDisplayId, this.mPosition, Float.valueOf(this.mOffsetDp));
        }

        public String toString() {
            return "AdjacentDisplay{displayId=" + this.mDisplayId + ", position=" + DisplayTopology.TreeNode.positionToString(this.mPosition) + ", offsetDp=" + this.mOffsetDp + '}';
        }
    }
}

