/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.PointF;
import android.graphics.RectF;
import android.hardware.display.DisplayTopologyGraph;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.IndentingPrintWriter;
import android.util.MathUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FlaggedApi(value="com.android.server.display.feature.flags.display_topology_api")
public class DisplayTopology
implements Parcelable {
    private static final String TAG = "DisplayTopology";
    private static final float EPSILON = 1.0E-4f;
    private static final float MAX_GAP = 5.0f;
    @NonNull
    public static final Parcelable.Creator<DisplayTopology> CREATOR = new Parcelable.Creator<DisplayTopology>(){

        @Override
        public DisplayTopology createFromParcel(Parcel source) {
            return new DisplayTopology(source);
        }

        public DisplayTopology[] newArray(int size) {
            return new DisplayTopology[size];
        }
    };
    @Nullable
    private TreeNode mRoot;
    private int mPrimaryDisplayId = -1;

    public static float pxToDp(float px, int dpi) {
        return px * 160.0f / (float)dpi;
    }

    public static float dpToPx(float dp, int dpi) {
        return dp * (float)dpi / 160.0f;
    }

    public DisplayTopology() {
    }

    public DisplayTopology(@Nullable TreeNode root, int primaryDisplayId) {
        this.mRoot = root;
        if (this.mRoot != null) {
            this.mRoot.mPosition = 0;
            this.mRoot.mOffset = 0.0f;
        }
        this.mPrimaryDisplayId = primaryDisplayId;
    }

    public DisplayTopology(Parcel source) {
        this(source.readTypedObject(TreeNode.CREATOR), source.readInt());
    }

    @Nullable
    public TreeNode getRoot() {
        return this.mRoot;
    }

    public int getPrimaryDisplayId() {
        return this.mPrimaryDisplayId;
    }

    public boolean isEmpty() {
        return this.mRoot == null;
    }

    public boolean hasMultipleDisplays() {
        return this.mRoot != null && this.mRoot.mChildren != null && !this.mRoot.mChildren.isEmpty();
    }

    public void addDisplay(int displayId, int logicalWidth, int logicalHeight, int logicalDensity) {
        if (DisplayTopology.findDisplay(displayId, this.mRoot) != null) {
            return;
        }
        if (this.mRoot == null) {
            this.mRoot = new TreeNode(displayId, logicalWidth, logicalHeight, logicalDensity, 0, 0.0f);
            this.mPrimaryDisplayId = displayId;
        } else if (this.mRoot.mChildren.isEmpty()) {
            float width = DisplayTopology.pxToDp(logicalWidth, logicalDensity);
            float offset = this.mRoot.getWidth() / 2.0f - width / 2.0f;
            TreeNode display = new TreeNode(displayId, logicalWidth, logicalHeight, logicalDensity, 1, offset);
            this.mRoot.mChildren.add(display);
        } else {
            TreeNode rightMostDisplay = (TreeNode)DisplayTopology.findRightMostDisplay((TreeNode)this.mRoot, (float)this.mRoot.getWidth()).first;
            TreeNode newDisplay = new TreeNode(displayId, logicalWidth, logicalHeight, logicalDensity, 2, 0.0f);
            rightMostDisplay.mChildren.add(newDisplay);
        }
    }

    public boolean updateDisplay(int displayId, int logicalWidth, int logicalHeight, int logicalDensity) {
        TreeNode display = DisplayTopology.findDisplay(displayId, this.mRoot);
        if (display == null) {
            return false;
        }
        if (display.mLogicalWidth == logicalWidth && display.mLogicalHeight == logicalHeight && display.mLogicalDensity == logicalDensity) {
            return false;
        }
        display.mLogicalWidth = logicalWidth;
        display.mLogicalHeight = logicalHeight;
        display.mLogicalDensity = logicalDensity;
        this.normalize();
        Slog.i(TAG, "Display with ID " + displayId + " updated, new logical width: " + logicalWidth + ", new logicalHeight: " + logicalHeight + ", new density: " + logicalDensity);
        return true;
    }

    public boolean removeDisplay(int displayId) {
        if (DisplayTopology.findDisplay(displayId, this.mRoot) == null) {
            return false;
        }
        ArrayDeque<TreeNode> queue = new ArrayDeque<TreeNode>();
        queue.add(this.mRoot);
        this.mRoot = null;
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.poll();
            if (node.mDisplayId != displayId) {
                this.addDisplay(node.mDisplayId, node.mLogicalWidth, node.mLogicalHeight, node.mLogicalDensity);
            }
            queue.addAll(node.mChildren);
        }
        if (this.mPrimaryDisplayId == displayId) {
            this.mPrimaryDisplayId = this.mRoot != null ? this.mRoot.mDisplayId : -1;
        }
        return true;
    }

    public void rearrange(Map<Integer, PointF> newPos) {
        if (this.mRoot == null) {
            return;
        }
        ArrayList<TreeNode> availableParents = new ArrayList<TreeNode>();
        availableParents.addLast(this.mRoot);
        Map<Integer, TreeNode> needsParent = this.allNodesIdMap();
        if (needsParent.size() != newPos.size()) {
            throw new IllegalArgumentException("newPos has wrong number of entries: " + newPos);
        }
        this.mRoot.mChildren.clear();
        for (TreeNode n : needsParent.values()) {
            n.mChildren.clear();
        }
        needsParent.remove(this.mRoot.mDisplayId);
        while (!needsParent.isEmpty()) {
            double bestDist = Double.POSITIVE_INFINITY;
            TreeNode bestChild = null;
            TreeNode bestParent = null;
            for (TreeNode child : needsParent.values()) {
                PointF childPos = newPos.get(child.mDisplayId);
                float childRight = childPos.x + child.getWidth();
                float childBottom = childPos.y + child.getHeight();
                for (TreeNode parent : availableParents) {
                    float offset;
                    int pos;
                    float yDeviation;
                    float xDeviation;
                    float yOverlap;
                    PointF parentPos = newPos.get(parent.mDisplayId);
                    float parentRight = parentPos.x + parent.getWidth();
                    float parentBottom = parentPos.y + parent.getHeight();
                    float xOverlap = Math.min(parentRight, childRight) - Math.max(parentPos.x, childPos.x);
                    if (xOverlap > (yOverlap = Math.min(parentBottom, childBottom) - Math.max(parentPos.y, childPos.y))) {
                        xDeviation = Math.min(xOverlap, 0.0f);
                        if (childPos.y < parentPos.y) {
                            yDeviation = childBottom - parentPos.y;
                            pos = 1;
                        } else {
                            yDeviation = parentBottom - childPos.y;
                            pos = 3;
                        }
                        offset = childPos.x - parentPos.x;
                    } else {
                        yDeviation = Math.min(yOverlap, 0.0f);
                        if (childPos.x < parentPos.x) {
                            xDeviation = childRight - parentPos.x;
                            pos = 0;
                        } else {
                            xDeviation = parentRight - childPos.x;
                            pos = 2;
                        }
                        offset = childPos.y - parentPos.y;
                    }
                    double dist = Math.hypot(xDeviation, yDeviation);
                    if (dist >= bestDist) continue;
                    bestDist = dist;
                    bestChild = child;
                    bestParent = parent;
                    bestChild.mPosition = pos;
                    bestChild.mOffset = offset;
                }
            }
            assert (bestParent != null & bestChild != null);
            bestParent.addChild(bestChild);
            if (null == needsParent.remove(bestChild.mDisplayId)) {
                throw new IllegalStateException("child not in pending set! " + bestChild);
            }
            availableParents.add(bestChild);
        }
        this.normalize();
    }

    public void normalize() {
        if (this.mRoot == null) {
            return;
        }
        this.clampOffsets(this.mRoot);
        List<NodeDerivedInfo> infoList = this.getInfo();
        Comparator comparator = (info1, info2) -> {
            if (info1 == info2) {
                return 0;
            }
            int compareDepths = Integer.compare(info1.depth, info2.depth);
            if (compareDepths != 0) {
                return compareDepths;
            }
            return Double.compare(Math.hypot(info1.left, info1.top), Math.hypot(info2.left, info2.top));
        };
        infoList.sort(comparator);
        for (int i = 1; i < infoList.size(); ++i) {
            boolean bl;
            boolean bl2;
            NodeDerivedInfo target = infoList.get(i);
            TreeNode targetDisplay = target.node;
            RectF targetBounds = target.absoluteBounds();
            NodeDerivedInfo lastIntersectingSourceDisplay = null;
            float lastOffsetX = 0.0f;
            float lastOffsetY = 0.0f;
            for (int j = 0; j < i; ++j) {
                float offsetY;
                NodeDerivedInfo source = infoList.get(j);
                RectF sourceBounds = source.absoluteBounds();
                if (!RectF.intersects(sourceBounds, targetBounds)) continue;
                float offsetX = targetBounds.left >= 0.0f ? sourceBounds.right - targetBounds.left : sourceBounds.left - targetBounds.right;
                float f = offsetY = targetBounds.top >= 0.0f ? sourceBounds.bottom - targetBounds.top : sourceBounds.top - targetBounds.bottom;
                if (Math.abs(offsetX) <= Math.abs(offsetY)) {
                    targetBounds.left += offsetX;
                    targetBounds.right += offsetX;
                    if (targetDisplay.mPosition == 1 || targetDisplay.mPosition == 3) {
                        targetDisplay.mOffset += offsetX;
                    }
                    offsetY = 0.0f;
                } else {
                    targetBounds.top += offsetY;
                    targetBounds.bottom += offsetY;
                    if (targetDisplay.mPosition == 0 || targetDisplay.mPosition == 2) {
                        targetDisplay.mOffset += offsetY;
                    }
                    offsetX = 0.0f;
                }
                lastIntersectingSourceDisplay = source;
                lastOffsetX = offsetX;
                lastOffsetY = offsetY;
            }
            if (lastIntersectingSourceDisplay == null) continue;
            NodeDerivedInfo parent = target.parent;
            RectF parentBounds = parent.absoluteBounds();
            if (parent == lastIntersectingSourceDisplay) continue;
            RectF childBounds = targetBounds;
            switch (targetDisplay.mPosition) {
                case 0: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.left, childBounds.right);
                    break;
                }
                case 2: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.right, childBounds.left);
                    break;
                }
                case 1: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.top, childBounds.bottom);
                    break;
                }
                case 3: {
                    bl2 = DisplayTopology.floatEquals(parentBounds.bottom, childBounds.top);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + targetDisplay.mPosition);
                }
            }
            boolean areTouching = bl2;
            switch (targetDisplay.mPosition) {
                case 0: 
                case 2: {
                    if (childBounds.bottom + 1.0E-4f > parentBounds.top && childBounds.top < parentBounds.bottom + 1.0E-4f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: 
                case 3: {
                    if (childBounds.right + 1.0E-4f > parentBounds.left && childBounds.left < parentBounds.right + 1.0E-4f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + targetDisplay.mPosition);
                }
            }
            if (areTouching &= bl) continue;
            parent.node.mChildren.remove(targetDisplay);
            RectF lastIntersectingSourceDisplayBounds = lastIntersectingSourceDisplay.absoluteBounds();
            lastIntersectingSourceDisplay.node.mChildren.add(targetDisplay);
            if (lastOffsetX != 0.0f) {
                targetDisplay.mPosition = lastOffsetX > 0.0f ? 2 : 0;
                targetDisplay.mOffset = childBounds.top - lastIntersectingSourceDisplayBounds.top;
                continue;
            }
            if (lastOffsetY == 0.0f) continue;
            targetDisplay.mPosition = lastOffsetY > 0.0f ? 3 : 1;
            targetDisplay.mOffset = childBounds.left - lastIntersectingSourceDisplayBounds.left;
        }
        Comparator idComparator = (d1, d2) -> Integer.compare(d1.mDisplayId, d2.mDisplayId);
        for (NodeDerivedInfo info : infoList) {
            info.node.mChildren.sort(idComparator);
        }
    }

    public DisplayTopology copy() {
        TreeNode rootCopy = this.mRoot == null ? null : this.mRoot.copy();
        return new DisplayTopology(rootCopy, this.mPrimaryDisplayId);
    }

    @com.android.layoutlib.androidx.annotation.NonNull
    public SparseArray<RectF> getAbsoluteBounds() {
        List<NodeDerivedInfo> infoList = this.getInfo();
        SparseArray<RectF> boundsById = new SparseArray<RectF>();
        for (NodeDerivedInfo info : infoList) {
            boundsById.append(info.node.mDisplayId, info.absoluteBounds());
        }
        return boundsById;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mRoot, flags);
        dest.writeInt(this.mPrimaryDisplayId);
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("DisplayTopology:");
        pw.println("--------------------");
        pw.increaseIndent();
        pw.println("mPrimaryDisplayId: " + this.mPrimaryDisplayId);
        pw.println("Topology tree:");
        if (this.mRoot != null) {
            pw.increaseIndent();
            this.mRoot.dump(pw);
            pw.decreaseIndent();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DisplayTopology)) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        this.dump(new IndentingPrintWriter(out));
        return ((Object)out).toString();
    }

    private static Pair<TreeNode, Float> findRightMostDisplay(TreeNode display, float xPos) {
        Pair<TreeNode, Float> result = new Pair<TreeNode, Float>(display, Float.valueOf(xPos));
        for (TreeNode child : display.mChildren) {
            float childXPos;
            switch (child.mPosition) {
                case 0: {
                    childXPos = xPos - display.getWidth();
                    break;
                }
                case 1: 
                case 3: {
                    childXPos = xPos - display.getWidth() + child.mOffset + child.getWidth();
                    break;
                }
                case 2: {
                    childXPos = xPos + child.getWidth();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + child.mPosition);
                }
            }
            Pair<TreeNode, Float> childResult = DisplayTopology.findRightMostDisplay(child, childXPos);
            if (!(((Float)childResult.second).floatValue() > ((Float)result.second).floatValue())) continue;
            result = new Pair<TreeNode, Float>((TreeNode)childResult.first, (Float)childResult.second);
        }
        return result;
    }

    @Nullable
    public static TreeNode findDisplay(int displayId, @Nullable TreeNode startingNode) {
        if (startingNode == null) {
            return null;
        }
        if (startingNode.mDisplayId == displayId) {
            return startingNode;
        }
        for (TreeNode child : startingNode.mChildren) {
            TreeNode display = DisplayTopology.findDisplay(displayId, child);
            if (display == null) continue;
            return display;
        }
        return null;
    }

    private List<NodeDerivedInfo> getInfo() {
        ArrayList<NodeDerivedInfo> info = new ArrayList<NodeDerivedInfo>();
        if (this.mRoot != null) {
            NodeDerivedInfo rootInfo = new NodeDerivedInfo(this.mRoot, 0.0f, 0.0f, null, 0);
            DisplayTopology.getSubTreeInfo(info, rootInfo);
        }
        return info;
    }

    private static void getSubTreeInfo(List<NodeDerivedInfo> info, NodeDerivedInfo startNode) {
        info.add(startNode);
        for (TreeNode child : startNode.node.mChildren) {
            float f;
            float f2;
            switch (child.mPosition) {
                case 0: {
                    f2 = -child.getWidth();
                    break;
                }
                case 2: {
                    f2 = startNode.node.getWidth();
                    break;
                }
                default: {
                    f2 = child.mOffset;
                }
            }
            float xDiff = f2;
            switch (child.mPosition) {
                case 1: {
                    f = -child.getHeight();
                    break;
                }
                case 3: {
                    f = startNode.node.getHeight();
                    break;
                }
                default: {
                    f = child.mOffset;
                }
            }
            float yDiff = f;
            NodeDerivedInfo childInfo = new NodeDerivedInfo(child, startNode.left + xDiff, startNode.top + yDiff, startNode, startNode.depth + 1);
            DisplayTopology.getSubTreeInfo(info, childInfo);
        }
    }

    private List<Pair<Integer, Float>> findDisplayPlacements(RectF bounds1, RectF bounds2) {
        ArrayList<Pair<Integer, Float>> placements = new ArrayList<Pair<Integer, Float>>();
        if (bounds1.top <= bounds2.bottom + 5.0f && bounds2.top <= bounds1.bottom + 5.0f) {
            if (MathUtils.abs(bounds1.left - bounds2.right) <= 5.0f) {
                placements.add(new Pair<Integer, Float>(0, Float.valueOf(bounds2.top - bounds1.top)));
            }
            if (MathUtils.abs(bounds1.right - bounds2.left) <= 5.0f) {
                placements.add(new Pair<Integer, Float>(2, Float.valueOf(bounds2.top - bounds1.top)));
            }
        }
        if (bounds1.left <= bounds2.right + 5.0f && bounds2.left <= bounds1.right + 5.0f) {
            if (MathUtils.abs(bounds1.top - bounds2.bottom) < 5.0f) {
                placements.add(new Pair<Integer, Float>(1, Float.valueOf(bounds2.left - bounds1.left)));
            }
            if (MathUtils.abs(bounds1.bottom - bounds2.top) < 5.0f) {
                placements.add(new Pair<Integer, Float>(3, Float.valueOf(bounds2.left - bounds1.left)));
            }
        }
        return placements;
    }

    public DisplayTopologyGraph getGraph() {
        int i;
        List<NodeDerivedInfo> infoList = this.getInfo();
        Comparator byPosition = (display1, display2) -> {
            int compareX = Float.compare(display1.left, display2.left);
            if (compareX != 0) {
                return compareX;
            }
            return Float.compare(display1.top, display2.top);
        };
        infoList.sort(byPosition);
        List[] adjacentDisplays = new List[infoList.size()];
        for (i = 0; i < infoList.size(); ++i) {
            adjacentDisplays[i] = new ArrayList(Math.min(10, infoList.size()));
        }
        block1: for (i = 0; i < infoList.size(); ++i) {
            int displayId1 = infoList.get((int)i).node.mDisplayId;
            RectF bounds1 = infoList.get(i).absoluteBounds();
            List adjacentDisplays1 = adjacentDisplays[i];
            for (int j = i + 1; j < infoList.size(); ++j) {
                int displayId2 = infoList.get((int)j).node.mDisplayId;
                RectF bounds2 = infoList.get(j).absoluteBounds();
                List adjacentDisplays2 = adjacentDisplays[j];
                List<Pair<Integer, Float>> placements1 = this.findDisplayPlacements(bounds1, bounds2);
                List<Pair<Integer, Float>> placements2 = this.findDisplayPlacements(bounds2, bounds1);
                for (Pair<Integer, Float> placement : placements1) {
                    adjacentDisplays1.add(new DisplayTopologyGraph.AdjacentDisplay(displayId2, (Integer)placement.first, ((Float)placement.second).floatValue()));
                }
                for (Pair<Integer, Float> placement : placements2) {
                    adjacentDisplays2.add(new DisplayTopologyGraph.AdjacentDisplay(displayId1, (Integer)placement.first, ((Float)placement.second).floatValue()));
                }
                if (bounds2.left >= bounds1.right + 1.0E-4f) continue block1;
            }
        }
        DisplayTopologyGraph.DisplayNode[] nodes = new DisplayTopologyGraph.DisplayNode[infoList.size()];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            NodeDerivedInfo nodeDerivedInfo = infoList.get(i2);
            nodes[i2] = new DisplayTopologyGraph.DisplayNode(nodeDerivedInfo.node.mDisplayId, nodeDerivedInfo.node.mLogicalDensity, nodeDerivedInfo.absoluteBounds(), adjacentDisplays[i2].toArray(new DisplayTopologyGraph.AdjacentDisplay[0]));
        }
        return new DisplayTopologyGraph(this.mPrimaryDisplayId, nodes);
    }

    private static boolean floatEquals(float a, float b) {
        return a == b || Float.isNaN(a) && Float.isNaN(b) || Math.abs(a - b) < 1.0E-4f;
    }

    @com.android.layoutlib.androidx.annotation.NonNull
    public Map<Integer, TreeNode> allNodesIdMap() {
        HashMap<Integer, TreeNode> found = new HashMap<Integer, TreeNode>();
        if (this.mRoot == null) {
            return found;
        }
        ArrayDeque<TreeNode> pend = new ArrayDeque<TreeNode>();
        pend.push(this.mRoot);
        do {
            TreeNode node = (TreeNode)pend.pop();
            found.put(node.mDisplayId, node);
            pend.addAll(node.mChildren);
        } while (!pend.isEmpty());
        return found;
    }

    private void clampOffsets(@Nullable TreeNode display) {
        if (display == null) {
            return;
        }
        for (TreeNode child : display.mChildren) {
            if (child.mPosition == 0 || child.mPosition == 2) {
                child.mOffset = MathUtils.constrain(child.mOffset, -child.getHeight(), display.getHeight());
            } else if (child.mPosition == 1 || child.mPosition == 3) {
                child.mOffset = MathUtils.constrain(child.mOffset, -child.getWidth(), display.getWidth());
            }
            this.clampOffsets(child);
        }
    }

    public static class TreeNode
    implements Parcelable {
        public static final int POSITION_LEFT = 0;
        public static final int POSITION_TOP = 1;
        public static final int POSITION_RIGHT = 2;
        public static final int POSITION_BOTTOM = 3;
        @NonNull
        public static final Parcelable.Creator<TreeNode> CREATOR = new Parcelable.Creator<TreeNode>(){

            @Override
            public TreeNode createFromParcel(Parcel source) {
                return new TreeNode(source);
            }

            public TreeNode[] newArray(int size) {
                return new TreeNode[size];
            }
        };
        private final int mDisplayId;
        private int mLogicalWidth;
        private int mLogicalHeight;
        private int mLogicalDensity;
        private int mPosition;
        private float mOffset;
        private final List<TreeNode> mChildren;

        @VisibleForTesting
        public TreeNode(int displayId, int logicalWidth, int logicalHeight, int logicalDensity, int position, float offset) {
            this(displayId, logicalWidth, logicalHeight, logicalDensity, position, offset, List.of());
        }

        public TreeNode(int displayId, int logicalWidth, int logicalHeight, int logicalDensity, int position, float offset, List<TreeNode> children) {
            this.mDisplayId = displayId;
            this.mLogicalWidth = logicalWidth;
            this.mLogicalHeight = logicalHeight;
            this.mLogicalDensity = logicalDensity;
            this.mPosition = position;
            this.mOffset = offset;
            this.mChildren = new ArrayList<TreeNode>(children);
        }

        public TreeNode(Parcel source) {
            this(source.readInt(), source.readInt(), source.readInt(), source.readInt(), source.readInt(), source.readFloat());
            source.readTypedList(this.mChildren, CREATOR);
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        public float getWidth() {
            return DisplayTopology.pxToDp(this.mLogicalWidth, this.mLogicalDensity);
        }

        public float getHeight() {
            return DisplayTopology.pxToDp(this.mLogicalHeight, this.mLogicalDensity);
        }

        public int getLogicalWidth() {
            return this.mLogicalWidth;
        }

        public int getLogicalHeight() {
            return this.mLogicalHeight;
        }

        public int getLogicalDensity() {
            return this.mLogicalDensity;
        }

        public int getPosition() {
            return this.mPosition;
        }

        public float getOffset() {
            return this.mOffset;
        }

        public List<TreeNode> getChildren() {
            return Collections.unmodifiableList(this.mChildren);
        }

        public TreeNode copy() {
            TreeNode copy = new TreeNode(this.mDisplayId, this.mLogicalWidth, this.mLogicalHeight, this.mLogicalDensity, this.mPosition, this.mOffset);
            for (TreeNode child : this.mChildren) {
                copy.mChildren.add(child.copy());
            }
            return copy;
        }

        public String toString() {
            return "Display {id=" + this.mDisplayId + ", logical width=" + this.mLogicalWidth + ", logical height=" + this.mLogicalHeight + ", logical density=" + this.mLogicalDensity + ", position=" + TreeNode.positionToString(this.mPosition) + ", offset=" + this.mOffset + "}";
        }

        public static String positionToString(int position) {
            String string2;
            switch (position) {
                case 0: {
                    string2 = "left";
                    break;
                }
                case 1: {
                    string2 = "top";
                    break;
                }
                case 2: {
                    string2 = "right";
                    break;
                }
                case 3: {
                    string2 = "bottom";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + position);
                }
            }
            return string2;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
            dest.writeInt(this.mDisplayId);
            dest.writeInt(this.mLogicalWidth);
            dest.writeInt(this.mLogicalHeight);
            dest.writeInt(this.mLogicalDensity);
            dest.writeInt(this.mPosition);
            dest.writeFloat(this.mOffset);
            dest.writeTypedList(this.mChildren);
        }

        public void dump(IndentingPrintWriter ipw) {
            ipw.println(this);
            ipw.increaseIndent();
            for (TreeNode child : this.mChildren) {
                child.dump(ipw);
            }
            ipw.decreaseIndent();
        }

        @VisibleForTesting
        public void addChild(TreeNode child) {
            this.mChildren.add(child);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Position {
        }
    }

    private static class NodeDerivedInfo
    extends Record {
        private final TreeNode node;
        private final float left;
        private final float top;
        @Nullable
        private final NodeDerivedInfo parent;
        private final int depth;

        private NodeDerivedInfo(TreeNode node, float left, float top, @Nullable NodeDerivedInfo parent, int depth) {
            this.node = node;
            this.left = left;
            this.top = top;
            this.parent = parent;
            this.depth = depth;
        }

        RectF absoluteBounds() {
            return new RectF(this.left, this.top, this.left + this.node.getWidth(), this.top + this.node.getHeight());
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NodeDerivedInfo.class, "node;left;top;parent;depth", "node", "left", "top", "parent", "depth"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NodeDerivedInfo.class, "node;left;top;parent;depth", "node", "left", "top", "parent", "depth"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NodeDerivedInfo.class, "node;left;top;parent;depth", "node", "left", "top", "parent", "depth"}, this, o);
        }

        public TreeNode node() {
            return this.node;
        }

        public float left() {
            return this.left;
        }

        public float top() {
            return this.top;
        }

        @Nullable
        public NodeDerivedInfo parent() {
            return this.parent;
        }

        public int depth() {
            return this.depth;
        }
    }
}

