/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.devicestate.DeviceState;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;

public class DeviceStateInfo
implements Parcelable {
    public static final int CHANGED_SUPPORTED_STATES = 1;
    public static final int CHANGED_BASE_STATE = 2;
    public static final int CHANGED_CURRENT_STATE = 4;
    @NonNull
    public final ArrayList<DeviceState> supportedStates;
    @NonNull
    public final DeviceState baseState;
    @NonNull
    public final DeviceState currentState;
    @NonNull
    public static final Parcelable.Creator<DeviceStateInfo> CREATOR = new Parcelable.Creator<DeviceStateInfo>(){

        @Override
        public DeviceStateInfo createFromParcel(@NonNull Parcel in) {
            return new DeviceStateInfo(in);
        }

        public DeviceStateInfo[] newArray(int size) {
            return new DeviceStateInfo[size];
        }
    };

    public DeviceStateInfo(@NonNull ArrayList<DeviceState> supportedStates, @NonNull DeviceState baseState, @NonNull DeviceState state) {
        this.supportedStates = supportedStates;
        this.baseState = baseState;
        this.currentState = state;
    }

    public DeviceStateInfo(@NonNull DeviceStateInfo info) {
        this(new ArrayList<DeviceState>(info.supportedStates), info.baseState, info.currentState);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DeviceStateInfo that = (DeviceStateInfo)other;
        return this.baseState.equals(that.baseState) && this.currentState.equals(that.currentState) && Objects.equals(this.supportedStates, that.supportedStates);
    }

    public int hashCode() {
        int result = Objects.hash(this.baseState, this.currentState);
        result = 31 * result + this.supportedStates.hashCode();
        return result;
    }

    public int diff(@NonNull DeviceStateInfo other) {
        int diff = 0;
        if (!this.supportedStates.equals(other.supportedStates)) {
            diff |= 1;
        }
        if (!this.baseState.equals(other.baseState)) {
            diff |= 2;
        }
        if (!this.currentState.equals(other.currentState)) {
            diff |= 4;
        }
        return diff;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.supportedStates.size());
        for (int i = 0; i < this.supportedStates.size(); ++i) {
            dest.writeTypedObject(this.supportedStates.get(i).getConfiguration(), flags);
        }
        dest.writeTypedObject(this.baseState.getConfiguration(), flags);
        dest.writeTypedObject(this.currentState.getConfiguration(), flags);
    }

    private DeviceStateInfo(@NonNull Parcel in) {
        int numberOfSupportedStates = in.readInt();
        ArrayList<DeviceState> supportedStates = new ArrayList<DeviceState>(numberOfSupportedStates);
        for (int i = 0; i < numberOfSupportedStates; ++i) {
            DeviceState.Configuration configuration = Objects.requireNonNull(in.readTypedObject(DeviceState.Configuration.CREATOR));
            supportedStates.add(i, new DeviceState(configuration));
        }
        this.supportedStates = supportedStates;
        this.baseState = new DeviceState(Objects.requireNonNull(in.readTypedObject(DeviceState.Configuration.CREATOR)));
        this.currentState = new DeviceState(Objects.requireNonNull(in.readTypedObject(DeviceState.Configuration.CREATOR)));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChangeFlags {
    }
}

