/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.cas;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICasListener
extends IInterface {
    public static final int VERSION = 1;
    public static final String HASH = "bc51d8d70a55ec4723d3f73d0acf7003306bf69f";
    public static final String DESCRIPTOR = "android$hardware$cas$ICasListener".replace('$', '.');

    public void onEvent(int var1, int var2, byte[] var3) throws RemoteException;

    public void onSessionEvent(byte[] var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void onStatusUpdate(byte var1, int var2) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICasListener {
        static final int TRANSACTION_onEvent = 1;
        static final int TRANSACTION_onSessionEvent = 2;
        static final int TRANSACTION_onStatusUpdate = 3;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICasListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICasListener) {
                return (ICasListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            if (code == 0xFFFFFF) {
                reply.writeNoException();
                reply.writeInt(this.getInterfaceVersion());
                return true;
            }
            if (code == 0xFFFFFE) {
                reply.writeNoException();
                reply.writeString(this.getInterfaceHash());
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onSessionEvent(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    byte _arg0 = data.readByte();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStatusUpdate(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements ICasListener {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(int event, int arg, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(event);
                    _data.writeInt(arg);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onEvent is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionEvent(byte[] sessionId, int event, int arg, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(sessionId);
                    _data.writeInt(event);
                    _data.writeInt(arg);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onSessionEvent is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusUpdate(byte event, int number) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByte(event);
                    _data.writeInt(number);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onStatusUpdate is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements ICasListener {
        @Override
        public void onEvent(int event, int arg, byte[] data) throws RemoteException {
        }

        @Override
        public void onSessionEvent(byte[] sessionId, int event, int arg, byte[] data) throws RemoteException {
        }

        @Override
        public void onStatusUpdate(byte event, int number) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

