/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.ImageReader;
import android.media.MediaCodec;
import android.media.MediaRecorder;
import android.renderscript.Allocation;
import android.util.Range;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.hidden_from_bootclasspath.com.android.internal.camera.flags.Flags;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

public class StreamConfigurationMap {
    private static final String TAG = "StreamConfigurationMap";
    private static final int MAX_DIMEN_FOR_ROUNDING = 1920;
    private static final int HAL_PIXEL_FORMAT_RGBA_8888 = 1;
    private static final int HAL_PIXEL_FORMAT_RGBX_8888 = 2;
    private static final int HAL_PIXEL_FORMAT_RGB_888 = 3;
    private static final int HAL_PIXEL_FORMAT_RGB_565 = 4;
    private static final int HAL_PIXEL_FORMAT_YCBCR_422_SP = 16;
    private static final int HAL_PIXEL_FORMAT_YCRCB_420_SP = 17;
    private static final int HAL_PIXEL_FORMAT_YCBCR_422_I = 20;
    private static final int HAL_PIXEL_FORMAT_RAW16 = 32;
    public static final int HAL_PIXEL_FORMAT_BLOB = 33;
    private static final int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private static final int HAL_PIXEL_FORMAT_YCBCR_420_888 = 35;
    private static final int HAL_PIXEL_FORMAT_RAW_OPAQUE = 36;
    private static final int HAL_PIXEL_FORMAT_RAW10 = 37;
    private static final int HAL_PIXEL_FORMAT_RAW12 = 38;
    private static final int HAL_PIXEL_FORMAT_YCBCR_P010 = 54;
    private static final int HAL_PIXEL_FORMAT_YCBCR_P210 = 60;
    private static final int HAL_PIXEL_FORMAT_Y8 = 538982489;
    private static final int HAL_PIXEL_FORMAT_Y16 = 540422489;
    private static final int HAL_PIXEL_FORMAT_YV12 = 842094169;
    private static final int HAL_DATASPACE_STANDARD_SHIFT = 16;
    private static final int HAL_DATASPACE_TRANSFER_SHIFT = 22;
    private static final int HAL_DATASPACE_RANGE_SHIFT = 27;
    private static final int HAL_DATASPACE_UNKNOWN = 0;
    public static final int HAL_DATASPACE_ARBITRARY = 1;
    public static final int HAL_DATASPACE_V0_JFIF = 146931712;
    public static final int HAL_DATASPACE_DEPTH = 4096;
    public static final int HAL_DATASPACE_DYNAMIC_DEPTH = 4098;
    public static final int HAL_DATASPACE_HEIF = 4100;
    public static final int HAL_DATASPACE_JPEG_R = 4101;
    public static final int HAL_DATASPACE_JFIF = 146931712;
    private static final long DURATION_20FPS_NS = 50000000L;
    private static final int DURATION_MIN_FRAME = 0;
    private static final int DURATION_STALL = 1;
    private final StreamConfiguration[] mConfigurations;
    private final StreamConfigurationDuration[] mMinFrameDurations;
    private final StreamConfigurationDuration[] mStallDurations;
    private final StreamConfiguration[] mDepthConfigurations;
    private final StreamConfigurationDuration[] mDepthMinFrameDurations;
    private final StreamConfigurationDuration[] mDepthStallDurations;
    private final StreamConfiguration[] mDynamicDepthConfigurations;
    private final StreamConfigurationDuration[] mDynamicDepthMinFrameDurations;
    private final StreamConfigurationDuration[] mDynamicDepthStallDurations;
    private final StreamConfiguration[] mHeicConfigurations;
    private final StreamConfigurationDuration[] mHeicMinFrameDurations;
    private final StreamConfigurationDuration[] mHeicStallDurations;
    private final StreamConfiguration[] mHeicUltraHDRConfigurations;
    private final StreamConfigurationDuration[] mHeicUltraHDRMinFrameDurations;
    private final StreamConfigurationDuration[] mHeicUltraHDRStallDurations;
    private final StreamConfiguration[] mJpegRConfigurations;
    private final StreamConfigurationDuration[] mJpegRMinFrameDurations;
    private final StreamConfigurationDuration[] mJpegRStallDurations;
    private final HighSpeedVideoConfiguration[] mHighSpeedVideoConfigurations;
    private final ReprocessFormatsMap mInputOutputFormatsMap;
    private final boolean mListHighResolution;
    private final SparseIntArray mOutputFormats = new SparseIntArray();
    private final SparseIntArray mHighResOutputFormats = new SparseIntArray();
    private final SparseIntArray mAllOutputFormats = new SparseIntArray();
    private final SparseIntArray mInputFormats = new SparseIntArray();
    private final SparseIntArray mDepthOutputFormats = new SparseIntArray();
    private final SparseIntArray mDynamicDepthOutputFormats = new SparseIntArray();
    private final SparseIntArray mHeicOutputFormats = new SparseIntArray();
    private final SparseIntArray mHeicUltraHDROutputFormats = new SparseIntArray();
    private final SparseIntArray mJpegROutputFormats = new SparseIntArray();
    private final HashMap<Size, Integer> mHighSpeedVideoSizeMap = new HashMap();
    private final HashMap<Range<Integer>, Integer> mHighSpeedVideoFpsRangeMap = new HashMap();

    public StreamConfigurationMap(StreamConfiguration[] configurations, StreamConfigurationDuration[] minFrameDurations, StreamConfigurationDuration[] stallDurations, StreamConfiguration[] depthConfigurations, StreamConfigurationDuration[] depthMinFrameDurations, StreamConfigurationDuration[] depthStallDurations, StreamConfiguration[] dynamicDepthConfigurations, StreamConfigurationDuration[] dynamicDepthMinFrameDurations, StreamConfigurationDuration[] dynamicDepthStallDurations, StreamConfiguration[] heicConfigurations, StreamConfigurationDuration[] heicMinFrameDurations, StreamConfigurationDuration[] heicStallDurations, StreamConfiguration[] jpegRConfigurations, StreamConfigurationDuration[] jpegRMinFrameDurations, StreamConfigurationDuration[] jpegRStallDurations, StreamConfiguration[] heicUltraHDRConfigurations, StreamConfigurationDuration[] heicUltraHDRMinFrameDurations, StreamConfigurationDuration[] heicUltraHDRStallDurations, HighSpeedVideoConfiguration[] highSpeedVideoConfigurations, ReprocessFormatsMap inputOutputFormatsMap, boolean listHighResolution) {
        this(configurations, minFrameDurations, stallDurations, depthConfigurations, depthMinFrameDurations, depthStallDurations, dynamicDepthConfigurations, dynamicDepthMinFrameDurations, dynamicDepthStallDurations, heicConfigurations, heicMinFrameDurations, heicStallDurations, jpegRConfigurations, jpegRMinFrameDurations, jpegRStallDurations, heicUltraHDRConfigurations, heicUltraHDRMinFrameDurations, heicUltraHDRStallDurations, highSpeedVideoConfigurations, inputOutputFormatsMap, listHighResolution, true);
    }

    public StreamConfigurationMap(StreamConfiguration[] configurations, StreamConfigurationDuration[] minFrameDurations, StreamConfigurationDuration[] stallDurations, StreamConfiguration[] depthConfigurations, StreamConfigurationDuration[] depthMinFrameDurations, StreamConfigurationDuration[] depthStallDurations, StreamConfiguration[] dynamicDepthConfigurations, StreamConfigurationDuration[] dynamicDepthMinFrameDurations, StreamConfigurationDuration[] dynamicDepthStallDurations, StreamConfiguration[] heicConfigurations, StreamConfigurationDuration[] heicMinFrameDurations, StreamConfigurationDuration[] heicStallDurations, StreamConfiguration[] jpegRConfigurations, StreamConfigurationDuration[] jpegRMinFrameDurations, StreamConfigurationDuration[] jpegRStallDurations, StreamConfiguration[] heicUltraHDRConfigurations, StreamConfigurationDuration[] heicUltraHDRMinFrameDurations, StreamConfigurationDuration[] heicUltraHDRStallDurations, HighSpeedVideoConfiguration[] highSpeedVideoConfigurations, ReprocessFormatsMap inputOutputFormatsMap, boolean listHighResolution, boolean enforceImplementationDefined) {
        if (configurations == null && depthConfigurations == null && heicConfigurations == null) {
            throw new NullPointerException("At least one of color/depth/heic configurations must not be null");
        }
        if (configurations == null) {
            this.mConfigurations = new StreamConfiguration[0];
            this.mMinFrameDurations = new StreamConfigurationDuration[0];
            this.mStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mConfigurations = Preconditions.checkArrayElementsNotNull(configurations, "configurations");
            this.mMinFrameDurations = Preconditions.checkArrayElementsNotNull(minFrameDurations, "minFrameDurations");
            this.mStallDurations = Preconditions.checkArrayElementsNotNull(stallDurations, "stallDurations");
        }
        this.mListHighResolution = listHighResolution;
        if (depthConfigurations == null) {
            this.mDepthConfigurations = new StreamConfiguration[0];
            this.mDepthMinFrameDurations = new StreamConfigurationDuration[0];
            this.mDepthStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mDepthConfigurations = Preconditions.checkArrayElementsNotNull(depthConfigurations, "depthConfigurations");
            this.mDepthMinFrameDurations = Preconditions.checkArrayElementsNotNull(depthMinFrameDurations, "depthMinFrameDurations");
            this.mDepthStallDurations = Preconditions.checkArrayElementsNotNull(depthStallDurations, "depthStallDurations");
        }
        if (dynamicDepthConfigurations == null) {
            this.mDynamicDepthConfigurations = new StreamConfiguration[0];
            this.mDynamicDepthMinFrameDurations = new StreamConfigurationDuration[0];
            this.mDynamicDepthStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mDynamicDepthConfigurations = Preconditions.checkArrayElementsNotNull(dynamicDepthConfigurations, "dynamicDepthConfigurations");
            this.mDynamicDepthMinFrameDurations = Preconditions.checkArrayElementsNotNull(dynamicDepthMinFrameDurations, "dynamicDepthMinFrameDurations");
            this.mDynamicDepthStallDurations = Preconditions.checkArrayElementsNotNull(dynamicDepthStallDurations, "dynamicDepthStallDurations");
        }
        if (heicConfigurations == null) {
            this.mHeicConfigurations = new StreamConfiguration[0];
            this.mHeicMinFrameDurations = new StreamConfigurationDuration[0];
            this.mHeicStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mHeicConfigurations = Preconditions.checkArrayElementsNotNull(heicConfigurations, "heicConfigurations");
            this.mHeicMinFrameDurations = Preconditions.checkArrayElementsNotNull(heicMinFrameDurations, "heicMinFrameDurations");
            this.mHeicStallDurations = Preconditions.checkArrayElementsNotNull(heicStallDurations, "heicStallDurations");
        }
        if (heicUltraHDRConfigurations == null || !Flags.cameraHeifGainmap()) {
            this.mHeicUltraHDRConfigurations = new StreamConfiguration[0];
            this.mHeicUltraHDRMinFrameDurations = new StreamConfigurationDuration[0];
            this.mHeicUltraHDRStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mHeicUltraHDRConfigurations = Preconditions.checkArrayElementsNotNull(heicUltraHDRConfigurations, "heicUltraHDRConfigurations");
            this.mHeicUltraHDRMinFrameDurations = Preconditions.checkArrayElementsNotNull(heicUltraHDRMinFrameDurations, "heicUltraHDRMinFrameDurations");
            this.mHeicUltraHDRStallDurations = Preconditions.checkArrayElementsNotNull(heicUltraHDRStallDurations, "heicUltraHDRStallDurations");
        }
        if (jpegRConfigurations == null) {
            this.mJpegRConfigurations = new StreamConfiguration[0];
            this.mJpegRMinFrameDurations = new StreamConfigurationDuration[0];
            this.mJpegRStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mJpegRConfigurations = Preconditions.checkArrayElementsNotNull(jpegRConfigurations, "jpegRConfigurations");
            this.mJpegRMinFrameDurations = Preconditions.checkArrayElementsNotNull(jpegRMinFrameDurations, "jpegRFrameDurations");
            this.mJpegRStallDurations = Preconditions.checkArrayElementsNotNull(jpegRStallDurations, "jpegRStallDurations");
        }
        this.mHighSpeedVideoConfigurations = highSpeedVideoConfigurations == null ? new HighSpeedVideoConfiguration[0] : Preconditions.checkArrayElementsNotNull(highSpeedVideoConfigurations, "highSpeedVideoConfigurations");
        for (StreamConfiguration streamConfiguration : this.mConfigurations) {
            int fmt = streamConfiguration.getFormat();
            SparseIntArray map = null;
            if (streamConfiguration.isOutput()) {
                this.mAllOutputFormats.put(fmt, this.mAllOutputFormats.get(fmt) + 1);
                long duration = 0L;
                if (this.mListHighResolution) {
                    for (StreamConfigurationDuration configurationDuration : this.mMinFrameDurations) {
                        if (configurationDuration.getFormat() != fmt || configurationDuration.getWidth() != streamConfiguration.getSize().getWidth() || configurationDuration.getHeight() != streamConfiguration.getSize().getHeight()) continue;
                        duration = configurationDuration.getDuration();
                        break;
                    }
                }
                map = duration <= 50000000L ? this.mOutputFormats : this.mHighResOutputFormats;
            } else {
                map = this.mInputFormats;
            }
            map.put(fmt, map.get(fmt) + 1);
        }
        for (StreamConfiguration streamConfiguration : this.mDepthConfigurations) {
            if (!streamConfiguration.isOutput()) continue;
            this.mDepthOutputFormats.put(streamConfiguration.getFormat(), this.mDepthOutputFormats.get(streamConfiguration.getFormat()) + 1);
        }
        for (StreamConfiguration streamConfiguration : this.mDynamicDepthConfigurations) {
            if (!streamConfiguration.isOutput()) continue;
            this.mDynamicDepthOutputFormats.put(streamConfiguration.getFormat(), this.mDynamicDepthOutputFormats.get(streamConfiguration.getFormat()) + 1);
        }
        for (StreamConfiguration streamConfiguration : this.mHeicConfigurations) {
            if (!streamConfiguration.isOutput()) continue;
            this.mHeicOutputFormats.put(streamConfiguration.getFormat(), this.mHeicOutputFormats.get(streamConfiguration.getFormat()) + 1);
        }
        if (Flags.cameraHeifGainmap()) {
            for (StreamConfiguration streamConfiguration : this.mHeicUltraHDRConfigurations) {
                if (!streamConfiguration.isOutput()) continue;
                this.mHeicUltraHDROutputFormats.put(streamConfiguration.getFormat(), this.mHeicUltraHDROutputFormats.get(streamConfiguration.getFormat()) + 1);
            }
        }
        for (StreamConfiguration streamConfiguration : this.mJpegRConfigurations) {
            if (!streamConfiguration.isOutput()) continue;
            this.mJpegROutputFormats.put(streamConfiguration.getFormat(), this.mJpegROutputFormats.get(streamConfiguration.getFormat()) + 1);
        }
        if (configurations != null && enforceImplementationDefined && this.mOutputFormats.indexOfKey(34) < 0) {
            throw new AssertionError((Object)"At least one stream configuration for IMPLEMENTATION_DEFINED must exist");
        }
        for (HighSpeedVideoConfiguration highSpeedVideoConfiguration : this.mHighSpeedVideoConfigurations) {
            Size size = highSpeedVideoConfiguration.getSize();
            Range<Integer> fpsRange = highSpeedVideoConfiguration.getFpsRange();
            Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
            if (fpsRangeCount == null) {
                fpsRangeCount = 0;
            }
            this.mHighSpeedVideoSizeMap.put(size, fpsRangeCount + 1);
            Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
            if (sizeCount == null) {
                sizeCount = 0;
            }
            this.mHighSpeedVideoFpsRangeMap.put(fpsRange, sizeCount + 1);
        }
        this.mInputOutputFormatsMap = inputOutputFormatsMap;
    }

    public int[] getOutputFormats() {
        return this.getPublicFormats(true);
    }

    public int[] getValidOutputFormatsForInput(int inputFormat) {
        if (this.mInputOutputFormatsMap == null) {
            return new int[0];
        }
        int[] outputs = this.mInputOutputFormatsMap.getOutputs(inputFormat);
        if (this.mHeicOutputFormats.size() > 0) {
            int[] outputsWithHeic = Arrays.copyOf(outputs, outputs.length + 1);
            outputsWithHeic[outputs.length] = 1212500294;
            return outputsWithHeic;
        }
        return outputs;
    }

    public int[] getInputFormats() {
        return this.getPublicFormats(false);
    }

    public Size[] getInputSizes(int format) {
        return this.getPublicFormatSizes(format, false, false);
    }

    public boolean isOutputSupportedFor(int format) {
        StreamConfigurationMap.checkArgumentFormat(format);
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        int dataspace = StreamConfigurationMap.imageFormatToDataspace(format);
        if (Flags.cameraHeifGainmap() && dataspace == 4102) {
            return this.mHeicUltraHDROutputFormats.indexOfKey(internalFormat) >= 0;
        }
        if (dataspace == 4096) {
            return this.mDepthOutputFormats.indexOfKey(internalFormat) >= 0;
        }
        if (dataspace == 4098) {
            return this.mDynamicDepthOutputFormats.indexOfKey(internalFormat) >= 0;
        }
        if (dataspace == 4100) {
            return this.mHeicOutputFormats.indexOfKey(internalFormat) >= 0;
        }
        if (dataspace == 4101) {
            return this.mJpegROutputFormats.indexOfKey(internalFormat) >= 0;
        }
        return this.getFormatsMap(true).indexOfKey(internalFormat) >= 0;
    }

    public static <T> boolean isOutputSupportedFor(Class<T> klass) {
        Objects.requireNonNull(klass, "klass must not be null");
        if (klass == ImageReader.class) {
            return true;
        }
        if (klass == MediaRecorder.class) {
            return true;
        }
        if (klass == MediaCodec.class) {
            return true;
        }
        if (klass == Allocation.class) {
            return true;
        }
        if (klass == SurfaceHolder.class) {
            return true;
        }
        return klass == SurfaceTexture.class;
    }

    public boolean isOutputSupportedFor(Surface surface) {
        StreamConfiguration[] configs;
        Objects.requireNonNull(surface, "surface must not be null");
        Size surfaceSize = SurfaceUtils.getSurfaceSize(surface);
        int surfaceFormat = SurfaceUtils.getSurfaceFormat(surface);
        int surfaceDataspace = SurfaceUtils.getSurfaceDataspace(surface);
        boolean isFlexible = SurfaceUtils.isFlexibleConsumer(surface);
        StreamConfiguration[] streamConfigurationArray = surfaceDataspace == 4096 ? this.mDepthConfigurations : (surfaceDataspace == 4098 ? this.mDynamicDepthConfigurations : (surfaceDataspace == 4100 ? this.mHeicConfigurations : (configs = surfaceDataspace == 4101 ? this.mJpegRConfigurations : this.mConfigurations)));
        if (Flags.cameraHeifGainmap() && surfaceDataspace == 4102) {
            configs = this.mHeicUltraHDRConfigurations;
        }
        for (StreamConfiguration config : configs) {
            if (config.getFormat() != surfaceFormat || !config.isOutput()) continue;
            if (config.getSize().equals(surfaceSize)) {
                return true;
            }
            if (!isFlexible || config.getSize().getWidth() > 1920) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputSupportedFor(Size size, int format) {
        StreamConfiguration[] configs;
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        int dataspace = StreamConfigurationMap.imageFormatToDataspace(format);
        StreamConfiguration[] streamConfigurationArray = dataspace == 4096 ? this.mDepthConfigurations : (dataspace == 4098 ? this.mDynamicDepthConfigurations : (dataspace == 4100 ? this.mHeicConfigurations : (configs = dataspace == 4101 ? this.mJpegRConfigurations : this.mConfigurations)));
        if (Flags.cameraHeifGainmap() && dataspace == 4102) {
            configs = this.mHeicUltraHDRConfigurations;
        }
        for (StreamConfiguration config : configs) {
            if (config.getFormat() != internalFormat || !config.isOutput() || !config.getSize().equals(size)) continue;
            return true;
        }
        return false;
    }

    public <T> Size[] getOutputSizes(Class<T> klass) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            return null;
        }
        return this.getInternalFormatSizes(34, 0, true, false);
    }

    public Size[] getOutputSizes(int format) {
        return this.getPublicFormatSizes(format, true, false);
    }

    public Size[] getHighSpeedVideoSizes() {
        Set<Size> keySet = this.mHighSpeedVideoSizeMap.keySet();
        return keySet.toArray(new Size[keySet.size()]);
    }

    public Range<Integer>[] getHighSpeedVideoFpsRangesFor(Size size) {
        Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
        if (fpsRangeCount == null || fpsRangeCount == 0) {
            throw new IllegalArgumentException(String.format("Size %s does not support high speed video recording", size));
        }
        Range[] fpsRanges = new Range[fpsRangeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!size.equals(config.getSize())) continue;
            fpsRanges[i++] = config.getFpsRange();
        }
        return fpsRanges;
    }

    public Range<Integer>[] getHighSpeedVideoFpsRanges() {
        Set<Range<Integer>> keySet = this.mHighSpeedVideoFpsRangeMap.keySet();
        return keySet.toArray(new Range[keySet.size()]);
    }

    public Size[] getHighSpeedVideoSizesFor(Range<Integer> fpsRange) {
        Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
        if (sizeCount == null || sizeCount == 0) {
            throw new IllegalArgumentException(String.format("FpsRange %s does not support high speed video recording", fpsRange));
        }
        Size[] sizes = new Size[sizeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!fpsRange.equals(config.getFpsRange())) continue;
            sizes[i++] = config.getSize();
        }
        return sizes;
    }

    public Size[] getHighResolutionOutputSizes(int format) {
        if (!this.mListHighResolution) {
            return null;
        }
        return this.getPublicFormatSizes(format, true, true);
    }

    public long getOutputMinFrameDuration(int format, Size size) {
        Objects.requireNonNull(size, "size must not be null");
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), StreamConfigurationMap.imageFormatToDataspace(format), size, 0);
    }

    public <T> long getOutputMinFrameDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, 0, size, 0);
    }

    public long getOutputStallDuration(int format, Size size) {
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), StreamConfigurationMap.imageFormatToDataspace(format), size, 1);
    }

    public <T> long getOutputStallDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, 0, size, 1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StreamConfigurationMap) {
            StreamConfigurationMap other = (StreamConfigurationMap)obj;
            return Arrays.equals(this.mConfigurations, other.mConfigurations) && Arrays.equals(this.mMinFrameDurations, other.mMinFrameDurations) && Arrays.equals(this.mStallDurations, other.mStallDurations) && Arrays.equals(this.mDepthConfigurations, other.mDepthConfigurations) && Arrays.equals(this.mDepthMinFrameDurations, other.mDepthMinFrameDurations) && Arrays.equals(this.mDepthStallDurations, other.mDepthStallDurations) && Arrays.equals(this.mDynamicDepthConfigurations, other.mDynamicDepthConfigurations) && Arrays.equals(this.mDynamicDepthMinFrameDurations, other.mDynamicDepthMinFrameDurations) && Arrays.equals(this.mDynamicDepthStallDurations, other.mDynamicDepthStallDurations) && Arrays.equals(this.mHeicConfigurations, other.mHeicConfigurations) && Arrays.equals(this.mHeicMinFrameDurations, other.mHeicMinFrameDurations) && Arrays.equals(this.mHeicStallDurations, other.mHeicStallDurations) && Arrays.equals(this.mHeicUltraHDRConfigurations, other.mHeicUltraHDRConfigurations) && Arrays.equals(this.mHeicUltraHDRMinFrameDurations, other.mHeicUltraHDRMinFrameDurations) && Arrays.equals(this.mHeicUltraHDRStallDurations, other.mHeicUltraHDRStallDurations) && Arrays.equals(this.mJpegRConfigurations, other.mJpegRConfigurations) && Arrays.equals(this.mJpegRMinFrameDurations, other.mJpegRMinFrameDurations) && Arrays.equals(this.mJpegRStallDurations, other.mJpegRStallDurations) && Arrays.equals(this.mHighSpeedVideoConfigurations, other.mHighSpeedVideoConfigurations);
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCodeGeneric(this.mConfigurations, this.mMinFrameDurations, this.mStallDurations, this.mDepthConfigurations, this.mDepthMinFrameDurations, this.mDepthStallDurations, this.mDynamicDepthConfigurations, this.mDynamicDepthMinFrameDurations, this.mDynamicDepthStallDurations, this.mHeicConfigurations, this.mHeicMinFrameDurations, this.mHeicStallDurations, this.mHeicUltraHDRConfigurations, this.mHeicUltraHDRMinFrameDurations, this.mHeicUltraHDRStallDurations, this.mJpegRConfigurations, this.mJpegRMinFrameDurations, this.mJpegRStallDurations, this.mHighSpeedVideoConfigurations);
    }

    private int checkArgumentFormatSupported(int format, boolean output) {
        StreamConfigurationMap.checkArgumentFormat(format);
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        int internalDataspace = StreamConfigurationMap.imageFormatToDataspace(format);
        if (output) {
            if (Flags.cameraHeifGainmap() && internalDataspace == 4102 && this.mHeicUltraHDROutputFormats.indexOfKey(internalFormat) >= 0) {
                return format;
            }
            if (internalDataspace == 4096 ? this.mDepthOutputFormats.indexOfKey(internalFormat) >= 0 : (internalDataspace == 4098 ? this.mDynamicDepthOutputFormats.indexOfKey(internalFormat) >= 0 : (internalDataspace == 4100 ? this.mHeicOutputFormats.indexOfKey(internalFormat) >= 0 : (internalDataspace == 4101 ? this.mJpegROutputFormats.indexOfKey(internalFormat) >= 0 : this.mAllOutputFormats.indexOfKey(internalFormat) >= 0)))) {
                return format;
            }
        } else if (this.mInputFormats.indexOfKey(internalFormat) >= 0) {
            return format;
        }
        throw new IllegalArgumentException(String.format("format %x is not supported by this stream configuration map", format));
    }

    static int checkArgumentFormatInternal(int format) {
        switch (format) {
            case 33: 
            case 34: 
            case 36: 
            case 540422489: {
                return format;
            }
            case 256: 
            case 1212500294: {
                throw new IllegalArgumentException("An unknown internal format: " + format);
            }
        }
        return StreamConfigurationMap.checkArgumentFormat(format);
    }

    static int checkArgumentFormat(int format) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException(String.format("format 0x%x was not defined in either ImageFormat or PixelFormat", format));
        }
        return format;
    }

    public static int imageFormatToPublic(int format) {
        switch (format) {
            case 33: {
                return 256;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
        }
        return format;
    }

    public static int depthFormatToPublic(int format) {
        switch (format) {
            case 33: {
                return 257;
            }
            case 540422489: {
                return 1144402265;
            }
            case 32: {
                return 4098;
            }
            case 37: {
                return 4099;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
            case 34: {
                throw new IllegalArgumentException("IMPLEMENTATION_DEFINED must not leak to public API");
            }
        }
        throw new IllegalArgumentException("Unknown DATASPACE_DEPTH format " + format);
    }

    static int[] imageFormatToPublic(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToPublic(formats[i]);
        }
        return formats;
    }

    static int imageFormatToInternal(int format) {
        if (Flags.cameraHeifGainmap() && format == 4102) {
            return 33;
        }
        switch (format) {
            case 256: 
            case 257: 
            case 4101: 
            case 1212500294: 
            case 1768253795: {
                return 33;
            }
            case 1144402265: {
                return 540422489;
            }
            case 4098: {
                return 32;
            }
            case 4099: {
                return 37;
            }
        }
        return format;
    }

    static int imageFormatToDataspace(int format) {
        if (Flags.cameraHeifGainmap() && format == 4102) {
            return 4102;
        }
        switch (format) {
            case 256: {
                return 146931712;
            }
            case 257: 
            case 4098: 
            case 4099: 
            case 1144402265: {
                return 4096;
            }
            case 1768253795: {
                return 4098;
            }
            case 1212500294: {
                return 4100;
            }
            case 4101: {
                return 4101;
            }
            case 35: {
                return 146931712;
            }
            case 32: 
            case 36: 
            case 37: 
            case 38: {
                return 1;
            }
        }
        return 0;
    }

    static int internalFormatAndDataspaceToImageFormat(int internalFormat, int dataSpace) {
        if (dataSpace == 4096) {
            return StreamConfigurationMap.depthFormatToPublic(internalFormat);
        }
        if (internalFormat == 33) {
            if (Flags.cameraHeifGainmap() && dataSpace == 4102) {
                return 4102;
            }
            switch (dataSpace) {
                case 4098: {
                    return 1768253795;
                }
                case 4100: {
                    return 1212500294;
                }
                case 4101: {
                    return 4101;
                }
            }
            return 256;
        }
        switch (internalFormat) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: 
            case 17: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 54: 
            case 60: 
            case 538982489: 
            case 540422489: 
            case 842094169: {
                return internalFormat;
            }
        }
        return 0;
    }

    public static int[] imageFormatToInternal(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToInternal(formats[i]);
        }
        return formats;
    }

    private Size[] getPublicFormatSizes(int format, boolean output, boolean highRes) {
        try {
            this.checkArgumentFormatSupported(format, output);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        int dataspace = StreamConfigurationMap.imageFormatToDataspace(format);
        return this.getInternalFormatSizes(internalFormat, dataspace, output, highRes);
    }

    private Size[] getInternalFormatSizes(int format, int dataspace, boolean output, boolean highRes) {
        StreamConfiguration[] configurations;
        if (dataspace == 4096 && highRes) {
            return new Size[0];
        }
        SparseIntArray formatsMap = !output ? this.mInputFormats : (dataspace == 4096 ? this.mDepthOutputFormats : (dataspace == 4098 ? this.mDynamicDepthOutputFormats : (dataspace == 4100 ? this.mHeicOutputFormats : (dataspace == 4101 ? this.mJpegROutputFormats : (highRes ? this.mHighResOutputFormats : this.mOutputFormats)))));
        boolean isDataSpaceHeifUltraHDR = false;
        if (Flags.cameraHeifGainmap() && dataspace == 4102) {
            formatsMap = this.mHeicUltraHDROutputFormats;
            isDataSpaceHeifUltraHDR = true;
        }
        int sizesCount = formatsMap.get(format);
        if ((!output || dataspace == 4096 || dataspace == 4101 || dataspace == 4098 || dataspace == 4100 || isDataSpaceHeifUltraHDR) && sizesCount == 0 || output && dataspace != 4096 && dataspace != 4101 && dataspace != 4098 && !isDataSpaceHeifUltraHDR && dataspace != 4100 && this.mAllOutputFormats.get(format) == 0) {
            return null;
        }
        Size[] sizes = new Size[sizesCount];
        int sizeIndex = 0;
        StreamConfiguration[] streamConfigurationArray = dataspace == 4096 ? this.mDepthConfigurations : (dataspace == 4098 ? this.mDynamicDepthConfigurations : (dataspace == 4100 ? this.mHeicConfigurations : (dataspace == 4101 ? this.mJpegRConfigurations : (configurations = isDataSpaceHeifUltraHDR ? this.mHeicUltraHDRConfigurations : this.mConfigurations))));
        StreamConfigurationDuration[] minFrameDurations = dataspace == 4096 ? this.mDepthMinFrameDurations : (dataspace == 4098 ? this.mDynamicDepthMinFrameDurations : (dataspace == 4100 ? this.mHeicMinFrameDurations : (dataspace == 4101 ? this.mJpegRMinFrameDurations : (isDataSpaceHeifUltraHDR ? this.mHeicUltraHDRMinFrameDurations : this.mMinFrameDurations))));
        for (StreamConfiguration config : configurations) {
            int fmt = config.getFormat();
            if (fmt != format || config.isOutput() != output) continue;
            if (output && this.mListHighResolution) {
                long duration = 0L;
                for (int i = 0; i < minFrameDurations.length; ++i) {
                    StreamConfigurationDuration d = minFrameDurations[i];
                    if (d.getFormat() != fmt || d.getWidth() != config.getSize().getWidth() || d.getHeight() != config.getSize().getHeight()) continue;
                    duration = d.getDuration();
                    break;
                }
                if (dataspace != 4096 && highRes != duration > 50000000L) continue;
            }
            sizes[sizeIndex++] = config.getSize();
        }
        if (sizeIndex != sizesCount && (dataspace == 4098 || dataspace == 4100) || dataspace == 4101 || isDataSpaceHeifUltraHDR) {
            if (sizeIndex > sizesCount) {
                throw new AssertionError((Object)("Too many dynamic depth sizes (expected " + sizesCount + ", actual " + sizeIndex + ")"));
            }
            sizes = sizeIndex <= 0 ? new Size[]{} : Arrays.copyOf(sizes, sizeIndex);
        } else if (sizeIndex != sizesCount) {
            throw new AssertionError((Object)("Too few sizes (expected " + sizesCount + ", actual " + sizeIndex + ")"));
        }
        return sizes;
    }

    private int[] getPublicFormats(boolean output) {
        int j;
        int[] formats = new int[this.getPublicFormatCount(output)];
        int i = 0;
        SparseIntArray map = this.getFormatsMap(output);
        for (j = 0; j < map.size(); ++j) {
            int format = map.keyAt(j);
            formats[i++] = StreamConfigurationMap.imageFormatToPublic(format);
        }
        if (output) {
            for (j = 0; j < this.mDepthOutputFormats.size(); ++j) {
                formats[i++] = StreamConfigurationMap.depthFormatToPublic(this.mDepthOutputFormats.keyAt(j));
            }
            if (this.mDynamicDepthOutputFormats.size() > 0) {
                formats[i++] = 1768253795;
            }
            if (this.mHeicOutputFormats.size() > 0) {
                formats[i++] = 1212500294;
            }
            if (Flags.cameraHeifGainmap() && this.mHeicUltraHDROutputFormats.size() > 0) {
                formats[i++] = 4102;
            }
            if (this.mJpegROutputFormats.size() > 0) {
                formats[i++] = 4101;
            }
        }
        if (formats.length != i) {
            throw new AssertionError((Object)("Too few formats " + i + ", expected " + formats.length));
        }
        return formats;
    }

    private SparseIntArray getFormatsMap(boolean output) {
        return output ? this.mAllOutputFormats : this.mInputFormats;
    }

    private long getInternalFormatDuration(int format, int dataspace, Size size, int duration) {
        StreamConfigurationDuration[] durations;
        if (!this.isSupportedInternalConfiguration(format, dataspace, size)) {
            throw new IllegalArgumentException("size was not supported");
        }
        for (StreamConfigurationDuration configurationDuration : durations = this.getDurations(duration, dataspace)) {
            if (configurationDuration.getFormat() != format || configurationDuration.getWidth() != size.getWidth() || configurationDuration.getHeight() != size.getHeight()) continue;
            return configurationDuration.getDuration();
        }
        return 0L;
    }

    private StreamConfigurationDuration[] getDurations(int duration, int dataspace) {
        boolean isDataSpaceHeifUltraHDR = false;
        if (Flags.cameraHeifGainmap() && dataspace == 4102) {
            isDataSpaceHeifUltraHDR = true;
        }
        switch (duration) {
            case 0: {
                return dataspace == 4096 ? this.mDepthMinFrameDurations : (dataspace == 4098 ? this.mDynamicDepthMinFrameDurations : (dataspace == 4100 ? this.mHeicMinFrameDurations : (isDataSpaceHeifUltraHDR ? this.mHeicUltraHDRMinFrameDurations : (dataspace == 4101 ? this.mJpegRMinFrameDurations : this.mMinFrameDurations))));
            }
            case 1: {
                return dataspace == 4096 ? this.mDepthStallDurations : (dataspace == 4098 ? this.mDynamicDepthStallDurations : (dataspace == 4100 ? this.mHeicStallDurations : (isDataSpaceHeifUltraHDR ? this.mHeicUltraHDRStallDurations : (dataspace == 4101 ? this.mJpegRStallDurations : this.mStallDurations))));
            }
        }
        throw new IllegalArgumentException("duration was invalid");
    }

    private int getPublicFormatCount(boolean output) {
        SparseIntArray formatsMap = this.getFormatsMap(output);
        int size = formatsMap.size();
        if (output) {
            size += this.mDepthOutputFormats.size();
            size += this.mDynamicDepthOutputFormats.size();
            size += this.mHeicOutputFormats.size();
            size += this.mJpegROutputFormats.size();
            size += this.mHeicUltraHDROutputFormats.size();
        }
        return size;
    }

    private static <T> boolean arrayContains(T[] array2, T element) {
        if (array2 == null) {
            return false;
        }
        for (T el : array2) {
            if (!Objects.equals(el, element)) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportedInternalConfiguration(int format, int dataspace, Size size) {
        boolean isDataSpaceHeifUltraHDR = false;
        if (Flags.cameraHeifGainmap() && dataspace == 4102) {
            isDataSpaceHeifUltraHDR = true;
        }
        StreamConfiguration[] configurations = dataspace == 4096 ? this.mDepthConfigurations : (dataspace == 4098 ? this.mDynamicDepthConfigurations : (dataspace == 4100 ? this.mHeicConfigurations : (dataspace == 4101 ? this.mJpegRConfigurations : (isDataSpaceHeifUltraHDR ? this.mHeicUltraHDRConfigurations : this.mConfigurations))));
        for (int i = 0; i < configurations.length; ++i) {
            if (configurations[i].getFormat() != format || !configurations[i].getSize().equals(size)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StreamConfiguration(");
        this.appendOutputsString(sb);
        sb.append(", ");
        this.appendHighResOutputsString(sb);
        sb.append(", ");
        this.appendInputsString(sb);
        sb.append(", ");
        this.appendValidOutputFormatsForInputString(sb);
        sb.append(", ");
        this.appendHighSpeedVideoConfigurationsString(sb);
        sb.append(")");
        return sb.toString();
    }

    public static int compareSizes(int widthA, int heightA, int widthB, int heightB) {
        long left = (long)widthA * (long)heightA;
        long right = (long)widthB * (long)heightB;
        if (left == right) {
            left = widthA;
            right = widthB;
        }
        return left < right ? -1 : (left > right ? 1 : 0);
    }

    private void appendOutputsString(StringBuilder sb) {
        int[] formats;
        sb.append("Outputs(");
        for (int format : formats = this.getOutputFormats()) {
            Size[] sizes;
            for (Size size : sizes = this.getOutputSizes(format)) {
                long minFrameDuration = this.getOutputMinFrameDuration(format, size);
                long stallDuration = this.getOutputStallDuration(format, size);
                sb.append(String.format("[w:%d, h:%d, format:%s(%d), min_duration:%d, stall:%d], ", size.getWidth(), size.getHeight(), StreamConfigurationMap.formatToString(format), format, minFrameDuration, stallDuration));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private void appendHighResOutputsString(StringBuilder sb) {
        int[] formats;
        sb.append("HighResolutionOutputs(");
        for (int format : formats = this.getOutputFormats()) {
            Size[] sizes = this.getHighResolutionOutputSizes(format);
            if (sizes == null) continue;
            for (Size size : sizes) {
                long minFrameDuration = this.getOutputMinFrameDuration(format, size);
                long stallDuration = this.getOutputStallDuration(format, size);
                sb.append(String.format("[w:%d, h:%d, format:%s(%d), min_duration:%d, stall:%d], ", size.getWidth(), size.getHeight(), StreamConfigurationMap.formatToString(format), format, minFrameDuration, stallDuration));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private void appendInputsString(StringBuilder sb) {
        int[] formats;
        sb.append("Inputs(");
        for (int format : formats = this.getInputFormats()) {
            Size[] sizes;
            for (Size size : sizes = this.getInputSizes(format)) {
                sb.append(String.format("[w:%d, h:%d, format:%s(%d)], ", size.getWidth(), size.getHeight(), StreamConfigurationMap.formatToString(format), format));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private void appendValidOutputFormatsForInputString(StringBuilder sb) {
        int[] inputFormats;
        sb.append("ValidOutputFormatsForInput(");
        for (int inputFormat : inputFormats = this.getInputFormats()) {
            sb.append(String.format("[in:%s(%d), out:", StreamConfigurationMap.formatToString(inputFormat), inputFormat));
            int[] outputFormats = this.getValidOutputFormatsForInput(inputFormat);
            for (int i = 0; i < outputFormats.length; ++i) {
                sb.append(String.format("%s(%d)", StreamConfigurationMap.formatToString(outputFormats[i]), outputFormats[i]));
                if (i >= outputFormats.length - 1) continue;
                sb.append(", ");
            }
            sb.append("], ");
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private void appendHighSpeedVideoConfigurationsString(StringBuilder sb) {
        Size[] sizes;
        sb.append("HighSpeedVideoConfigurations(");
        for (Size size : sizes = this.getHighSpeedVideoSizes()) {
            Range<Integer>[] ranges;
            for (Range<Integer> range : ranges = this.getHighSpeedVideoFpsRangesFor(size)) {
                sb.append(String.format("[w:%d, h:%d, min_fps:%d, max_fps:%d], ", size.getWidth(), size.getHeight(), range.getLower(), range.getUpper()));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    public static String formatToString(int format) {
        if (Flags.cameraHeifGainmap() && format == 4102) {
            return "HEIC_ULTRAHDR";
        }
        switch (format) {
            case 842094169: {
                return "YV12";
            }
            case 35: {
                return "YUV_420_888";
            }
            case 17: {
                return "NV21";
            }
            case 16: {
                return "NV16";
            }
            case 4: {
                return "RGB_565";
            }
            case 1: {
                return "RGBA_8888";
            }
            case 2: {
                return "RGBX_8888";
            }
            case 3: {
                return "RGB_888";
            }
            case 256: {
                return "JPEG";
            }
            case 20: {
                return "YUY2";
            }
            case 538982489: {
                return "Y8";
            }
            case 540422489: {
                return "Y16";
            }
            case 32: {
                return "RAW_SENSOR";
            }
            case 36: {
                return "RAW_PRIVATE";
            }
            case 37: {
                return "RAW10";
            }
            case 1144402265: {
                return "DEPTH16";
            }
            case 257: {
                return "DEPTH_POINT_CLOUD";
            }
            case 1768253795: {
                return "DEPTH_JPEG";
            }
            case 4098: {
                return "RAW_DEPTH";
            }
            case 4099: {
                return "RAW_DEPTH10";
            }
            case 34: {
                return "PRIVATE";
            }
            case 1212500294: {
                return "HEIC";
            }
            case 4101: {
                return "JPEG/R";
            }
        }
        return "UNKNOWN";
    }
}

