/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.graphics.ColorSpace;
import android.util.Log;
import android.util.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SystemApi
@FlaggedApi(value="com.android.internal.camera.flags.camera_multi_client")
public class SharedSessionConfiguration {
    private static final String TAG = "SharedSessionConfiguration";
    private static final int SHARED_OUTPUT_CONFIG_NUM_OF_ENTRIES = 11;
    private int mColorSpace;
    private final ArrayList<SharedOutputConfiguration> mOutputStreamConfigurations = new ArrayList();

    public SharedSessionConfiguration(int sharedColorSpace, @NonNull long[] sharedOutputConfigurations) {
        int numOfEntries;
        int physicalCameraIdLen;
        this.mColorSpace = sharedColorSpace;
        int i = 0;
        for (numOfEntries = sharedOutputConfigurations.length; numOfEntries >= 11; numOfEntries -= physicalCameraIdLen) {
            long asciiValue;
            int surfaceType = (int)sharedOutputConfigurations[i];
            int width = (int)sharedOutputConfigurations[i + 1];
            int height = (int)sharedOutputConfigurations[i + 2];
            int format = (int)sharedOutputConfigurations[i + 3];
            int mirrorMode = (int)sharedOutputConfigurations[i + 4];
            boolean isReadOutTimestampEnabled = sharedOutputConfigurations[i + 5] != 0L;
            int timestampBase = (int)sharedOutputConfigurations[i + 6];
            int dataspace = (int)sharedOutputConfigurations[i + 7];
            long usage = sharedOutputConfigurations[i + 8];
            long streamUseCase = sharedOutputConfigurations[i + 9];
            physicalCameraIdLen = (int)sharedOutputConfigurations[i + 10];
            i += 11;
            if ((numOfEntries -= 11) < physicalCameraIdLen) {
                Log.e(TAG, "Number of remaining data in shared configuration is less than physical camera id length . Malformed metadata android.info.availableSharedOutputConfigurations.");
                break;
            }
            StringBuilder physicalCameraId = new StringBuilder();
            for (int j = 0; j < physicalCameraIdLen && (asciiValue = sharedOutputConfigurations[i + j]) != 0L; ++j) {
                physicalCameraId.append((char)asciiValue);
            }
            SharedOutputConfiguration outputInfo = new SharedOutputConfiguration(surfaceType, new Size(width, height), format, mirrorMode, isReadOutTimestampEnabled, timestampBase, dataspace, usage, streamUseCase, physicalCameraId.toString());
            this.mOutputStreamConfigurations.add(outputInfo);
            i += physicalCameraIdLen;
        }
        if (numOfEntries != 0) {
            Log.e(TAG, "Unexpected entries left in shared output configuration. Malformed metadata android.info.availableSharedOutputConfigurations.");
        }
    }

    @SuppressLint(value={"MethodNameUnits"})
    @Nullable
    public ColorSpace getColorSpace() {
        if (this.mColorSpace != -1) {
            return ColorSpace.get(ColorSpace.Named.values()[this.mColorSpace]);
        }
        return null;
    }

    @NonNull
    public List<SharedOutputConfiguration> getOutputStreamsInformation() {
        return Collections.unmodifiableList(this.mOutputStreamConfigurations);
    }

    public static class SharedOutputConfiguration {
        private final int mSurfaceType;
        private final Size mSize;
        private final int mFormat;
        private final int mDataspace;
        private final long mStreamUseCase;
        private String mPhysicalCameraId;
        private final long mUsage;
        private int mTimestampBase;
        private int mMirrorMode;
        private boolean mReadoutTimestampEnabled;

        public SharedOutputConfiguration(int surfaceType, @NonNull Size sz, int format, int mirrorMode, boolean readoutTimeStampEnabled, int timestampBase, int dataspace, long usage, long streamUseCase, @Nullable String physicalCamId) {
            this.mSurfaceType = surfaceType;
            this.mSize = sz;
            this.mFormat = format;
            this.mMirrorMode = mirrorMode;
            this.mReadoutTimestampEnabled = readoutTimeStampEnabled;
            this.mTimestampBase = timestampBase;
            this.mDataspace = dataspace;
            this.mUsage = usage;
            this.mStreamUseCase = streamUseCase;
            this.mPhysicalCameraId = physicalCamId;
        }

        public int getSurfaceType() {
            return this.mSurfaceType;
        }

        public int getFormat() {
            return this.mFormat;
        }

        @NonNull
        public Size getSize() {
            return this.mSize;
        }

        public int getDataspace() {
            return this.mDataspace;
        }

        public int getMirrorMode() {
            return this.mMirrorMode;
        }

        public long getStreamUseCase() {
            return this.mStreamUseCase;
        }

        public int getTimestampBase() {
            return this.mTimestampBase;
        }

        public boolean isReadoutTimestampEnabled() {
            return this.mReadoutTimestampEnabled;
        }

        public long getUsage() {
            return this.mUsage;
        }

        @Nullable
        public String getPhysicalCameraId() {
            return this.mPhysicalCameraId.isEmpty() ? null : this.mPhysicalCameraId;
        }
    }
}

