/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.NonNull;
import java.util.Objects;

public class MultiResolutionStreamInfo {
    private int mStreamWidth;
    private int mStreamHeight;
    private String mPhysicalCameraId;

    public MultiResolutionStreamInfo(int streamWidth, int streamHeight, @NonNull String physicalCameraId) {
        if (streamWidth <= 0) {
            throw new IllegalArgumentException("Invalid stream width " + streamWidth);
        }
        if (streamHeight <= 0) {
            throw new IllegalArgumentException("Invalid stream height " + streamHeight);
        }
        this.mStreamWidth = streamWidth;
        this.mStreamHeight = streamHeight;
        this.mPhysicalCameraId = physicalCameraId;
    }

    public int getWidth() {
        return this.mStreamWidth;
    }

    public int getHeight() {
        return this.mStreamHeight;
    }

    @NonNull
    public String getPhysicalCameraId() {
        return this.mPhysicalCameraId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiResolutionStreamInfo) {
            MultiResolutionStreamInfo other = (MultiResolutionStreamInfo)obj;
            return this.mStreamWidth == other.mStreamWidth && this.mStreamHeight == other.mStreamHeight && this.mPhysicalCameraId.equals(other.mPhysicalCameraId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mStreamWidth, this.mStreamHeight, this.mPhysicalCameraId);
    }
}

