/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.RecommendedStreamConfiguration;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableRecommendedStreamConfiguration
implements MarshalQueryable<RecommendedStreamConfiguration> {
    private static final int SIZE = 20;

    @Override
    public Marshaler<RecommendedStreamConfiguration> createMarshaler(TypeReference<RecommendedStreamConfiguration> managedType, int nativeType) {
        return new MarshalerRecommendedStreamConfiguration(this, managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<RecommendedStreamConfiguration> managedType, int nativeType) {
        return nativeType == 1 && managedType.getType().equals(RecommendedStreamConfiguration.class);
    }

    private class MarshalerRecommendedStreamConfiguration
    extends Marshaler<RecommendedStreamConfiguration> {
        protected MarshalerRecommendedStreamConfiguration(MarshalQueryableRecommendedStreamConfiguration marshalQueryableRecommendedStreamConfiguration, TypeReference<RecommendedStreamConfiguration> typeReference, int nativeType) {
            super(marshalQueryableRecommendedStreamConfiguration, typeReference, nativeType);
        }

        @Override
        public void marshal(RecommendedStreamConfiguration value, ByteBuffer buffer) {
            buffer.putInt(value.getWidth());
            buffer.putInt(value.getHeight());
            buffer.putInt(value.getFormat());
            buffer.putInt(value.isInput() ? 1 : 0);
            buffer.putInt(value.getUsecaseBitmap());
        }

        @Override
        public RecommendedStreamConfiguration unmarshal(ByteBuffer buffer) {
            int width = buffer.getInt();
            int height = buffer.getInt();
            int format = buffer.getInt();
            boolean input = buffer.getInt() != 0;
            int usecaseBitmap = buffer.getInt();
            return new RecommendedStreamConfiguration(format, width, height, input, usecaseBitmap);
        }

        @Override
        public int getNativeSize() {
            return 20;
        }
    }
}

