/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.utils.TypeReference;
import com.android.internal.util.Preconditions;
import java.nio.ByteBuffer;

public abstract class Marshaler<T> {
    protected final TypeReference<T> mTypeReference;
    protected final int mNativeType;
    public static int NATIVE_SIZE_DYNAMIC = -1;

    protected Marshaler(MarshalQueryable<T> query, TypeReference<T> typeReference, int nativeType) {
        this.mTypeReference = Preconditions.checkNotNull(typeReference, "typeReference must not be null");
        this.mNativeType = MarshalHelpers.checkNativeType(nativeType);
        if (!query.isTypeMappingSupported(typeReference, nativeType)) {
            throw new UnsupportedOperationException("Unsupported type marshaling for managed type " + typeReference + " and native type " + MarshalHelpers.toStringNativeType(nativeType));
        }
    }

    public abstract void marshal(T var1, ByteBuffer var2);

    public int calculateMarshalSize(T value) {
        int nativeSize = this.getNativeSize();
        if (nativeSize == NATIVE_SIZE_DYNAMIC) {
            throw new AssertionError((Object)"Override this function for dynamically-sized objects");
        }
        return nativeSize;
    }

    public abstract T unmarshal(ByteBuffer var1);

    public abstract int getNativeSize();

    public TypeReference<T> getTypeReference() {
        return this.mTypeReference;
    }

    public int getNativeType() {
        return this.mNativeType;
    }
}

