/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.utils.SubmitInfo;
import java.util.List;

public class RequestLastFrameNumbersHolder {
    private final int mRequestId;
    private final long mLastRegularFrameNumber;
    private final long mLastReprocessFrameNumber;
    private final long mLastZslStillFrameNumber;
    private boolean mSequenceCompleted;
    private boolean mInflightCompleted;

    public RequestLastFrameNumbersHolder(List<CaptureRequest> requestList, SubmitInfo requestInfo) {
        long lastRegularFrameNumber = -1L;
        long lastReprocessFrameNumber = -1L;
        long lastZslStillFrameNumber = -1L;
        long frameNumber = requestInfo.getLastFrameNumber();
        if (requestInfo.getLastFrameNumber() < (long)(requestList.size() - 1)) {
            throw new IllegalArgumentException("lastFrameNumber: " + requestInfo.getLastFrameNumber() + " should be at least " + (requestList.size() - 1) + " for the number of  requests in the list: " + requestList.size());
        }
        for (int i = requestList.size() - 1; i >= 0; --i) {
            CaptureRequest request = requestList.get(i);
            int requestType = request.getRequestType();
            if (requestType == 1 && lastReprocessFrameNumber == -1L) {
                lastReprocessFrameNumber = frameNumber;
            } else if (requestType == 2 && lastZslStillFrameNumber == -1L) {
                lastZslStillFrameNumber = frameNumber;
            } else if (requestType == 0 && lastRegularFrameNumber == -1L) {
                lastRegularFrameNumber = frameNumber;
            }
            if (lastReprocessFrameNumber != -1L && lastZslStillFrameNumber != -1L && lastRegularFrameNumber != -1L) break;
            --frameNumber;
        }
        this.mLastRegularFrameNumber = lastRegularFrameNumber;
        this.mLastReprocessFrameNumber = lastReprocessFrameNumber;
        this.mLastZslStillFrameNumber = lastZslStillFrameNumber;
        this.mRequestId = requestInfo.getRequestId();
        this.mSequenceCompleted = false;
        this.mInflightCompleted = false;
    }

    RequestLastFrameNumbersHolder(int requestId, long lastFrameNumber, int[] repeatingRequestTypes) {
        long lastRegularFrameNumber = -1L;
        long lastZslStillFrameNumber = -1L;
        if (repeatingRequestTypes == null) {
            throw new IllegalArgumentException("repeatingRequest list must not be null");
        }
        if (lastFrameNumber < (long)(repeatingRequestTypes.length - 1)) {
            throw new IllegalArgumentException("lastFrameNumber: " + lastFrameNumber + " should be at least " + (repeatingRequestTypes.length - 1) + " for the number of requests in the list: " + repeatingRequestTypes.length);
        }
        long frameNumber = lastFrameNumber;
        for (int i = repeatingRequestTypes.length - 1; i >= 0; --i) {
            if (repeatingRequestTypes[i] == 2 && lastZslStillFrameNumber == -1L) {
                lastZslStillFrameNumber = frameNumber;
            } else if (repeatingRequestTypes[i] == 0 && lastRegularFrameNumber == -1L) {
                lastRegularFrameNumber = frameNumber;
            }
            if (lastZslStillFrameNumber != -1L && lastRegularFrameNumber != -1L) break;
            --frameNumber;
        }
        this.mLastRegularFrameNumber = lastRegularFrameNumber;
        this.mLastZslStillFrameNumber = lastZslStillFrameNumber;
        this.mLastReprocessFrameNumber = -1L;
        this.mRequestId = requestId;
        this.mSequenceCompleted = false;
        this.mInflightCompleted = false;
    }

    public long getLastRegularFrameNumber() {
        return this.mLastRegularFrameNumber;
    }

    public long getLastReprocessFrameNumber() {
        return this.mLastReprocessFrameNumber;
    }

    public long getLastZslStillFrameNumber() {
        return this.mLastZslStillFrameNumber;
    }

    public long getLastFrameNumber() {
        return Math.max(this.mLastZslStillFrameNumber, Math.max(this.mLastRegularFrameNumber, this.mLastReprocessFrameNumber));
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public boolean isSequenceCompleted() {
        return this.mSequenceCompleted;
    }

    public void markSequenceCompleted() {
        this.mSequenceCompleted = true;
    }

    public boolean isInflightCompleted() {
        return this.mInflightCompleted;
    }

    public void markInflightCompleted() {
        this.mInflightCompleted = true;
    }
}

